/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common.query.xpath.visitors;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.overlord.sramp.common.query.xpath.ast.AndExpr;
import org.overlord.sramp.common.query.xpath.ast.Argument;
import org.overlord.sramp.common.query.xpath.ast.ArtifactSet;
import org.overlord.sramp.common.query.xpath.ast.EqualityExpr;
import org.overlord.sramp.common.query.xpath.ast.Expr;
import org.overlord.sramp.common.query.xpath.ast.ForwardPropertyStep;
import org.overlord.sramp.common.query.xpath.ast.FunctionCall;
import org.overlord.sramp.common.query.xpath.ast.LocationPath;
import org.overlord.sramp.common.query.xpath.ast.OrExpr;
import org.overlord.sramp.common.query.xpath.ast.Predicate;
import org.overlord.sramp.common.query.xpath.ast.PrimaryExpr;
import org.overlord.sramp.common.query.xpath.ast.Query;
import org.overlord.sramp.common.query.xpath.ast.RelationshipPath;
import org.overlord.sramp.common.query.xpath.ast.SubartifactSet;
import org.overlord.sramp.common.query.xpath.visitors.XPathVisitor;

public class XPathSerializationVisitor
implements XPathVisitor {
    private StringBuilder builder = new StringBuilder();

    public void reset() {
        this.builder = new StringBuilder();
    }

    public String getXPath() {
        return this.builder.toString();
    }

    @Override
    public void visit(AndExpr node) {
        ((OrExpr)node.getLeft()).accept(this);
        if (node.getRight() != null) {
            this.builder.append(" and ");
            ((AndExpr)node.getRight()).accept(this);
        }
    }

    @Override
    public void visit(Argument node) {
        if (node.getPrimaryExpr() != null) {
            this.visit(node.getPrimaryExpr());
        } else if (node.getExpr() != null) {
            node.getExpr().accept(this);
        }
    }

    @Override
    public void visit(ArtifactSet node) {
        node.getLocationPath().accept(this);
    }

    @Override
    public void visit(EqualityExpr node) {
        if (node.getSubartifactSet() != null) {
            node.getSubartifactSet().accept(this);
        } else if (node.getExpr() != null) {
            this.builder.append("(");
            node.getExpr().accept(this);
            this.builder.append(")");
        } else {
            ((ForwardPropertyStep)node.getLeft()).accept(this);
            if (node.getOperator() != null) {
                this.builder.append(' ');
                this.builder.append(node.getOperator().symbol());
                this.builder.append(' ');
                ((PrimaryExpr)node.getRight()).accept(this);
            }
        }
    }

    @Override
    public void visit(Expr node) {
        node.getAndExpr().accept(this);
    }

    @Override
    public void visit(ForwardPropertyStep node) {
        if (node.getPropertyQName() != null) {
            this.builder.append('@');
            this.appendQName(node.getPropertyQName());
        }
    }

    @Override
    public void visit(FunctionCall node) {
        QName functionName = node.getFunctionName();
        if (functionName.getPrefix() != null && functionName.getPrefix().trim().length() > 0 && !"s-ramp".equals(functionName.getPrefix())) {
            this.builder.append(functionName.getPrefix());
            this.builder.append(':');
        }
        this.builder.append(functionName.getLocalPart());
        this.builder.append('(');
        Iterator<Argument> iterator = node.getArguments().iterator();
        while (iterator.hasNext()) {
            iterator.next().accept(this);
            if (!iterator.hasNext()) continue;
            this.builder.append(", ");
        }
        this.builder.append(')');
    }

    @Override
    public void visit(LocationPath node) {
        this.builder.append("/s-ramp");
        if (node.getArtifactModel() != null) {
            this.builder.append('/');
            this.builder.append(node.getArtifactModel());
            if (node.getArtifactType() != null) {
                this.builder.append('/');
                this.builder.append(node.getArtifactType());
            }
        }
    }

    @Override
    public void visit(OrExpr node) {
        ((EqualityExpr)node.getLeft()).accept(this);
        if (node.getRight() != null) {
            this.builder.append(" or ");
            ((OrExpr)node.getRight()).accept(this);
        }
    }

    @Override
    public void visit(Predicate node) {
        node.getExpr().accept(this);
    }

    @Override
    public void visit(PrimaryExpr node) {
        if (node.getLiteral() != null) {
            this.builder.append("'");
            this.builder.append(node.getLiteral().replace("'", "''"));
            this.builder.append("'");
        } else if (node.getNumber() != null) {
            this.builder.append(node.getNumber().toString());
        } else if (node.getPropertyQName() != null) {
            this.builder.append("$");
            this.appendQName(node.getPropertyQName());
        }
    }

    private void appendQName(QName qname) {
        if (qname.getPrefix() != null && qname.getPrefix().trim().length() > 0) {
            this.builder.append(qname.getPrefix());
            this.builder.append(":");
        }
        this.builder.append(qname.getLocalPart());
    }

    @Override
    public void visit(Query node) {
        node.getArtifactSet().accept(this);
        if (node.getPredicate() != null) {
            this.builder.append('[');
            node.getPredicate().accept(this);
            this.builder.append(']');
        }
        if (node.getSubartifactSet() != null) {
            this.builder.append('/');
            node.getSubartifactSet().accept(this);
        }
    }

    @Override
    public void visit(RelationshipPath node) {
        this.builder.append(node.getRelationshipType());
    }

    @Override
    public void visit(SubartifactSet node) {
        if (node.getFunctionCall() != null) {
            node.getFunctionCall().accept(this);
        } else {
            node.getRelationshipPath().accept(this);
            if (node.getPredicate() != null) {
                this.builder.append('[');
                node.getPredicate().accept(this);
                this.builder.append(']');
            }
            if (node.getSubartifactSet() != null) {
                this.builder.append('/');
                node.getSubartifactSet().accept(this);
            }
        }
    }
}

