/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.io.IOUtils;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.ArtifactTypeEnum;

public class MimeTypes {
    private static final MimetypesFileTypeMap mimeTypes = new MimetypesFileTypeMap();

    public static String getContentType(String name) {
        if (name == null) {
            return null;
        }
        return mimeTypes.getContentType(name);
    }

    public static String determineMimeType(String contentType, String fileName, ArtifactType artifactType) {
        if (artifactType.getArtifactType() == ArtifactTypeEnum.Document || artifactType.getArtifactType() == ArtifactTypeEnum.ExtendedArtifactType) {
            String ct;
            if (contentType != null && contentType.trim().length() > 0) {
                return contentType;
            }
            if (fileName != null && (ct = MimeTypes.getContentType(fileName)) != null) {
                return ct;
            }
            return "application/octet-stream";
        }
        return "application/xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream is = null;
        try {
            is = MimeTypes.class.getResourceAsStream("mime.types");
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = reader.readLine();
            StringBuilder buff = new StringBuilder();
            while (line != null) {
                buff.append(line);
                buff.append("\n");
                line = reader.readLine();
            }
            mimeTypes.addMimeTypes(buff.toString());
        }
        catch (Throwable throwable) {
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }
}

