/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common.derived;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.overlord.sramp.common.derived.IndexedArtifactCollection;
import org.overlord.sramp.common.derived.XsdDeriver;
import org.overlord.sramp.common.query.xpath.StaticNamespaceContext;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactEnum;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.Binding;
import org.s_ramp.xmlns._2010.s_ramp.BindingEnum;
import org.s_ramp.xmlns._2010.s_ramp.BindingOperation;
import org.s_ramp.xmlns._2010.s_ramp.BindingOperationEnum;
import org.s_ramp.xmlns._2010.s_ramp.BindingOperationFault;
import org.s_ramp.xmlns._2010.s_ramp.BindingOperationFaultEnum;
import org.s_ramp.xmlns._2010.s_ramp.BindingOperationFaultTarget;
import org.s_ramp.xmlns._2010.s_ramp.BindingOperationInput;
import org.s_ramp.xmlns._2010.s_ramp.BindingOperationInputEnum;
import org.s_ramp.xmlns._2010.s_ramp.BindingOperationInputTarget;
import org.s_ramp.xmlns._2010.s_ramp.BindingOperationOutput;
import org.s_ramp.xmlns._2010.s_ramp.BindingOperationOutputEnum;
import org.s_ramp.xmlns._2010.s_ramp.BindingOperationOutputTarget;
import org.s_ramp.xmlns._2010.s_ramp.BindingOperationTarget;
import org.s_ramp.xmlns._2010.s_ramp.BindingTarget;
import org.s_ramp.xmlns._2010.s_ramp.ElementDeclaration;
import org.s_ramp.xmlns._2010.s_ramp.ElementEnum;
import org.s_ramp.xmlns._2010.s_ramp.ElementTarget;
import org.s_ramp.xmlns._2010.s_ramp.Fault;
import org.s_ramp.xmlns._2010.s_ramp.FaultEnum;
import org.s_ramp.xmlns._2010.s_ramp.FaultTarget;
import org.s_ramp.xmlns._2010.s_ramp.Message;
import org.s_ramp.xmlns._2010.s_ramp.MessageEnum;
import org.s_ramp.xmlns._2010.s_ramp.MessageTarget;
import org.s_ramp.xmlns._2010.s_ramp.Operation;
import org.s_ramp.xmlns._2010.s_ramp.OperationEnum;
import org.s_ramp.xmlns._2010.s_ramp.OperationInput;
import org.s_ramp.xmlns._2010.s_ramp.OperationInputEnum;
import org.s_ramp.xmlns._2010.s_ramp.OperationInputTarget;
import org.s_ramp.xmlns._2010.s_ramp.OperationOutput;
import org.s_ramp.xmlns._2010.s_ramp.OperationOutputEnum;
import org.s_ramp.xmlns._2010.s_ramp.OperationOutputTarget;
import org.s_ramp.xmlns._2010.s_ramp.OperationTarget;
import org.s_ramp.xmlns._2010.s_ramp.Part;
import org.s_ramp.xmlns._2010.s_ramp.PartEnum;
import org.s_ramp.xmlns._2010.s_ramp.PartTarget;
import org.s_ramp.xmlns._2010.s_ramp.Port;
import org.s_ramp.xmlns._2010.s_ramp.PortEnum;
import org.s_ramp.xmlns._2010.s_ramp.PortTarget;
import org.s_ramp.xmlns._2010.s_ramp.PortType;
import org.s_ramp.xmlns._2010.s_ramp.PortTypeEnum;
import org.s_ramp.xmlns._2010.s_ramp.PortTypeTarget;
import org.s_ramp.xmlns._2010.s_ramp.SoapAddress;
import org.s_ramp.xmlns._2010.s_ramp.SoapBinding;
import org.s_ramp.xmlns._2010.s_ramp.WsdlDocument;
import org.s_ramp.xmlns._2010.s_ramp.WsdlExtensionEnum;
import org.s_ramp.xmlns._2010.s_ramp.WsdlExtensionTarget;
import org.s_ramp.xmlns._2010.s_ramp.WsdlService;
import org.s_ramp.xmlns._2010.s_ramp.XsdType;
import org.s_ramp.xmlns._2010.s_ramp.XsdTypeEnum;
import org.s_ramp.xmlns._2010.s_ramp.XsdTypeTarget;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WsdlDeriver
extends XsdDeriver {
    @Override
    protected void configureNamespaceMappings(StaticNamespaceContext namespaceContext) {
        super.configureNamespaceMappings(namespaceContext);
        namespaceContext.addMapping("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        namespaceContext.addMapping("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
    }

    @Override
    protected Collection<BaseArtifactType> createDerivedArtifactCollection() {
        return new IndexedArtifactCollection();
    }

    @Override
    protected void derive(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType artifact, Element rootElement, XPath xpath) throws IOException {
        String targetNS = rootElement.getAttribute("targetNamespace");
        ((WsdlDocument)artifact).setTargetNamespace(targetNS);
        try {
            this.processDefinitions((IndexedArtifactCollection)derivedArtifacts, artifact, rootElement, xpath);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void processDefinitions(IndexedArtifactCollection derivedArtifacts, BaseArtifactType artifact, Element definitions, XPath xpath) throws XPathExpressionException {
        NodeList schemas = (NodeList)this.query(xpath, definitions, "./wsdl:types/xsd:schema", XPathConstants.NODESET);
        for (int idx = 0; idx < schemas.getLength(); ++idx) {
            Element schema = (Element)schemas.item(idx);
            this.processSchema(derivedArtifacts, artifact, schema, xpath);
        }
        this.processMessages(derivedArtifacts, artifact, definitions, xpath);
        this.processPortTypes(derivedArtifacts, artifact, definitions, xpath);
        this.processBindings(derivedArtifacts, artifact, definitions, xpath);
        this.processServices(derivedArtifacts, artifact, definitions, xpath);
    }

    private void processMessages(IndexedArtifactCollection derivedArtifacts, BaseArtifactType sourceArtifact, Element definitions, XPath xpath) throws XPathExpressionException {
        String targetNS = definitions.getAttribute("targetNamespace");
        NodeList messages = (NodeList)this.query(xpath, definitions, "./wsdl:message", XPathConstants.NODESET);
        for (int idx = 0; idx < messages.getLength(); ++idx) {
            Element messageElem = (Element)messages.item(idx);
            if (!messageElem.hasAttribute("name")) continue;
            String name = messageElem.getAttribute("name");
            Message message = new Message();
            message.setUuid(UUID.randomUUID().toString());
            message.setArtifactType(BaseArtifactEnum.MESSAGE);
            message.setName(name);
            message.setNamespace(targetNS);
            message.setNCName(name);
            derivedArtifacts.add((BaseArtifactType)message);
            Collection<Part> parts = this.processParts(derivedArtifacts, sourceArtifact, messageElem, xpath);
            for (Part part : parts) {
                PartTarget target = new PartTarget();
                target.setValue(part.getUuid());
                target.setArtifactType(PartEnum.PART);
                message.getPart().add(target);
            }
        }
    }

    private Collection<Part> processParts(IndexedArtifactCollection derivedArtifacts, BaseArtifactType sourceArtifact, Element messageElem, XPath xpath) throws XPathExpressionException {
        LinkedList<Part> rval = new LinkedList<Part>();
        String targetNS = messageElem.getOwnerDocument().getDocumentElement().getAttribute("targetNamespace");
        NodeList parts = (NodeList)this.query(xpath, messageElem, "./wsdl:part", XPathConstants.NODESET);
        for (int idx = 0; idx < parts.getLength(); ++idx) {
            XsdType typeRef;
            QName qname;
            String encodedQName;
            Element partElem = (Element)parts.item(idx);
            if (!partElem.hasAttribute("name")) continue;
            String name = partElem.getAttribute("name");
            Part part = new Part();
            part.setUuid(UUID.randomUUID().toString());
            part.setArtifactType(BaseArtifactEnum.PART);
            part.setName(name);
            part.setNamespace(targetNS);
            part.setNCName(name);
            derivedArtifacts.add((BaseArtifactType)part);
            rval.add(part);
            if (partElem.hasAttribute("element")) {
                encodedQName = partElem.getAttribute("element");
                qname = this.resolveQName(partElem, targetNS, encodedQName);
                ElementDeclaration elementRef = derivedArtifacts.lookupElement(qname);
                if (elementRef == null) continue;
                ElementTarget elementTarget = new ElementTarget();
                elementTarget.setValue(elementRef.getUuid());
                elementTarget.setArtifactType(ElementEnum.ELEMENT);
                part.setElement(elementTarget);
                continue;
            }
            if (!partElem.hasAttribute("type") || (typeRef = derivedArtifacts.lookupType(qname = this.resolveQName(partElem, targetNS, encodedQName = partElem.getAttribute("type")))) == null) continue;
            XsdTypeTarget typeTarget = new XsdTypeTarget();
            typeTarget.setValue(typeRef.getUuid());
            typeTarget.setArtifactType(XsdTypeEnum.XSD_TYPE);
            part.setType(typeTarget);
        }
        return rval;
    }

    private void processPortTypes(IndexedArtifactCollection derivedArtifacts, BaseArtifactType sourceArtifact, Element definitions, XPath xpath) throws XPathExpressionException {
        String targetNS = definitions.getAttribute("targetNamespace");
        NodeList portTypes = (NodeList)this.query(xpath, definitions, "./wsdl:portType", XPathConstants.NODESET);
        for (int idx = 0; idx < portTypes.getLength(); ++idx) {
            Element portTypeElem = (Element)portTypes.item(idx);
            if (!portTypeElem.hasAttribute("name")) continue;
            String name = portTypeElem.getAttribute("name");
            PortType portType = new PortType();
            portType.setUuid(UUID.randomUUID().toString());
            portType.setArtifactType(BaseArtifactEnum.PORT_TYPE);
            portType.setName(name);
            portType.setNamespace(targetNS);
            portType.setNCName(name);
            derivedArtifacts.add((BaseArtifactType)portType);
            Collection<Operation> operations = this.processOperations(derivedArtifacts, sourceArtifact, portTypeElem, xpath);
            for (Operation operation : operations) {
                OperationTarget target = new OperationTarget();
                target.setValue(operation.getUuid());
                target.setArtifactType(OperationEnum.OPERATION);
                portType.getOperation().add(target);
            }
        }
    }

    private Collection<Operation> processOperations(IndexedArtifactCollection derivedArtifacts, BaseArtifactType sourceArtifact, Element portTypeElem, XPath xpath) throws XPathExpressionException {
        LinkedList<Operation> rval = new LinkedList<Operation>();
        String targetNS = portTypeElem.getOwnerDocument().getDocumentElement().getAttribute("targetNamespace");
        NodeList operations = (NodeList)this.query(xpath, portTypeElem, "./wsdl:operation", XPathConstants.NODESET);
        for (int idx = 0; idx < operations.getLength(); ++idx) {
            OperationInputTarget target;
            Element operationElem = (Element)operations.item(idx);
            if (!operationElem.hasAttribute("name")) continue;
            String name = operationElem.getAttribute("name");
            Operation operation = new Operation();
            operation.setUuid(UUID.randomUUID().toString());
            operation.setArtifactType(BaseArtifactEnum.OPERATION);
            operation.setName(name);
            operation.setNamespace(targetNS);
            operation.setNCName(name);
            derivedArtifacts.add((BaseArtifactType)operation);
            rval.add(operation);
            OperationInput operationInput = this.processOperationInput(derivedArtifacts, sourceArtifact, operationElem, xpath);
            OperationOutput operationOutput = this.processOperationOutput(derivedArtifacts, sourceArtifact, operationElem, xpath);
            Collection<Fault> operationFaults = this.processOperationFaults(derivedArtifacts, sourceArtifact, operationElem, xpath);
            if (operationInput != null) {
                target = new OperationInputTarget();
                target.setValue(operationInput.getUuid());
                target.setArtifactType(OperationInputEnum.OPERATION_INPUT);
                operation.setInput(target);
            }
            if (operationOutput != null) {
                target = new OperationOutputTarget();
                target.setValue(operationOutput.getUuid());
                target.setArtifactType(OperationOutputEnum.OPERATION_OUTPUT);
                operation.setOutput((OperationOutputTarget)target);
            }
            if (operationFaults == null) continue;
            for (Fault fault : operationFaults) {
                FaultTarget target2 = new FaultTarget();
                target2.setValue(fault.getUuid());
                target2.setArtifactType(FaultEnum.FAULT);
                operation.getFault().add(target2);
            }
        }
        return rval;
    }

    private OperationInput processOperationInput(IndexedArtifactCollection derivedArtifacts, BaseArtifactType sourceArtifact, Element operationElem, XPath xpath) throws XPathExpressionException {
        OperationInput rval = null;
        String targetNS = operationElem.getOwnerDocument().getDocumentElement().getAttribute("targetNamespace");
        Element inputElem = (Element)this.query(xpath, operationElem, "./wsdl:input", XPathConstants.NODE);
        if (inputElem != null) {
            OperationInput input = new OperationInput();
            input.setUuid(UUID.randomUUID().toString());
            input.setArtifactType(BaseArtifactEnum.OPERATION_INPUT);
            String name = null;
            derivedArtifacts.add((BaseArtifactType)input);
            if (inputElem.hasAttribute("message")) {
                String encodedMsgQname = inputElem.getAttribute("message");
                QName msgQname = this.resolveQName(inputElem, targetNS, encodedMsgQname);
                name = msgQname.getLocalPart();
                Message message = derivedArtifacts.lookupMessage(msgQname);
                if (message != null) {
                    MessageTarget target = new MessageTarget();
                    target.setValue(message.getUuid());
                    target.setArtifactType(MessageEnum.MESSAGE);
                    input.setMessage(target);
                }
            }
            if (inputElem.hasAttribute("name")) {
                name = inputElem.getAttribute("name");
                input.setNCName(name);
            }
            input.setName(name);
            input.setNamespace(targetNS);
            rval = input;
        }
        return rval;
    }

    private OperationOutput processOperationOutput(IndexedArtifactCollection derivedArtifacts, BaseArtifactType sourceArtifact, Element operationElem, XPath xpath) throws XPathExpressionException {
        OperationOutput rval = null;
        String targetNS = operationElem.getOwnerDocument().getDocumentElement().getAttribute("targetNamespace");
        Element outputElem = (Element)this.query(xpath, operationElem, "./wsdl:output", XPathConstants.NODE);
        if (outputElem != null) {
            OperationOutput output = new OperationOutput();
            output.setUuid(UUID.randomUUID().toString());
            output.setArtifactType(BaseArtifactEnum.OPERATION_OUTPUT);
            String name = null;
            derivedArtifacts.add((BaseArtifactType)output);
            if (outputElem.hasAttribute("message")) {
                String encodedMsgQname = outputElem.getAttribute("message");
                QName msgQname = this.resolveQName(outputElem, targetNS, encodedMsgQname);
                name = msgQname.getLocalPart();
                Message message = derivedArtifacts.lookupMessage(msgQname);
                if (message != null) {
                    MessageTarget target = new MessageTarget();
                    target.setValue(message.getUuid());
                    target.setArtifactType(MessageEnum.MESSAGE);
                    output.setMessage(target);
                }
            }
            if (outputElem.hasAttribute("name")) {
                name = outputElem.getAttribute("name");
                output.setNCName(name);
            }
            output.setName(name);
            output.setNamespace(targetNS);
            rval = output;
        }
        return rval;
    }

    private Collection<Fault> processOperationFaults(IndexedArtifactCollection derivedArtifacts, BaseArtifactType sourceArtifact, Element operationElem, XPath xpath) throws XPathExpressionException {
        LinkedList<Fault> rval = new LinkedList<Fault>();
        String targetNS = operationElem.getOwnerDocument().getDocumentElement().getAttribute("targetNamespace");
        NodeList faults = (NodeList)this.query(xpath, operationElem, "./wsdl:fault", XPathConstants.NODESET);
        for (int idx = 0; idx < faults.getLength(); ++idx) {
            Element faultElem = (Element)faults.item(idx);
            Fault fault = new Fault();
            fault.setUuid(UUID.randomUUID().toString());
            fault.setArtifactType(BaseArtifactEnum.FAULT);
            String name = null;
            derivedArtifacts.add((BaseArtifactType)fault);
            rval.add(fault);
            if (faultElem.hasAttribute("message")) {
                String encodedMsgQname = faultElem.getAttribute("message");
                QName msgQname = this.resolveQName(faultElem, targetNS, encodedMsgQname);
                name = msgQname.getLocalPart();
                Message message = derivedArtifacts.lookupMessage(msgQname);
                if (message != null) {
                    MessageTarget target = new MessageTarget();
                    target.setValue(message.getUuid());
                    target.setArtifactType(MessageEnum.MESSAGE);
                    fault.setMessage(target);
                }
            }
            if (faultElem.hasAttribute("name")) {
                name = faultElem.getAttribute("name");
                fault.setNCName(name);
            }
            fault.setName(name);
            fault.setNamespace(targetNS);
        }
        return rval;
    }

    private void processBindings(IndexedArtifactCollection derivedArtifacts, BaseArtifactType sourceArtifact, Element definitions, XPath xpath) throws XPathExpressionException {
        String targetNS = definitions.getAttribute("targetNamespace");
        NodeList bindings = (NodeList)this.query(xpath, definitions, "./wsdl:binding", XPathConstants.NODESET);
        for (int idx = 0; idx < bindings.getLength(); ++idx) {
            String portTypeEncodedQName;
            QName portTypeQName;
            Element bindingElem = (Element)bindings.item(idx);
            if (!bindingElem.hasAttribute("name")) continue;
            String name = bindingElem.getAttribute("name");
            Binding binding = new Binding();
            binding.setUuid(UUID.randomUUID().toString());
            binding.setArtifactType(BaseArtifactEnum.BINDING);
            binding.setName(name);
            binding.setNamespace(targetNS);
            binding.setNCName(name);
            derivedArtifacts.add((BaseArtifactType)binding);
            PortType portType = null;
            if (bindingElem.hasAttribute("type") && (portType = derivedArtifacts.lookupPortType(portTypeQName = this.resolveQName(bindingElem, targetNS, portTypeEncodedQName = bindingElem.getAttribute("type")))) != null) {
                PortTypeTarget target = new PortTypeTarget();
                target.setValue(portType.getUuid());
                target.setArtifactType(PortTypeEnum.PORT_TYPE);
                binding.setPortType(target);
            }
            Collection<BindingOperation> bindingOperations = this.processBindingOperations(derivedArtifacts, sourceArtifact, bindingElem, portType, xpath);
            for (BindingOperation bindingOperation : bindingOperations) {
                BindingOperationTarget target = new BindingOperationTarget();
                target.setValue(bindingOperation.getUuid());
                target.setArtifactType(BindingOperationEnum.BINDING_OPERATION);
                binding.getBindingOperation().add(target);
            }
            NodeList soapBindings = (NodeList)this.query(xpath, bindingElem, "./soap:binding", XPathConstants.NODESET);
            for (int jdx = 0; jdx < bindings.getLength(); ++jdx) {
                Element soapBindingElem = (Element)soapBindings.item(jdx);
                if (soapBindingElem == null) continue;
                SoapBinding soapBinding = new SoapBinding();
                soapBinding.setUuid(UUID.randomUUID().toString());
                soapBinding.setArtifactType(BaseArtifactEnum.SOAP_BINDING);
                soapBinding.setName("soap:binding");
                soapBinding.setNamespace(soapBindingElem.getNamespaceURI());
                soapBinding.setNCName(soapBindingElem.getLocalName());
                soapBinding.setStyle(soapBindingElem.getAttribute("style"));
                soapBinding.setTransport(soapBindingElem.getAttribute("transport"));
                derivedArtifacts.add((BaseArtifactType)soapBinding);
                WsdlExtensionTarget target = new WsdlExtensionTarget();
                target.setArtifactType(WsdlExtensionEnum.WSDL_EXTENSION);
                target.setValue(soapBinding.getUuid());
                binding.getExtension().add(target);
            }
        }
    }

    private Collection<BindingOperation> processBindingOperations(IndexedArtifactCollection derivedArtifacts, BaseArtifactType sourceArtifact, Element bindingElem, PortType portType, XPath xpath) throws XPathExpressionException {
        LinkedList<BindingOperation> rval = new LinkedList<BindingOperation>();
        String targetNS = bindingElem.getOwnerDocument().getDocumentElement().getAttribute("targetNamespace");
        NodeList bindingOperations = (NodeList)this.query(xpath, bindingElem, "./wsdl:operation", XPathConstants.NODESET);
        for (int idx = 0; idx < bindingOperations.getLength(); ++idx) {
            BindingOperationInputTarget target;
            Element bindingOperationElem = (Element)bindingOperations.item(idx);
            if (!bindingOperationElem.hasAttribute("name")) continue;
            String name = bindingOperationElem.getAttribute("name");
            BindingOperation bindingOperation = new BindingOperation();
            bindingOperation.setUuid(UUID.randomUUID().toString());
            bindingOperation.setArtifactType(BaseArtifactEnum.BINDING_OPERATION);
            bindingOperation.setName(name);
            bindingOperation.setNamespace(targetNS);
            bindingOperation.setNCName(name);
            derivedArtifacts.add((BaseArtifactType)bindingOperation);
            rval.add(bindingOperation);
            if (portType != null) {
                QName portTypeQName = new QName(portType.getNamespace(), portType.getName());
                Operation operation = derivedArtifacts.lookupOperation(portTypeQName, name);
                OperationTarget opTarget = new OperationTarget();
                opTarget.setValue(operation.getUuid());
                opTarget.setArtifactType(OperationEnum.OPERATION);
                bindingOperation.setOperation(opTarget);
            }
            BindingOperationInput bindingOperationInput = this.processBindingOperationInput(derivedArtifacts, sourceArtifact, bindingOperationElem, xpath);
            BindingOperationOutput bindingOperationOutput = this.processBindingOperationOutput(derivedArtifacts, sourceArtifact, bindingOperationElem, xpath);
            Collection<BindingOperationFault> bindingOperationFaults = this.processBindingOperationFaults(derivedArtifacts, sourceArtifact, bindingOperationElem, xpath);
            if (bindingOperationInput != null) {
                target = new BindingOperationInputTarget();
                target.setValue(bindingOperationInput.getUuid());
                target.setArtifactType(BindingOperationInputEnum.BINDING_OPERATION_INPUT);
                bindingOperation.setInput(target);
            }
            if (bindingOperationOutput != null) {
                target = new BindingOperationOutputTarget();
                target.setValue(bindingOperationOutput.getUuid());
                target.setArtifactType(BindingOperationOutputEnum.BINDING_OPERATION_OUTPUT);
                bindingOperation.setOutput((BindingOperationOutputTarget)target);
            }
            for (BindingOperationFault fault : bindingOperationFaults) {
                BindingOperationFaultTarget target2 = new BindingOperationFaultTarget();
                target2.setValue(fault.getUuid());
                target2.setArtifactType(BindingOperationFaultEnum.BINDING_OPERATION_FAULT);
                bindingOperation.getFault().add(target2);
            }
        }
        return rval;
    }

    private BindingOperationInput processBindingOperationInput(IndexedArtifactCollection derivedArtifacts, BaseArtifactType sourceArtifact, Element operationElem, XPath xpath) throws XPathExpressionException {
        BindingOperationInput rval = null;
        String targetNS = operationElem.getOwnerDocument().getDocumentElement().getAttribute("targetNamespace");
        Element inputElem = (Element)this.query(xpath, operationElem, "./wsdl:input", XPathConstants.NODE);
        if (inputElem != null) {
            BindingOperationInput bindingOperationInput = new BindingOperationInput();
            bindingOperationInput.setUuid(UUID.randomUUID().toString());
            bindingOperationInput.setArtifactType(BaseArtifactEnum.BINDING_OPERATION_INPUT);
            String name = "wsdl:input";
            if (inputElem.hasAttribute("name")) {
                name = inputElem.getAttribute("name");
                bindingOperationInput.setNCName(name);
            }
            bindingOperationInput.setName(name);
            bindingOperationInput.setNamespace(targetNS);
            derivedArtifacts.add((BaseArtifactType)bindingOperationInput);
            rval = bindingOperationInput;
        }
        return rval;
    }

    private BindingOperationOutput processBindingOperationOutput(IndexedArtifactCollection derivedArtifacts, BaseArtifactType sourceArtifact, Element operationElem, XPath xpath) throws XPathExpressionException {
        BindingOperationOutput rval = null;
        String targetNS = operationElem.getOwnerDocument().getDocumentElement().getAttribute("targetNamespace");
        Element outputElem = (Element)this.query(xpath, operationElem, "./wsdl:output", XPathConstants.NODE);
        if (outputElem != null) {
            BindingOperationOutput bindingOperationOutput = new BindingOperationOutput();
            bindingOperationOutput.setUuid(UUID.randomUUID().toString());
            bindingOperationOutput.setArtifactType(BaseArtifactEnum.BINDING_OPERATION_OUTPUT);
            String name = "wsdl:output";
            if (outputElem.hasAttribute("name")) {
                name = outputElem.getAttribute("name");
                bindingOperationOutput.setNCName(name);
            }
            bindingOperationOutput.setName(name);
            bindingOperationOutput.setNamespace(targetNS);
            derivedArtifacts.add((BaseArtifactType)bindingOperationOutput);
            rval = bindingOperationOutput;
        }
        return rval;
    }

    private Collection<BindingOperationFault> processBindingOperationFaults(IndexedArtifactCollection derivedArtifacts, BaseArtifactType sourceArtifact, Element operationElem, XPath xpath) throws XPathExpressionException {
        LinkedList<BindingOperationFault> rval = new LinkedList<BindingOperationFault>();
        String targetNS = operationElem.getOwnerDocument().getDocumentElement().getAttribute("targetNamespace");
        NodeList faults = (NodeList)this.query(xpath, operationElem, "./wsdl:fault", XPathConstants.NODESET);
        for (int idx = 0; idx < faults.getLength(); ++idx) {
            Element faultElem = (Element)faults.item(idx);
            BindingOperationFault bindingOperationFault = new BindingOperationFault();
            bindingOperationFault.setUuid(UUID.randomUUID().toString());
            bindingOperationFault.setArtifactType(BaseArtifactEnum.BINDING_OPERATION_FAULT);
            String name = "wsdl:fault";
            if (faultElem.hasAttribute("name")) {
                name = faultElem.getAttribute("name");
                bindingOperationFault.setNCName(name);
            }
            bindingOperationFault.setName(name);
            bindingOperationFault.setNamespace(targetNS);
            derivedArtifacts.add((BaseArtifactType)bindingOperationFault);
            rval.add(bindingOperationFault);
        }
        return rval;
    }

    private void processServices(IndexedArtifactCollection derivedArtifacts, BaseArtifactType sourceArtifact, Element definitions, XPath xpath) throws XPathExpressionException {
        String targetNS = definitions.getAttribute("targetNamespace");
        NodeList services = (NodeList)this.query(xpath, definitions, "./wsdl:service", XPathConstants.NODESET);
        for (int idx = 0; idx < services.getLength(); ++idx) {
            Element serviceElem = (Element)services.item(idx);
            WsdlService service = new WsdlService();
            service.setUuid(UUID.randomUUID().toString());
            service.setArtifactType(BaseArtifactEnum.WSDL_SERVICE);
            service.setNamespace(targetNS);
            if (serviceElem.hasAttribute("name")) {
                String name = serviceElem.getAttribute("name");
                service.setName(name);
                service.setNCName(name);
            } else {
                service.setName("wsdl:service");
            }
            derivedArtifacts.add((BaseArtifactType)service);
            Collection<Port> ports = this.processPorts(derivedArtifacts, sourceArtifact, serviceElem, xpath);
            for (Port port : ports) {
                PortTarget target = new PortTarget();
                target.setValue(port.getUuid());
                target.setArtifactType(PortEnum.PORT);
                service.getPort().add(target);
            }
        }
    }

    private Collection<Port> processPorts(IndexedArtifactCollection derivedArtifacts, BaseArtifactType sourceArtifact, Element serviceElem, XPath xpath) throws XPathExpressionException {
        LinkedList<Port> rval = new LinkedList<Port>();
        String targetNS = serviceElem.getOwnerDocument().getDocumentElement().getAttribute("targetNamespace");
        NodeList ports = (NodeList)this.query(xpath, serviceElem, "./wsdl:port", XPathConstants.NODESET);
        for (int idx = 0; idx < ports.getLength(); ++idx) {
            String bindingEncodedQName;
            QName bindingQName;
            Binding binding;
            Element portElem = (Element)ports.item(idx);
            Port port = new Port();
            port.setUuid(UUID.randomUUID().toString());
            port.setArtifactType(BaseArtifactEnum.PORT);
            port.setNamespace(targetNS);
            if (portElem.hasAttribute("name")) {
                String name = portElem.getAttribute("name");
                port.setNCName(name);
                port.setName(name);
            } else {
                port.setName("wsdl:port");
            }
            if (portElem.hasAttribute("binding") && (binding = derivedArtifacts.lookupBinding(bindingQName = this.resolveQName(portElem, targetNS, bindingEncodedQName = portElem.getAttribute("binding")))) != null) {
                BindingTarget target = new BindingTarget();
                target.setValue(binding.getUuid());
                target.setArtifactType(BindingEnum.BINDING);
                port.setBinding(target);
            }
            derivedArtifacts.add((BaseArtifactType)port);
            rval.add(port);
            NodeList soapAddresses = (NodeList)this.query(xpath, portElem, "./soap:address", XPathConstants.NODESET);
            for (int jdx = 0; jdx < soapAddresses.getLength(); ++jdx) {
                Element soapAddressElem = (Element)soapAddresses.item(jdx);
                SoapAddress soapAddress = new SoapAddress();
                soapAddress.setUuid(UUID.randomUUID().toString());
                soapAddress.setArtifactType(BaseArtifactEnum.SOAP_ADDRESS);
                soapAddress.setName("soap:address");
                soapAddress.setNCName(soapAddressElem.getLocalName());
                soapAddress.setNamespace(soapAddressElem.getNamespaceURI());
                soapAddress.setSoapLocation(soapAddressElem.getAttribute("location"));
                derivedArtifacts.add((BaseArtifactType)soapAddress);
                WsdlExtensionTarget target = new WsdlExtensionTarget();
                target.setArtifactType(WsdlExtensionEnum.WSDL_EXTENSION);
                target.setValue(soapAddress.getUuid());
                port.getExtension().add(target);
            }
        }
        return rval;
    }

    private QName resolveQName(Element context, String defaultNamespace, String encodedQName) {
        int idx = encodedQName.indexOf(":");
        if (idx == -1) {
            return new QName(defaultNamespace, encodedQName);
        }
        String prefix = encodedQName.substring(0, idx);
        String localPart = encodedQName.substring(idx + 1);
        String namespace = this.resolveNamespaceByPrefix(context, prefix);
        if (namespace == null) {
            return new QName(null, encodedQName);
        }
        return new QName(namespace, localPart, prefix);
    }

    private String resolveNamespaceByPrefix(Element context, String prefix) {
        String nsDecl = "xmlns:" + prefix;
        Element elem = context;
        String ns = null;
        while (elem != null) {
            if (elem.hasAttribute(nsDecl)) {
                ns = elem.getAttribute(nsDecl);
                break;
            }
            if (elem.getParentNode().getNodeType() == 1) {
                elem = (Element)elem.getParentNode();
                continue;
            }
            elem = null;
        }
        return ns;
    }
}

