/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common.visitors;

import java.util.List;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Actor;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Binding;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DerivedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Element;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Fault;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Message;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Operation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationInput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationOutput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Organization;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Part;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Policy;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PolicyAttachment;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Port;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PortType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Relationship;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Service;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceContract;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceEndpoint;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceImplementationModelType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceInstance;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceInterface;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceOperation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SoaModelType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Target;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDerivedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlService;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocument;
import org.overlord.sramp.common.visitors.HierarchicalArtifactVisitorAdapter;

public abstract class RelationshipArtifactVisitor
extends HierarchicalArtifactVisitorAdapter {
    @Override
    protected void visitBase(BaseArtifactType artifact) {
        List relationships = artifact.getRelationship();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                String type = relationship.getRelationshipType();
                List targets = relationship.getRelationshipTarget();
                this.visitRelationships(type, targets);
            }
        }
        super.visitBase(artifact);
    }

    @Override
    protected void visitDerived(DerivedArtifactType artifact) {
        DocumentArtifactTarget relatedDocument = artifact.getRelatedDocument();
        this.visitRelationship("relatedDocument", (Target)relatedDocument);
        super.visitDerived(artifact);
    }

    @Override
    protected void visitWsdlDerived(WsdlDerivedArtifactType artifact) {
        this.visitRelationships("extension", artifact.getExtension());
        super.visitWsdlDerived(artifact);
    }

    @Override
    protected void visitSoa(SoaModelType artifact) {
        this.visitRelationships("documentation", artifact.getDocumentation());
        super.visitSoa(artifact);
    }

    @Override
    protected void visitServiceImplementation(ServiceImplementationModelType artifact) {
        this.visitRelationships("documentation", artifact.getDocumentation());
        super.visitServiceImplementation(artifact);
    }

    @Override
    public void visit(ServiceContract artifact) {
        this.visitRelationships("involvesParty", artifact.getInvolvesParty());
        this.visitRelationships("specifies", artifact.getSpecifies());
        super.visit(artifact);
    }

    @Override
    public void visit(BindingOperation artifact) {
        this.visitRelationships("fault", artifact.getFault());
        this.visitRelationship("input", (Target)artifact.getInput());
        this.visitRelationship("output", (Target)artifact.getOutput());
        this.visitRelationship("operation", (Target)artifact.getOperation());
        super.visit(artifact);
    }

    @Override
    public void visit(Actor artifact) {
        this.visitRelationships("does", artifact.getDoes());
        this.visitRelationships("setsPolicy", artifact.getSetsPolicy());
        super.visit(artifact);
    }

    @Override
    public void visit(Binding artifact) {
        this.visitRelationships("bindingOperation", artifact.getBindingOperation());
        this.visitRelationship("portType", (Target)artifact.getPortType());
        super.visit(artifact);
    }

    @Override
    public void visit(Element artifact) {
        this.visitRelationships("represents", artifact.getRepresents());
        this.visitRelationships("uses", artifact.getUses());
        this.visitRelationships("performs", artifact.getPerforms());
        this.visitRelationship("directsOrchestration", (Target)artifact.getDirectsOrchestration());
        this.visitRelationship("directsOrchestrationProcess", (Target)artifact.getDirectsOrchestrationProcess());
        this.visitRelationships("generates", artifact.getGenerates());
        this.visitRelationships("respondsTo", artifact.getRespondsTo());
        super.visit(artifact);
    }

    @Override
    public void visit(Fault artifact) {
        this.visitRelationship("message", (Target)artifact.getMessage());
        super.visit(artifact);
    }

    @Override
    public void visit(Message artifact) {
        this.visitRelationships("part", artifact.getPart());
        super.visit(artifact);
    }

    @Override
    public void visit(Operation artifact) {
        this.visitRelationship("input", (Target)artifact.getInput());
        this.visitRelationship("output", (Target)artifact.getOutput());
        this.visitRelationships("fault", artifact.getFault());
        super.visit(artifact);
    }

    @Override
    public void visit(OperationInput artifact) {
        this.visitRelationship("message", (Target)artifact.getMessage());
        super.visit(artifact);
    }

    @Override
    public void visit(OperationOutput artifact) {
        this.visitRelationship("message", (Target)artifact.getMessage());
        super.visit(artifact);
    }

    @Override
    public void visit(Organization artifact) {
        this.visitRelationships("provides", artifact.getProvides());
        super.visit(artifact);
    }

    @Override
    public void visit(Part artifact) {
        this.visitRelationship("type", (Target)artifact.getType());
        this.visitRelationship("element", (Target)artifact.getElement());
        super.visit(artifact);
    }

    @Override
    public void visit(Policy artifact) {
        this.visitRelationships("appliesTo", artifact.getAppliesTo());
        super.visit(artifact);
    }

    @Override
    public void visit(PolicyAttachment artifact) {
        this.visitRelationships("appliesTo", artifact.getAppliesTo());
        this.visitRelationships("policies", artifact.getPolicies());
        super.visit(artifact);
    }

    @Override
    public void visit(Port artifact) {
        this.visitRelationship("binding", (Target)artifact.getBinding());
        super.visit(artifact);
    }

    @Override
    public void visit(PortType artifact) {
        this.visitRelationships("operation", artifact.getOperation());
        super.visit(artifact);
    }

    @Override
    public void visit(Service artifact) {
        this.visitRelationships("hasContract", artifact.getHasContract());
        this.visitRelationships("hasInterface", artifact.getHasInterface());
        this.visitRelationship("hasInstance", (Target)artifact.getHasInstance());
        super.visit(artifact);
    }

    @Override
    public void visit(ServiceEndpoint artifact) {
        this.visitRelationship("endpointDefinedBy", (Target)artifact.getEndpointDefinedBy());
        super.visit(artifact);
    }

    @Override
    public void visit(ServiceInstance artifact) {
        this.visitRelationships("uses", artifact.getUses());
        this.visitRelationships("describedBy", artifact.getDescribedBy());
        super.visit(artifact);
    }

    @Override
    public void visit(ServiceInterface artifact) {
        this.visitRelationship("hasOperation", (Target)artifact.getHasOperation());
        this.visitRelationships("hasOutput", artifact.getHasOutput());
        this.visitRelationships("hasInput", artifact.getHasInput());
        this.visitRelationships("isInterfaceOf", artifact.getIsInterfaceOf());
        super.visit(artifact);
    }

    @Override
    public void visit(ServiceOperation artifact) {
        this.visitRelationship("operationDefinedBy", (Target)artifact.getOperationDefinedBy());
        super.visit(artifact);
    }

    @Override
    public void visit(WsdlDocument artifact) {
        this.visitRelationships("importedXsds", artifact.getImportedXsds());
        this.visitRelationships("includedXsds", artifact.getIncludedXsds());
        this.visitRelationships("redefinedXsds", artifact.getRedefinedXsds());
        this.visitRelationships("importedWsdls", artifact.getImportedWsdls());
        super.visit(artifact);
    }

    @Override
    public void visit(WsdlService artifact) {
        this.visitRelationships("port", artifact.getPort());
        super.visit(artifact);
    }

    @Override
    public void visit(XsdDocument artifact) {
        this.visitRelationships("importedXsds", artifact.getImportedXsds());
        this.visitRelationships("includedXsds", artifact.getIncludedXsds());
        this.visitRelationships("redefinedXsds", artifact.getRedefinedXsds());
        super.visit(artifact);
    }

    protected void visitRelationships(String type, List<? extends Target> targets) {
        for (Target target : targets) {
            this.visitRelationship(type, target);
        }
    }

    protected abstract void visitRelationship(String var1, Target var2);
}

