/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.overlord.commons.config.ConfigurationFactory;
import org.overlord.commons.config.JBossServer;
import org.overlord.sramp.common.Version;

public class SrampConfig {
    private static Configuration configuration = null;

    public static String getBaseUrl(String requestUrl) {
        String baseUrl = null;
        if (requestUrl != null) {
            int index = requestUrl.lastIndexOf("/s-ramp/");
            if (index < 0) {
                index = requestUrl.lastIndexOf("/s-ramp");
            }
            if (index > 0) {
                baseUrl = requestUrl.substring(0, index);
            }
        }
        if (baseUrl == null) {
            baseUrl = JBossServer.getBaseUrl() + "/s-ramp-server";
        }
        return configuration.getString("sramp.config.baseurl", baseUrl);
    }

    public static boolean isAuditingEnabled() {
        return configuration.getBoolean("sramp.config.auditing.enabled", true);
    }

    public static boolean isDerivedArtifactAuditingEnabled() {
        return configuration.getBoolean("sramp.config.auditing.enabled-derived", true);
    }

    public static String getConfigProperty(String propertyName, String propertyDefault) {
        return configuration.getString(propertyName, propertyDefault);
    }

    public static String getJCRRepositoryName() {
        return SrampConfig.getConfigProperty("sramp.config.jcr.repository.name", "sramp");
    }

    public static String getMavenReadOnlyUsername() {
        return SrampConfig.getConfigProperty("sramp.config.maven.readonly-username", "mavenuser");
    }

    private static String getVersion() {
        return Version.get().getVersionString();
    }

    public static boolean containsKey(String key) {
        return configuration.containsKey(key);
    }

    public static boolean isSnapshotAllowed() {
        if ("true".equalsIgnoreCase(System.getProperty("sramp.config.maven.allow-snapshots"))) {
            return true;
        }
        if (SrampConfig.containsKey("sramp.config.maven.allow-snapshots")) {
            String value = SrampConfig.getConfigProperty("sramp.config.maven.allow-snapshots", "false");
            return StringUtils.isNotBlank((String)value) && value.equals("true");
        }
        return SrampConfig.isSnapshot();
    }

    private static boolean isSnapshot() {
        String version = SrampConfig.getVersion();
        return StringUtils.isNotBlank((String)version) && version.contains("SNAPSHOT");
    }

    static {
        String configFile = System.getProperty("sramp.config.file.name");
        String refreshDelayStr = System.getProperty("sramp.config.file.refresh");
        Long refreshDelay = 5000L;
        if (refreshDelayStr != null) {
            refreshDelay = new Long(refreshDelayStr);
        }
        configuration = ConfigurationFactory.createConfig((String)configFile, (String)"sramp.properties", (Long)refreshDelay, null, null);
    }
}

