/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Property;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Relationship;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Target;
import org.overlord.commons.codec.AesEncrypter;

public class SrampModelUtils {
    public static final String ENCRYPT_PREFIX = "${crypt:";
    public static final String ENCRYPT_SUFIX = "}";

    public static void setCustomProperty(BaseArtifactType artifact, String propName, String propValue) {
        Property prop = null;
        List properties = artifact.getProperty();
        for (Property property : properties) {
            if (!property.getPropertyName().equals(propName)) continue;
            prop = property;
            break;
        }
        if (prop == null) {
            prop = new Property();
            prop.setPropertyName(propName);
            properties.add(prop);
        }
        if (propValue == null) {
            properties.remove(prop);
        } else {
            prop.setPropertyValue(propValue);
        }
    }

    public static void setCustomEncryptedProperty(BaseArtifactType artifact, String propName, String propValue) {
        StringBuilder builder = new StringBuilder();
        builder.append(ENCRYPT_PREFIX).append(AesEncrypter.encrypt((String)propValue)).append(ENCRYPT_SUFIX);
        SrampModelUtils.setCustomProperty(artifact, propName, builder.toString());
    }

    public static String getCustomProperty(BaseArtifactType artifact, String propName) {
        String rval = null;
        List properties = artifact.getProperty();
        for (Property prop : properties) {
            if (!propName.equals(prop.getPropertyName())) continue;
            rval = prop.getPropertyValue();
            break;
        }
        if (StringUtils.isNotBlank(rval) && rval.startsWith(ENCRYPT_PREFIX) && rval.endsWith(ENCRYPT_SUFIX)) {
            String encrypted_value = rval.substring(ENCRYPT_PREFIX.length(), rval.length() - ENCRYPT_SUFIX.length());
            return AesEncrypter.decrypt((String)encrypted_value);
        }
        return rval;
    }

    public static Relationship addGenericRelationship(BaseArtifactType artifact, String relationshipType, String targetUUID) {
        Relationship relationship = null;
        for (Relationship r : artifact.getRelationship()) {
            if (!r.getRelationshipType().equals(relationshipType)) continue;
            relationship = r;
            break;
        }
        if (relationship == null) {
            relationship = new Relationship();
            relationship.setRelationshipType(relationshipType);
            artifact.getRelationship().add(relationship);
        }
        if (targetUUID != null) {
            Target target = new Target();
            target.setValue(targetUUID);
            relationship.getRelationshipTarget().add(target);
        }
        return relationship;
    }

    public static Relationship getGenericRelationship(BaseArtifactType artifact, String relationshipType) {
        for (Relationship relationship : artifact.getRelationship()) {
            if (!relationship.getRelationshipType().equals(relationshipType)) continue;
            return relationship;
        }
        return null;
    }

    public static boolean isDocumentArtifact(BaseArtifactType artifact) {
        return artifact instanceof DocumentArtifactType;
    }

    public static boolean isTextDocumentArtifact(DocumentArtifactType artifact) {
        String ct = artifact.getContentType();
        if (ct == null) {
            return false;
        }
        return (ct = ct.toLowerCase()).contains("text/") || ct.contains("application/xml");
    }

    public static Map<String, String> getCustomPropertiesByPrefix(BaseArtifactType artifact, String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        List properties = artifact.getProperty();
        for (Property prop : properties) {
            if (!prop.getPropertyName().startsWith(prefix)) continue;
            result.put(prop.getPropertyName(), prop.getPropertyValue());
        }
        return result;
    }
}

