/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common.derived;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Binding;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ComplexTypeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ElementDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Message;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Operation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PortType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SimpleTypeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdType;

public class IndexedArtifactCollection
extends LinkedList<BaseArtifactType> {
    private static final long serialVersionUID = 3333444885794949531L;
    private Map<QName, ElementDeclaration> elementIndex = new HashMap<QName, ElementDeclaration>();
    private Map<QName, XsdType> schemaTypeIndex = new HashMap<QName, XsdType>();
    private Map<QName, Message> messageIndex = new HashMap<QName, Message>();
    private Map<QName, PortType> portTypeIndex = new HashMap<QName, PortType>();
    private Map<String, Operation> operationIndex = new HashMap<String, Operation>();
    private Map<QName, Binding> bindingIndex = new HashMap<QName, Binding>();
    private QName mostRecentPortType;

    @Override
    public boolean add(BaseArtifactType artifact) {
        this.indexArtifact(artifact);
        return super.add(artifact);
    }

    private void indexArtifact(BaseArtifactType artifact) {
        if (artifact instanceof ElementDeclaration) {
            ElementDeclaration element = (ElementDeclaration)artifact;
            QName key = new QName(element.getNamespace(), element.getNCName());
            this.elementIndex.put(key, element);
        } else if (artifact instanceof SimpleTypeDeclaration) {
            SimpleTypeDeclaration simpleType = (SimpleTypeDeclaration)artifact;
            QName key = new QName(simpleType.getNamespace(), simpleType.getNCName());
            this.schemaTypeIndex.put(key, (XsdType)simpleType);
        } else if (artifact instanceof ComplexTypeDeclaration) {
            ComplexTypeDeclaration complexType = (ComplexTypeDeclaration)artifact;
            QName key = new QName(complexType.getNamespace(), complexType.getNCName());
            this.schemaTypeIndex.put(key, (XsdType)complexType);
        } else if (artifact instanceof Message) {
            Message message = (Message)artifact;
            QName key = new QName(message.getNamespace(), message.getNCName());
            this.messageIndex.put(key, message);
        } else if (artifact instanceof PortType) {
            PortType portType = (PortType)artifact;
            QName key = new QName(portType.getNamespace(), portType.getNCName());
            this.portTypeIndex.put(key, portType);
            this.mostRecentPortType = key;
        } else if (artifact instanceof Operation) {
            Operation operation = (Operation)artifact;
            if (this.mostRecentPortType != null) {
                String key = this.mostRecentPortType.toString() + ":" + operation.getNCName();
                this.operationIndex.put(key, operation);
            }
        } else if (artifact instanceof Binding) {
            Binding binding = (Binding)artifact;
            QName key = new QName(binding.getNamespace(), binding.getNCName());
            this.bindingIndex.put(key, binding);
        }
    }

    public ElementDeclaration lookupElement(QName name) {
        return this.elementIndex.get(name);
    }

    public XsdType lookupType(QName name) {
        return this.schemaTypeIndex.get(name);
    }

    public Message lookupMessage(QName name) {
        return this.messageIndex.get(name);
    }

    public PortType lookupPortType(QName name) {
        return this.portTypeIndex.get(name);
    }

    public Operation lookupOperation(QName portTypeName, String operationName) {
        String key = this.mostRecentPortType.toString() + ":" + operationName;
        return this.operationIndex.get(key);
    }

    public Binding lookupBinding(QName name) {
        return this.bindingIndex.get(name);
    }
}

