/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common.derived;

import java.io.IOException;
import java.util.Collection;
import java.util.UUID;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.AttributeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ComplexTypeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ElementDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SimpleTypeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocument;
import org.overlord.sramp.common.derived.AbstractXmlDeriver;
import org.overlord.sramp.common.derived.LinkerContext;
import org.overlord.sramp.common.query.xpath.StaticNamespaceContext;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XsdDeriver
extends AbstractXmlDeriver {
    @Override
    protected void configureNamespaceMappings(StaticNamespaceContext namespaceContext) {
        super.configureNamespaceMappings(namespaceContext);
        namespaceContext.addMapping("xs", "http://www.w3.org/2001/XMLSchema");
        namespaceContext.addMapping("xsd", "http://www.w3.org/2001/XMLSchema");
    }

    @Override
    protected void derive(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType artifact, AbstractXmlDeriver.XmlDeriverContext xmlDeriverContext) throws IOException {
        try {
            this.processSchema(derivedArtifacts, artifact, xmlDeriverContext.getRootElement(), xmlDeriverContext.getXpath());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void processSchema(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType artifact, Element schema, XPath xpath) throws XPathExpressionException {
        String targetNS = schema.getAttribute("targetNamespace");
        if (artifact instanceof XsdDocument) {
            ((XsdDocument)artifact).setTargetNamespace(targetNS);
        }
        this.processElementDeclarations(derivedArtifacts, artifact, schema, xpath);
        this.processAttributeDeclarations(derivedArtifacts, artifact, schema, xpath);
        this.processSimpleTypeDeclarations(derivedArtifacts, artifact, schema, xpath);
        this.processComplexTypeDeclarations(derivedArtifacts, artifact, schema, xpath);
        for (BaseArtifactType derivedArtifact : derivedArtifacts) {
            derivedArtifact.setUuid(UUID.randomUUID().toString());
        }
    }

    private void processElementDeclarations(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType sourceArtifact, Element schema, XPath xpath) throws XPathExpressionException {
        String targetNS = schema.getAttribute("targetNamespace");
        NodeList nodes = (NodeList)this.query(xpath, schema, "./xsd:element", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element node = (Element)nodes.item(idx);
            if (!node.hasAttribute("name")) continue;
            String nsName = node.getAttribute("name");
            ElementDeclaration elementDecl = new ElementDeclaration();
            elementDecl.setArtifactType(BaseArtifactEnum.ELEMENT_DECLARATION);
            elementDecl.setName(nsName);
            elementDecl.setNamespace(targetNS);
            elementDecl.setNCName(nsName);
            derivedArtifacts.add((BaseArtifactType)elementDecl);
        }
    }

    private void processAttributeDeclarations(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType sourceArtifact, Element schema, XPath xpath) throws XPathExpressionException {
        String targetNS = schema.getAttribute("targetNamespace");
        NodeList nodes = (NodeList)this.query(xpath, schema, "./xsd:attribute", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element node = (Element)nodes.item(idx);
            if (!node.hasAttribute("name")) continue;
            String nsName = node.getAttribute("name");
            AttributeDeclaration attributeDecl = new AttributeDeclaration();
            attributeDecl.setArtifactType(BaseArtifactEnum.ATTRIBUTE_DECLARATION);
            attributeDecl.setName(nsName);
            attributeDecl.setNamespace(targetNS);
            attributeDecl.setNCName(nsName);
            derivedArtifacts.add((BaseArtifactType)attributeDecl);
        }
    }

    private void processSimpleTypeDeclarations(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType sourceArtifact, Element schema, XPath xpath) throws XPathExpressionException {
        String targetNS = schema.getAttribute("targetNamespace");
        NodeList nodes = (NodeList)this.query(xpath, schema, "./xsd:simpleType", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element node = (Element)nodes.item(idx);
            if (!node.hasAttribute("name")) continue;
            String nsName = node.getAttribute("name");
            SimpleTypeDeclaration simpleTypeDecl = new SimpleTypeDeclaration();
            simpleTypeDecl.setArtifactType(BaseArtifactEnum.SIMPLE_TYPE_DECLARATION);
            simpleTypeDecl.setName(nsName);
            simpleTypeDecl.setNamespace(targetNS);
            simpleTypeDecl.setNCName(nsName);
            derivedArtifacts.add((BaseArtifactType)simpleTypeDecl);
        }
    }

    private void processComplexTypeDeclarations(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType sourceArtifact, Element schema, XPath xpath) throws XPathExpressionException {
        String targetNS = schema.getAttribute("targetNamespace");
        NodeList nodes = (NodeList)this.query(xpath, schema, "./xsd:complexType", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element node = (Element)nodes.item(idx);
            if (!node.hasAttribute("name")) continue;
            String nsName = node.getAttribute("name");
            ComplexTypeDeclaration complexTypeDecl = new ComplexTypeDeclaration();
            complexTypeDecl.setArtifactType(BaseArtifactEnum.COMPLEX_TYPE_DECLARATION);
            complexTypeDecl.setName(nsName);
            complexTypeDecl.setNamespace(targetNS);
            complexTypeDecl.setNCName(nsName);
            derivedArtifacts.add((BaseArtifactType)complexTypeDecl);
        }
    }

    @Override
    public void link(LinkerContext context, BaseArtifactType sourceArtifact, Collection<BaseArtifactType> derivedArtifacts) {
    }
}

