/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.events.jms;

import java.util.ArrayList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.codehaus.jackson.map.ObjectMapper;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.common.SrampConfig;
import org.overlord.sramp.events.ArtifactUpdateEvent;
import org.overlord.sramp.events.EventProducer;
import org.overlord.sramp.events.OntologyUpdateEvent;
import org.overlord.sramp.events.jms.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3._1999._02._22_rdf_syntax_ns_.RDF;

@Component(name="JMS Event Producer", immediate=true)
@Service(value={EventProducer.class})
public class JMSEventProducer
implements EventProducer {
    public static final String JMS_TYPE_ARTIFACT_CREATED = "sramp:artifactCreated";
    public static final String JMS_TYPE_ARTIFACT_UPDATED = "sramp:artifactUpdated";
    public static final String JMS_TYPE_ARTIFACT_DELETED = "sramp:artifactDeleted";
    public static final String JMS_TYPE_ONTOLOGY_CREATED = "sramp:ontologyCreated";
    public static final String JMS_TYPE_ONTOLOGY_UPDATED = "sramp:ontologyUpdated";
    public static final String JMS_TYPE_ONTOLOGY_DELETED = "sramp:ontologyDeleted";
    private static Logger LOG = LoggerFactory.getLogger(JMSEventProducer.class);
    private Connection connection = null;
    private Session session = null;
    private final List<Destination> destinations = new ArrayList<Destination>();

    public void startup() {
        try {
            String connectionFactoryName = SrampConfig.getConfigProperty((String)"sramp.config.events.jms.connectionfactory", (String)"ConnectionFactory");
            String topicNamesProp = SrampConfig.getConfigProperty((String)"sramp.config.events.jms.topics", (String)"");
            String[] topicNames = new String[]{};
            if (StringUtils.isNotEmpty((String)topicNamesProp)) {
                topicNames = topicNamesProp.split(",");
            }
            String queueNamesProp = SrampConfig.getConfigProperty((String)"sramp.config.events.jms.queues", (String)"");
            String[] queueNames = new String[]{};
            if (StringUtils.isNotEmpty((String)queueNamesProp)) {
                queueNames = queueNamesProp.split(",");
            }
            try {
                ConnectionFactory connectionFactory = (ConnectionFactory)this.jndiLookup(connectionFactoryName);
                this.connection = connectionFactory.createConnection();
                this.session = this.connection.createSession(false, 1);
                for (String topicName : topicNames) {
                    Topic topic = (Topic)this.jndiLookup(topicName);
                    this.destinations.add((Destination)topic);
                }
                for (String queueName : queueNames) {
                    Queue queue = (Queue)this.jndiLookup(queueName);
                    this.destinations.add((Destination)queue);
                }
            }
            catch (NamingException e) {
                String bindAddress = "tcp://localhost:" + SrampConfig.getConfigProperty((String)"sramp.config.events.jms.embedded-activemq-port", (String)"61616");
                LOG.warn(Messages.i18n.format("org.overlord.sramp.events.jms.embedded_broker", new Object[]{bindAddress}));
                this.session = null;
                this.destinations.clear();
                BrokerService broker = new BrokerService();
                broker.addConnector(bindAddress);
                broker.start();
                ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://localhost");
                this.initActiveMQ((ConnectionFactory)connectionFactory, topicNames, queueNames);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void initActiveMQ(ConnectionFactory connectionFactory, String[] topicNames, String[] queueNames) throws Exception {
        this.connection = connectionFactory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        for (String topicName : topicNames) {
            this.destinations.add((Destination)this.session.createTopic(topicName));
        }
        for (String queueName : queueNames) {
            this.destinations.add((Destination)this.session.createQueue(queueName));
        }
    }

    public void artifactCreated(BaseArtifactType artifact) {
        this.publishEvent(artifact, JMS_TYPE_ARTIFACT_CREATED);
    }

    public void artifactUpdated(BaseArtifactType updatedArtifact, BaseArtifactType oldArtifact) {
        ArtifactUpdateEvent event = new ArtifactUpdateEvent(updatedArtifact, oldArtifact);
        this.publishEvent(event, JMS_TYPE_ARTIFACT_UPDATED);
    }

    public void artifactDeleted(BaseArtifactType artifact) {
        this.publishEvent(artifact, JMS_TYPE_ARTIFACT_DELETED);
    }

    public void ontologyCreated(RDF ontology) {
        this.publishEvent(ontology, JMS_TYPE_ONTOLOGY_CREATED);
    }

    public void ontologyUpdated(RDF updatedOntology, RDF oldOntology) {
        OntologyUpdateEvent event = new OntologyUpdateEvent(updatedOntology, oldOntology);
        this.publishEvent(event, JMS_TYPE_ONTOLOGY_UPDATED);
    }

    public void ontologyDeleted(RDF ontology) {
        this.publishEvent(ontology, JMS_TYPE_ONTOLOGY_DELETED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishEvent(Object payload, String type) {
        for (Destination destination : this.destinations) {
            MessageProducer producer = null;
            try {
                producer = this.session.createProducer(destination);
                TextMessage textMessage = this.session.createTextMessage();
                textMessage.setJMSType(type);
                ObjectMapper mapper = new ObjectMapper();
                String text = mapper.writeValueAsString(payload);
                textMessage.setText(text);
                producer.send((Message)textMessage);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (producer == null) continue;
                try {
                    producer.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private Object jndiLookup(String name) throws NamingException {
        InitialContext initContext = new InitialContext();
        try {
            Context jndiContext = (Context)initContext.lookup("java:comp/env");
            return jndiContext.lookup(name);
        }
        catch (NamingException e) {
            Context jndiContext = (Context)initContext.lookup("java:");
            return jndiContext.lookup(name);
        }
    }

    public void shutdown() {
        try {
            this.session.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

