/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.governance.ConfigException;
import org.overlord.sramp.governance.Governance;
import org.overlord.sramp.governance.Query;
import org.overlord.sramp.governance.workflow.BpmManager;
import org.overlord.sramp.governance.workflow.WorkflowFactory;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutor {
    private static String WORKFLOW_PROCESS_ID = "workflowProcessId=";
    private static String WORKFLOW_PARAMETERS = "workflowParameters=";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Governance governance = new Governance();
    private BpmManager bpmManager = WorkflowFactory.newInstance();

    public synchronized void execute() throws SrampClientException, MalformedURLException, ConfigException {
        SrampAtomApiClient client = new SrampAtomApiClient(this.governance.getSrampUrl().toExternalForm());
        for (Query query : this.governance.getQueries()) {
            try {
                String srampQuery = query.getSrampQuery();
                QueryResultSet queryResultSet = client.query(srampQuery);
                if (queryResultSet.size() <= 0L) continue;
                for (ArtifactSummary artifactSummary : queryResultSet) {
                    Property property2;
                    BaseArtifactType artifact = client.getArtifactMetaData(artifactSummary.getType(), artifactSummary.getUuid());
                    List properties = artifact.getProperty();
                    String name = WORKFLOW_PROCESS_ID + query.getWorkflowId();
                    String value = WORKFLOW_PARAMETERS + query.getParameters();
                    String propertyName = null;
                    boolean hasPropertyName = false;
                    HashMap<String, String> propertyMap = new HashMap<String, String>();
                    for (Property property2 : properties) {
                        propertyMap.put(property2.getPropertyName(), property2.getPropertyValue());
                        if (!property2.getPropertyName().startsWith(name) || !property2.getPropertyValue().equals(value)) continue;
                        hasPropertyName = true;
                    }
                    if (hasPropertyName) {
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug("Artifact " + artifact.getUuid() + " has existing workflow: " + query.getWorkflowId() + " with parameters: " + query.getParameters());
                        continue;
                    }
                    propertyName = WORKFLOW_PROCESS_ID + query.getWorkflowId() + "_";
                    int i = 0;
                    while (propertyMap.keySet().contains(propertyName + i)) {
                        ++i;
                    }
                    property2 = new Property();
                    property2.setPropertyName(propertyName + i);
                    property2.setPropertyValue(WORKFLOW_PARAMETERS + query.getParameters());
                    artifact.getProperty().add(property2);
                    client.updateArtifactMetaData(artifact);
                    this.logger.info("Starting workflow " + query.getWorkflowId() + " for artifact " + artifact.getUuid());
                    Map parameters = query.getParsedParameters();
                    parameters.put("ArtifactUuid", artifact.getUuid());
                    this.bpmManager.newProcessInstance(query.getWorkflowId(), parameters);
                }
            }
            catch (Exception e) {
                this.logger.error("Exception for " + query.getSrampQuery() + ". " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

