/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.java.deriver;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.common.derived.ArtifactDeriver;
import org.overlord.sramp.common.derived.LinkerContext;

public class MavenPomDeriver
implements ArtifactDeriver {
    public Collection<BaseArtifactType> derive(BaseArtifactType artifact, InputStream contentStream) throws IOException {
        ArrayList<BaseArtifactType> derivedArtifacts = new ArrayList<BaseArtifactType>();
        try {
            Model model = new MavenXpp3Reader().read(contentStream);
            MavenProject project = new MavenProject(model);
            ((ExtendedDocument)artifact).setExtendedType("MavenPom");
            for (String key : project.getProperties().stringPropertyNames()) {
                String value = project.getProperties().getProperty(key);
                SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)("maven.property." + key), (String)value);
            }
            if (artifact.getDescription() == null) {
                artifact.setDescription(project.getDescription());
            }
            if (artifact.getName() == null) {
                artifact.setName(project.getName());
            }
            if (artifact.getVersion() == null) {
                artifact.setVersion(project.getVersion());
            }
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.artifactId", (String)model.getArtifactId());
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.groupId", (String)model.getGroupId());
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.version", (String)model.getVersion());
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.packaging", (String)model.getPackaging());
            if (model.getParent() != null) {
                SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.parent.artifactId", (String)model.getParent().getArtifactId());
                SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.parent.groupId", (String)model.getParent().getGroupId());
                SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.parent.version", (String)model.getParent().getVersion());
            }
        }
        catch (XmlPullParserException e) {
            throw new IOException(e.getMessage(), e);
        }
        return derivedArtifacts;
    }

    public void link(LinkerContext context, BaseArtifactType sourceArtifact, Collection<BaseArtifactType> derivedArtifacts) {
    }
}

