/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.kie.expand;

import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.overlord.sramp.atom.archive.expand.ZipToSrampArchive;
import org.overlord.sramp.atom.archive.expand.ZipToSrampArchiveException;
import org.overlord.sramp.atom.archive.expand.registry.ZipToSrampArchiveProvider;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.integration.kie.expand.KieJarToSrampArchive;

public class KieJarToSrampArchiveProvider
implements ZipToSrampArchiveProvider {
    private static final Set<String> acceptedTypes = new HashSet<String>();

    public boolean accept(ArtifactType artifactType) {
        if (artifactType.isExtendedType()) {
            String extendedType = artifactType.getExtendedType();
            return acceptedTypes.contains(extendedType);
        }
        return false;
    }

    public ZipToSrampArchive createExtractor(ArtifactType artifactType, File zipFile) throws ZipToSrampArchiveException {
        return new KieJarToSrampArchive(zipFile);
    }

    public ZipToSrampArchive createExtractor(ArtifactType artifactType, InputStream zipStream) throws ZipToSrampArchiveException {
        return new KieJarToSrampArchive(zipStream);
    }

    static {
        acceptedTypes.add("KieJarArchive");
    }
}

