/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.kie.expand;

import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.overlord.sramp.atom.archive.expand.ZipToSrampArchive;
import org.overlord.sramp.atom.archive.expand.ZipToSrampArchiveException;
import org.overlord.sramp.atom.archive.expand.registry.TypeHintInfo;
import org.overlord.sramp.atom.archive.expand.registry.ZipToSrampArchiveProvider;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.integration.kie.expand.KieJarToSrampArchive;

public class KieJarToSrampArchiveProvider
implements ZipToSrampArchiveProvider {
    private static final Set<String> acceptedTypes = new HashSet<String>();
    private static final Map<String, String> hintsMap;

    public boolean accept(ArtifactType artifactType) {
        if (artifactType.isExtendedType()) {
            String extendedType = artifactType.getExtendedType();
            return acceptedTypes.contains(extendedType);
        }
        return false;
    }

    public ZipToSrampArchive createExtractor(ArtifactType artifactType, File zipFile) throws ZipToSrampArchiveException {
        return new KieJarToSrampArchive(zipFile);
    }

    public ZipToSrampArchive createExtractor(ArtifactType artifactType, InputStream zipStream) throws ZipToSrampArchiveException {
        return new KieJarToSrampArchive(zipStream);
    }

    public TypeHintInfo getArchiveTypeHints() {
        return new TypeHintInfo(Integer.valueOf(10), hintsMap);
    }

    static {
        acceptedTypes.add("KieJarArchive");
        TreeMap<String, String> aMap = new TreeMap<String, String>();
        aMap.put("META-INF/kmodule.xml", "KieJarArchive");
        hintsMap = Collections.unmodifiableMap(aMap);
    }
}

