/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.switchyard.expand;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.overlord.sramp.common.query.xpath.StaticNamespaceContext;
import org.overlord.sramp.integration.switchyard.model.SwitchYardModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SwitchYardAppIndex {
    private File switchyardXml;
    private Set<String> javaClasses = new HashSet<String>();

    public SwitchYardAppIndex(File switchyardXml) {
        this.switchyardXml = switchyardXml;
        this.index();
    }

    private void index() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(this.switchyardXml);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            StaticNamespaceContext nsCtx = new StaticNamespaceContext();
            SwitchYardModel.addNamespaceMappings(nsCtx);
            xpath.setNamespaceContext((NamespaceContext)nsCtx);
            Element rootElement = document.getDocumentElement();
            this.index(xpath, rootElement);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void index(XPath xpath, Element rootElement) throws XPathExpressionException {
        AttributeValueParser attrParser = new AttributeValueParser(){

            @Override
            public String parse(String attributeValue) {
                if (attributeValue.startsWith("java:")) {
                    return attributeValue.substring(5);
                }
                return null;
            }
        };
        this.indexJavaClassesFromAttributes(xpath, rootElement, "//bean:implementation.bean/@class");
        this.indexJavaClassesFromAttributes(xpath, rootElement, "//sca:interface.java/@interface");
        this.indexJavaClassesFromAttributes(xpath, rootElement, "//tf:transform.java/@from", attrParser);
        this.indexJavaClassesFromAttributes(xpath, rootElement, "//tf:transform.java/@to", attrParser);
        this.indexJavaClassesFromAttributes(xpath, rootElement, "//tf:transform.java/@class");
        this.indexJavaClassesFromAttributes(xpath, rootElement, "//tf:transform.java/@bean");
        this.indexJavaClassesFromAttributes(xpath, rootElement, "//tf:validate.java/@from", attrParser);
        this.indexJavaClassesFromAttributes(xpath, rootElement, "//tf:validate.java/@to", attrParser);
        this.indexJavaClassesFromAttributes(xpath, rootElement, "//tf:validate.java/@class");
        this.indexJavaClassesFromAttributes(xpath, rootElement, "//tf:validate.java/@bean");
    }

    private void indexJavaClassesFromAttributes(XPath xpath, Element rootElement, String expression) throws XPathExpressionException {
        this.indexJavaClassesFromAttributes(xpath, rootElement, expression, null);
    }

    private void indexJavaClassesFromAttributes(XPath xpath, Element rootElement, String expression, AttributeValueParser attributeValueParser) throws XPathExpressionException {
        NodeList nodes = (NodeList)xpath.evaluate(expression, rootElement, XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Attr node = (Attr)nodes.item(idx);
            String beanName = null;
            beanName = attributeValueParser != null ? attributeValueParser.parse(node.getValue()) : node.getValue();
            if (beanName == null) continue;
            this.javaClasses.add(beanName);
        }
    }

    public boolean contains(String fullyQualifiedJavaClassname) {
        return this.javaClasses.contains(fullyQualifiedJavaClassname);
    }

    private static interface AttributeValueParser {
        public String parse(String var1);
    }
}

