/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.teiid.deriver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Property;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.common.derived.AbstractXmlDeriver;
import org.overlord.sramp.common.derived.LinkerContext;
import org.overlord.sramp.integration.teiid.Messages;
import org.overlord.sramp.integration.teiid.Utils;
import org.overlord.sramp.integration.teiid.model.TeiidExtendedType;
import org.overlord.sramp.integration.teiid.model.VdbDataPolicy;
import org.overlord.sramp.integration.teiid.model.VdbEntry;
import org.overlord.sramp.integration.teiid.model.VdbImport;
import org.overlord.sramp.integration.teiid.model.VdbManifest;
import org.overlord.sramp.integration.teiid.model.VdbPermission;
import org.overlord.sramp.integration.teiid.model.VdbSchema;
import org.overlord.sramp.integration.teiid.model.VdbSchemaSource;
import org.overlord.sramp.integration.teiid.model.VdbTranslator;
import org.overlord.sramp.integration.teiid.model.VdbValidationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class VdbManifestDeriver
extends AbstractXmlDeriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(VdbManifestDeriver.class);
    public static final char ROLE_NAME_DELIMETER = ',';
    private final Collection<BaseArtifactType> sources = new ArrayList<BaseArtifactType>();
    private final Collection<BaseArtifactType> translators = new ArrayList<BaseArtifactType>();

    private static BaseArtifactType create(TeiidExtendedType extendedType) {
        ExtendedArtifactType artifact = new ExtendedArtifactType();
        artifact.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
        artifact.setExtendedType(extendedType.extendedType());
        artifact.setUuid(UUID.randomUUID().toString());
        return artifact;
    }

    protected void derive(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType artifact, AbstractXmlDeriver.XmlDeriverContext xmlDeriverContext) throws IOException {
        Element rootElement = xmlDeriverContext.getRootElement();
        LOGGER.debug("VdbManifestDeriver:root element='{}' of artifact '{}'", (Object)rootElement.getLocalName(), (Object)artifact.getName());
        this.sources.clear();
        this.translators.clear();
        if (!(artifact instanceof ExtendedDocument) || !VdbManifest.ARTIFACT_TYPE.extendedType().equals(((ExtendedDocument)artifact).getExtendedType())) {
            throw new IllegalArgumentException(Messages.I18N.format("notVdbArtifact", new Object[]{artifact.getName()}));
        }
        ExtendedDocument vdbArtifact = (ExtendedDocument)artifact;
        try {
            if (!"vdb".equals(rootElement.getLocalName())) {
                throw new IllegalArgumentException(Messages.I18N.format("missingVdbRootElement", new Object[]{artifact.getName()}));
            }
            this.processVdb(derivedArtifacts, vdbArtifact, rootElement, xmlDeriverContext.getXpath());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void link(LinkerContext context, BaseArtifactType vdbManifestArtifact, Collection<BaseArtifactType> derivedArtifacts) {
        if (!Utils.isEmpty(this.sources) && !Utils.isEmpty(this.translators)) {
            for (BaseArtifactType sourceArtifact : this.sources) {
                String translatorName = SrampModelUtils.getCustomProperty((BaseArtifactType)sourceArtifact, (String)"translatorName");
                if (Utils.isEmpty(translatorName)) continue;
                for (BaseArtifactType translatorArtifact : this.translators) {
                    if (!translatorName.equals(translatorArtifact.getName())) continue;
                    LOGGER.debug("VdbManifestDeriver:adding relationships between source '{}' and translator '{}'", (Object)sourceArtifact.getName(), (Object)translatorArtifact.getName());
                    Utils.addTwoWayRelationship(sourceArtifact, translatorArtifact, VdbSchemaSource.TRANSLATOR_RELATIONSHIP, VdbTranslator.SOURCES_RELATIONSHIP);
                }
            }
        }
    }

    private void processDataRoles(Collection<BaseArtifactType> derivedArtifacts, ExtendedDocument vdbArtifact, Element vdb, XPath xpath) throws Exception {
        NodeList dataPolicies = (NodeList)this.query(xpath, vdb, Utils.getElementQueryString("data-role"), XPathConstants.NODESET);
        if (dataPolicies.getLength() != 0) {
            LOGGER.debug("VdbManifestDeriver:processing '{}' data policies", (Object)dataPolicies.getLength());
            int numDataPolicies = dataPolicies.getLength();
            for (int dataPolicyIndex = 0; dataPolicyIndex < numDataPolicies; ++dataPolicyIndex) {
                NodeList permissions;
                Element dataPolicy = (Element)dataPolicies.item(dataPolicyIndex);
                BaseArtifactType dataPolicyArtifact = VdbManifestDeriver.create(VdbDataPolicy.ARTIFACT_TYPE);
                derivedArtifacts.add(dataPolicyArtifact);
                String name = dataPolicy.getAttribute("name");
                dataPolicyArtifact.setName(name);
                String anyAuthenticated = dataPolicy.getAttribute("any-authenticated");
                SrampModelUtils.setCustomProperty((BaseArtifactType)dataPolicyArtifact, (String)"anyAuthenticated", (String)anyAuthenticated);
                String creatable = dataPolicy.getAttribute("allow-create-temporary-tables");
                SrampModelUtils.setCustomProperty((BaseArtifactType)dataPolicyArtifact, (String)"tempTableCreatable", (String)creatable);
                this.setDescriptionFromElementValue(dataPolicy, "description", dataPolicyArtifact, xpath);
                NodeList roleNames = (NodeList)this.query(xpath, dataPolicy, Utils.getElementQueryString("mapped-role-name"), XPathConstants.NODESET);
                if (roleNames.getLength() != 0) {
                    LOGGER.debug("VdbManifestDeriver:processing '{}' mapped role names for data policy '{}'", (Object)roleNames.getLength(), (Object)dataPolicyArtifact.getName());
                    StringBuilder mappedNames = new StringBuilder();
                    int numRoleNames = roleNames.getLength();
                    for (int roleNameIndex = 0; roleNameIndex < numRoleNames; ++roleNameIndex) {
                        if (roleNameIndex != 0) {
                            mappedNames.append(',');
                        }
                        Element roleName = (Element)roleNames.item(roleNameIndex);
                        String name2 = roleName.getTextContent();
                        mappedNames.append(name2);
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug("VdbManifestDeriver:found mapped role name '{}' for data policy '{}'", (Object)dataPolicyArtifact.getName());
                    }
                    SrampModelUtils.setCustomProperty((BaseArtifactType)dataPolicyArtifact, (String)"roleNames", (String)mappedNames.toString());
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("VdbManifestDeriver:data policy name '{}'", (Object)dataPolicyArtifact.getName());
                    LOGGER.debug("VdbManifestDeriver:data policy description '{}'", (Object)dataPolicyArtifact.getDescription());
                    for (Property prop : dataPolicyArtifact.getProperty()) {
                        LOGGER.debug("VdbManifestDeriver:data policy property '{}' with value '{}'", (Object)prop.getPropertyName(), (Object)prop.getPropertyValue());
                    }
                }
                if ((permissions = (NodeList)this.query(xpath, dataPolicy, Utils.getElementQueryString("permission"), XPathConstants.NODESET)).getLength() != 0) {
                    LOGGER.debug("VdbManifestDeriver:processing '{}' data permissions for data policy '{}'", (Object)permissions.getLength(), (Object)dataPolicyArtifact.getName());
                    int numPermissions = permissions.getLength();
                    for (int permissionIndex = 0; permissionIndex < numPermissions; ++permissionIndex) {
                        Element permission = (Element)permissions.item(permissionIndex);
                        BaseArtifactType permissionArtifact = VdbManifestDeriver.create(VdbPermission.ARTIFACT_TYPE);
                        derivedArtifacts.add(permissionArtifact);
                        Element element = (Element)this.query(xpath, permission, Utils.getElementQueryString("resource-name"), XPathConstants.NODE);
                        String resourceName = element.getTextContent();
                        permissionArtifact.setName(resourceName);
                        this.setPropertyFromElementValue(permission, "allow-alter", permissionArtifact, "alterable", xpath);
                        this.setPropertyFromElementValue(permission, "condition", permissionArtifact, "condition", xpath);
                        this.setPropertyFromElementValue(permission, "allow-create", permissionArtifact, "creatable", xpath);
                        this.setPropertyFromElementValue(permission, "allow-delete", permissionArtifact, "deletable", xpath);
                        this.setPropertyFromElementValue(permission, "allow-execute", permissionArtifact, "executable", xpath);
                        this.setPropertyFromElementValue(permission, "allow-language", permissionArtifact, "languagable", xpath);
                        this.setPropertyFromElementValue(permission, "mask", permissionArtifact, "mask", xpath);
                        this.setPropertyFromElementValue(permission, "allow-read", permissionArtifact, "readable", xpath);
                        this.setPropertyFromElementValue(permission, "allow-update", permissionArtifact, "updatable", xpath);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("VdbManifestDeriver:permission resource name '{}'", (Object)permissionArtifact.getName());
                            for (Property prop : permissionArtifact.getProperty()) {
                                LOGGER.debug("VdbManifestDeriver:Source property '{}' with value '{}'", (Object)prop.getPropertyName(), (Object)prop.getPropertyValue());
                            }
                        }
                        Utils.addTwoWayRelationship(dataPolicyArtifact, permissionArtifact, VdbDataPolicy.PERMISSIONS_RELATIONSHIP, VdbPermission.DATA_POLICY_RELATIONSHIP);
                    }
                }
                Utils.addRelationship((BaseArtifactType)vdbArtifact, dataPolicyArtifact, VdbManifest.CONTAINS_RELATIONSHIP);
            }
        }
    }

    private void processEntries(Collection<BaseArtifactType> derivedArtifacts, ExtendedDocument vdbArtifact, Element vdb, XPath xpath) throws Exception {
        NodeList entries = (NodeList)this.query(xpath, vdb, Utils.getElementQueryString("entry"), XPathConstants.NODESET);
        if (entries.getLength() != 0) {
            LOGGER.debug("VdbManifestDeriver:processing '{}' entries", (Object)entries.getLength());
            int numEntries = entries.getLength();
            for (int entryIndex = 0; entryIndex < numEntries; ++entryIndex) {
                Element entry = (Element)entries.item(entryIndex);
                BaseArtifactType entryArtifact = VdbManifestDeriver.create(VdbEntry.ARTIFACT_TYPE);
                derivedArtifacts.add(entryArtifact);
                String path = entry.getAttribute("path");
                entryArtifact.setName(path);
                this.setDescriptionFromElementValue(entry, "description", entryArtifact, xpath);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("VdbManifestDeriver:entry path '{}'", (Object)entryArtifact.getName());
                    LOGGER.debug("VdbManifestDeriver:entry description '{}'", (Object)entryArtifact.getDescription());
                }
                this.processProperties(entryArtifact, entry, xpath);
                Utils.addRelationship((BaseArtifactType)vdbArtifact, entryArtifact, VdbManifest.CONTAINS_RELATIONSHIP);
            }
        }
    }

    private void processProperties(BaseArtifactType artifact, Element element, XPath xpath) throws Exception {
        NodeList props = (NodeList)this.query(xpath, element, Utils.getElementQueryString("property"), XPathConstants.NODESET);
        if (props.getLength() != 0) {
            LOGGER.debug("VdbManifestDeriver:processing '{}' properties", (Object)props.getLength());
            int numProps = props.getLength();
            for (int propIndex = 0; propIndex < numProps; ++propIndex) {
                Element prop = (Element)props.item(propIndex);
                String name = prop.getAttribute("name");
                String value = prop.getAttribute("value");
                SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)name, (String)value);
            }
            if (LOGGER.isDebugEnabled()) {
                for (Property prop : artifact.getProperty()) {
                    LOGGER.debug("VdbManifestDeriver:artifact '{}' has property '{}' with value '{}'", new Object[]{artifact.getName(), prop.getPropertyName(), prop.getPropertyValue()});
                }
            }
        }
    }

    private void processSchemas(Collection<BaseArtifactType> derivedArtifacts, ExtendedDocument vdbArtifact, Element vdb, XPath xpath) throws Exception {
        NodeList schemas = (NodeList)this.query(xpath, vdb, Utils.getElementQueryString("model"), XPathConstants.NODESET);
        if (schemas.getLength() != 0) {
            LOGGER.debug("VdbManifestDeriver:processing '{}' schemas", (Object)schemas.getLength());
            int numSchemas = schemas.getLength();
            for (int schemaIndex = 0; schemaIndex < numSchemas; ++schemaIndex) {
                String type;
                String path;
                String visible;
                Element schema = (Element)schemas.item(schemaIndex);
                BaseArtifactType schemaArtifact = VdbManifestDeriver.create(VdbSchema.ARTIFACT_TYPE);
                derivedArtifacts.add(schemaArtifact);
                String name = schema.getAttribute("name");
                schemaArtifact.setName(name);
                this.setDescriptionFromElementValue(schema, "description", schemaArtifact, xpath);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("VdbManifestDeriver:schema name '{}'", (Object)schemaArtifact.getName());
                    LOGGER.debug("VdbManifestDeriver:schema description '{}'", (Object)schemaArtifact.getDescription());
                }
                if (!Utils.isEmpty(visible = schema.getAttribute("visible"))) {
                    SrampModelUtils.setCustomProperty((BaseArtifactType)schemaArtifact, (String)"visible", (String)visible);
                }
                if (!Utils.isEmpty(path = schema.getAttribute("path"))) {
                    SrampModelUtils.setCustomProperty((BaseArtifactType)schemaArtifact, (String)"pathInVdb", (String)path);
                }
                if (Utils.isEmpty(type = schema.getAttribute("type"))) {
                    type = VdbSchema.DEFAULT_TYPE.name();
                }
                SrampModelUtils.setCustomProperty((BaseArtifactType)schemaArtifact, (String)"schemaType", (String)type);
                Element element = this.setPropertyFromElementValue(schema, "metadata", schemaArtifact, "metadata", xpath);
                if (element != null) {
                    String metadataType = element.getAttribute("type");
                    SrampModelUtils.setCustomProperty((BaseArtifactType)schemaArtifact, (String)"metadataType", (String)metadataType);
                }
                this.processProperties(schemaArtifact, schema, xpath);
                this.processSchemaValidationErrors(derivedArtifacts, schemaArtifact, schema, xpath);
                this.processSchemaSources(derivedArtifacts, schemaArtifact, schema, xpath);
                Utils.addRelationship((BaseArtifactType)vdbArtifact, schemaArtifact, VdbManifest.CONTAINS_RELATIONSHIP);
            }
        }
    }

    private void processSchemaSources(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType schemaArtifact, Element schema, XPath xpath) throws Exception {
        NodeList sources = (NodeList)this.query(xpath, schema, Utils.getElementQueryString("source"), XPathConstants.NODESET);
        if (sources.getLength() != 0) {
            LOGGER.debug("VdbManifestDeriver:processing '{}' sources for schema '{}'", (Object)sources.getLength(), (Object)schemaArtifact.getName());
            int numSources = sources.getLength();
            for (int sourceIndex = 0; sourceIndex < numSources; ++sourceIndex) {
                Element source = (Element)sources.item(sourceIndex);
                BaseArtifactType sourceArtifact = VdbManifestDeriver.create(VdbSchemaSource.ARTIFACT_TYPE);
                derivedArtifacts.add(sourceArtifact);
                this.sources.add(sourceArtifact);
                String name = source.getAttribute("name");
                sourceArtifact.setName(name);
                String jndiName = source.getAttribute("connection-jndi-name");
                SrampModelUtils.setCustomProperty((BaseArtifactType)sourceArtifact, (String)"jndiName", (String)jndiName);
                String translatorName = source.getAttribute("translator-name");
                SrampModelUtils.setCustomProperty((BaseArtifactType)sourceArtifact, (String)"translatorName", (String)translatorName);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("VdbManifestDeriver:schema source name '{}'", (Object)sourceArtifact.getName());
                    for (Property prop : sourceArtifact.getProperty()) {
                        LOGGER.debug("VdbManifestDeriver:Source property '{}' with value '{}'", (Object)prop.getPropertyName(), (Object)prop.getPropertyValue());
                    }
                }
                Utils.addTwoWayRelationship(schemaArtifact, sourceArtifact, VdbSchema.SOURCES_RELATIONSHIP, VdbSchemaSource.SCHEMA_RELATIONSHIP);
            }
        }
    }

    private void processSchemaValidationErrors(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType schemaArtifact, Element modelElement, XPath xpath) throws Exception {
        NodeList errors = (NodeList)this.query(xpath, modelElement, Utils.getElementQueryString("validation-error"), XPathConstants.NODESET);
        if (errors.getLength() != 0) {
            LOGGER.debug("VdbManifestDeriver:processing '{}' validation errors for schema '{}'", (Object)errors.getLength(), (Object)schemaArtifact.getName());
            int numErrors = errors.getLength();
            for (int i = 0; i < numErrors; ++i) {
                Element errorElement = (Element)errors.item(i);
                BaseArtifactType errorArtifact = VdbManifestDeriver.create(VdbValidationError.ARTIFACT_TYPE);
                derivedArtifacts.add(errorArtifact);
                String path = errorElement.getAttribute("path");
                if (Utils.isEmpty(path)) {
                    path = "/";
                }
                errorArtifact.setName(path);
                String severity = errorElement.getAttribute("severity");
                SrampModelUtils.setCustomProperty((BaseArtifactType)errorArtifact, (String)"severity", (String)severity);
                String message = errorElement.getTextContent();
                SrampModelUtils.setCustomProperty((BaseArtifactType)errorArtifact, (String)"message", (String)message);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("VdbManifestDeriver:model artifact '{}' has validation error with severity '{}', path '{}', and message '{}'", new Object[]{schemaArtifact.getName(), SrampModelUtils.getCustomProperty((BaseArtifactType)errorArtifact, (String)"severity"), errorArtifact.getName(), SrampModelUtils.getCustomProperty((BaseArtifactType)errorArtifact, (String)"message")});
                }
                Utils.addTwoWayRelationship(schemaArtifact, errorArtifact, VdbSchema.VALIDATION_ERRORS_RELATIONSHIP, VdbValidationError.SOURCE_RELATIONSHIP);
            }
        }
    }

    private void processTranslators(Collection<BaseArtifactType> derivedArtifacts, ExtendedDocument vdbArtifact, Element vdb, XPath xpath) throws Exception {
        NodeList translators = (NodeList)this.query(xpath, vdb, Utils.getElementQueryString("translator"), XPathConstants.NODESET);
        if (translators.getLength() != 0) {
            LOGGER.debug("VdbManifestDeriver:processing '{}' translators", (Object)translators.getLength());
            int numTranslators = translators.getLength();
            for (int translatorIndex = 0; translatorIndex < numTranslators; ++translatorIndex) {
                Element translator = (Element)translators.item(translatorIndex);
                BaseArtifactType translatorArtifact = VdbManifestDeriver.create(VdbTranslator.ARTIFACT_TYPE);
                derivedArtifacts.add(translatorArtifact);
                this.translators.add(translatorArtifact);
                String name = translator.getAttribute("name");
                translatorArtifact.setName(name);
                String description = translator.getAttribute("description");
                translatorArtifact.setDescription(description);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("VdbManifestDeriver:translator name '{}'", (Object)translatorArtifact.getName());
                    LOGGER.debug("VdbManifestDeriver:translator description '{}'", (Object)translatorArtifact.getDescription());
                }
                String type = translator.getAttribute("type");
                SrampModelUtils.setCustomProperty((BaseArtifactType)translatorArtifact, (String)"translatorType", (String)type);
                this.processProperties(translatorArtifact, translator, xpath);
                Utils.addRelationship((BaseArtifactType)vdbArtifact, translatorArtifact, VdbManifest.CONTAINS_RELATIONSHIP);
            }
        }
    }

    private void processVdb(Collection<BaseArtifactType> derivedArtifacts, ExtendedDocument vdbArtifact, Element vdb, XPath xpath) throws Exception {
        String name = vdb.getAttribute("name");
        vdbArtifact.setName(name);
        this.setDescriptionFromElementValue(vdb, "description", (BaseArtifactType)vdbArtifact, xpath);
        this.setVdbVersion(vdb, "version", (BaseArtifactType)vdbArtifact, "vdbVersion");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("VdbManifestDeriver:VDB name '{}'", (Object)vdbArtifact.getName());
            LOGGER.debug("VdbManifestDeriver:VDB description '{}'", (Object)vdbArtifact.getDescription());
            LOGGER.debug("VdbManifestDeriver:VDB version '{}'", (Object)vdbArtifact.getVersion());
        }
        this.processProperties((BaseArtifactType)vdbArtifact, vdb, xpath);
        this.processVdbImports(derivedArtifacts, vdbArtifact, vdb, xpath);
        this.processTranslators(derivedArtifacts, vdbArtifact, vdb, xpath);
        this.processDataRoles(derivedArtifacts, vdbArtifact, vdb, xpath);
        this.processEntries(derivedArtifacts, vdbArtifact, vdb, xpath);
        this.processSchemas(derivedArtifacts, vdbArtifact, vdb, xpath);
    }

    private void processVdbImports(Collection<BaseArtifactType> derivedArtifacts, ExtendedDocument vdbArtifact, Element vdb, XPath xpath) throws Exception {
        NodeList vdbImports = (NodeList)this.query(xpath, vdb, Utils.getElementQueryString("import-vdb"), XPathConstants.NODESET);
        if (vdbImports.getLength() != 0) {
            LOGGER.debug("VdbManifestDeriver:processing '{}' VDB imports", (Object)vdbImports.getLength());
            int numVdbImports = vdbImports.getLength();
            for (int vdbImportIndex = 0; vdbImportIndex < numVdbImports; ++vdbImportIndex) {
                Element vdbImport = (Element)vdbImports.item(vdbImportIndex);
                BaseArtifactType vdbImportArtifact = VdbManifestDeriver.create(VdbImport.ARTIFACT_TYPE);
                derivedArtifacts.add(vdbImportArtifact);
                String name = vdbImport.getAttribute("name");
                vdbImportArtifact.setName(name);
                this.setVdbVersion(vdbImport, "version", vdbImportArtifact, "vdbVersion");
                String importDataPolicies = vdbImport.getAttribute("import-data-policies");
                if (Utils.isEmpty(importDataPolicies)) {
                    importDataPolicies = Boolean.toString(true);
                }
                SrampModelUtils.setCustomProperty((BaseArtifactType)vdbImportArtifact, (String)"importDataPolicies", (String)importDataPolicies);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("VdbManifestDeriver:Import VDB name '{}'", (Object)vdbImportArtifact.getName());
                    LOGGER.debug("VdbManifestDeriver:Import VDB version '{}'", (Object)vdbImportArtifact.getVersion());
                    for (Property prop : vdbImportArtifact.getProperty()) {
                        LOGGER.debug("VdbManifestDeriver:Import VDB property '{}' with value '{}'", (Object)prop.getPropertyName(), (Object)prop.getPropertyValue());
                    }
                }
                Utils.addRelationship((BaseArtifactType)vdbArtifact, vdbImportArtifact, VdbManifest.CONTAINS_RELATIONSHIP);
            }
        }
    }

    protected Object query(XPath xpath, Element context, String query, QName returnType) throws XPathExpressionException {
        LOGGER.debug("VdbManifestDeriver:executing query '{}'", (Object)query);
        return super.query(xpath, context, query, returnType);
    }

    private void setDescriptionFromElementValue(Element parent, String elementName, BaseArtifactType artifact, XPath xpath) throws Exception {
        Element element = (Element)this.query(xpath, parent, Utils.getElementQueryString(elementName), XPathConstants.NODE);
        if (element != null) {
            String description = element.getTextContent();
            artifact.setDescription(description);
        }
    }

    private Element setPropertyFromElementValue(Element parent, String elementName, BaseArtifactType artifact, String propertyName, XPath xpath) throws Exception {
        Element element = (Element)this.query(xpath, parent, Utils.getElementQueryString(elementName), XPathConstants.NODE);
        if (element != null) {
            String value = element.getTextContent();
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)propertyName, (String)value);
        }
        return element;
    }

    private void setVdbVersion(Element element, String attributeName, BaseArtifactType artifact, String propertyName) throws Exception {
        String version = element.getAttribute(attributeName);
        if (Utils.isEmpty(version)) {
            version = "1";
        }
        SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)propertyName, (String)version);
        if (Utils.isEmpty(artifact.getVersion())) {
            artifact.setVersion(version);
        }
    }
}

