/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.teiid.expand;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocument;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.archive.SrampArchiveEntry;
import org.overlord.sramp.atom.archive.expand.ZipToSrampArchive;
import org.overlord.sramp.integration.teiid.deriver.TeiidIntegrationTest;
import org.overlord.sramp.integration.teiid.expand.VdbToSrampArchive;
import org.overlord.sramp.integration.teiid.model.TeiidArtifactType;
import org.overlord.sramp.integration.teiid.model.VdbManifest;

public final class VdbToSrampArchiveTest
extends TeiidIntegrationTest {
    private void assertManifest(SrampArchive srampArchive) {
        SrampArchiveEntry manifestEntry = srampArchive.getEntry("META-INF/vdb.xml");
        Assert.assertThat((Object)manifestEntry, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsNull.nullValue())));
        BaseArtifactType manifestArtifact = manifestEntry.getMetaData();
        Assert.assertThat((Object)manifestArtifact, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(ExtendedDocument.class)));
        Assert.assertThat((Object)((ExtendedDocument)manifestArtifact).getExtendedType(), (Matcher)Is.is((Object)VdbManifest.ARTIFACT_TYPE.extendedType()));
    }

    private void assertModel(SrampArchive srampArchive, String modelEntryPath) {
        SrampArchiveEntry manifestEntry = srampArchive.getEntry(modelEntryPath);
        Assert.assertThat((Object)manifestEntry, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsNull.nullValue())));
        BaseArtifactType manifestArtifact = manifestEntry.getMetaData();
        Assert.assertThat((Object)manifestArtifact, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(ExtendedDocument.class)));
        Assert.assertThat((Object)((ExtendedDocument)manifestArtifact).getExtendedType(), (Matcher)Is.is((Object)TeiidArtifactType.MODEL.extendedType()));
    }

    private void assertXsd(SrampArchive srampArchive, String fileEntryPath) {
        SrampArchiveEntry manifestEntry = srampArchive.getEntry(fileEntryPath);
        Assert.assertThat((Object)manifestEntry, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsNull.nullValue())));
        BaseArtifactType manifestArtifact = manifestEntry.getMetaData();
        Assert.assertThat((Object)manifestArtifact, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(XsdDocument.class)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldExpandBooksVdb() throws Exception {
        InputStream stream = this.getResourceAsStream("BooksVdb.vdb");
        VdbToSrampArchive vdbArchive = null;
        SrampArchive srampArchive = null;
        try {
            vdbArchive = new VdbToSrampArchive(stream);
            srampArchive = vdbArchive.createSrampArchive();
            Assert.assertThat((Object)srampArchive, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsNull.nullValue())));
            Assert.assertThat((Object)srampArchive.getEntries().size(), (Matcher)Is.is((Object)7));
            this.assertManifest(srampArchive);
            this.assertModel(srampArchive, "BooksProject/Books_Oracle.xmi");
            this.assertModel(srampArchive, "BooksProject/BooksView_Output_View.xmi");
            this.assertModel(srampArchive, "BooksProject/BooksView_WS.xmi");
            this.assertModel(srampArchive, "BooksProject/BooksView.xmi");
            this.assertXsd(srampArchive, "BooksProject/BooksView_Input.xsd");
            this.assertXsd(srampArchive, "BooksProject/BooksView_Output.xsd");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)stream);
            SrampArchive.closeQuietly(srampArchive);
            ZipToSrampArchive.closeQuietly((ZipToSrampArchive)vdbArchive);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
        SrampArchive.closeQuietly((SrampArchive)srampArchive);
        ZipToSrampArchive.closeQuietly((ZipToSrampArchive)vdbArchive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldExpandProductsVdb() throws Exception {
        InputStream stream = this.getResourceAsStream("ProductsSS_VDB.vdb");
        VdbToSrampArchive vdbArchive = null;
        SrampArchive srampArchive = null;
        try {
            vdbArchive = new VdbToSrampArchive(stream);
            srampArchive = vdbArchive.createSrampArchive();
            Assert.assertThat((Object)srampArchive, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsNull.nullValue())));
            Assert.assertThat((Object)srampArchive.getEntries().size(), (Matcher)Is.is((Object)2));
            this.assertManifest(srampArchive);
            this.assertModel(srampArchive, "TestProducts/ProductsSS.xmi");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)stream);
            SrampArchive.closeQuietly(srampArchive);
            ZipToSrampArchive.closeQuietly((ZipToSrampArchive)vdbArchive);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
        SrampArchive.closeQuietly((SrampArchive)srampArchive);
        ZipToSrampArchive.closeQuietly((ZipToSrampArchive)vdbArchive);
    }
}

