/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.teiid.artifactbuilder;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Relationship;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Target;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.integration.teiid.Utils;
import org.overlord.sramp.integration.teiid.model.TeiidExtendedType;
import org.overlord.sramp.integration.teiid.model.TeiidRelationshipType;

public abstract class TeiidIntegrationTest {
    protected void assertPropertyValue(BaseArtifactType artifact, String customPropertyName, String expected) throws Exception {
        assert (artifact != null);
        assert (customPropertyName != null && !customPropertyName.isEmpty());
        String actual = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)customPropertyName);
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)expected));
    }

    protected void assertRelationshipTargetUuid(BaseArtifactType artifact, TeiidRelationshipType relationshipType, String targetArtifactUuid) {
        assert (artifact != null);
        assert (relationshipType != null);
        assert (targetArtifactUuid != null && !targetArtifactUuid.isEmpty());
        List relationships = artifact.getRelationship();
        if (Utils.isEmpty((Collection)relationships)) {
            throw new AssertionError((Object)("No relationships found for artifact '" + artifact.getName() + '\''));
        }
        boolean relationshipFound = false;
        boolean targetFound = false;
        block0: for (Relationship relationship : relationships) {
            if (!relationship.getRelationshipType().equals(relationshipType.relationshipType())) continue;
            relationshipFound = true;
            List targets = relationship.getRelationshipTarget();
            if (Utils.isEmpty((Collection)targets)) {
                throw new AssertionError((Object)("No targets found for relationship '" + relationshipType + "' and artifact '" + artifact.getName() + '\''));
            }
            for (Target target : targets) {
                if (!targetArtifactUuid.equals(target.getValue())) continue;
                targetFound = true;
                continue block0;
            }
        }
        if (!relationshipFound) {
            throw new AssertionError((Object)("Relationship '" + relationshipType + "' was not found for artifact '" + artifact.getName() + '\''));
        }
        if (!targetFound) {
            throw new AssertionError((Object)("Target '" + targetArtifactUuid + ", for relationship '" + relationshipType + "' and artifact '" + artifact.getName() + "' was not found"));
        }
    }

    protected InputStream getResourceAsStream(String fileName) {
        return this.getClass().getResourceAsStream(fileName);
    }

    protected boolean isExtendedType(BaseArtifactType artifact, TeiidExtendedType extendedType) {
        assert (artifact != null);
        assert (extendedType != null);
        if (artifact instanceof ExtendedArtifactType) {
            return extendedType.extendedType().equals(((ExtendedArtifactType)artifact).getExtendedType());
        }
        return false;
    }
}

