/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.teiid.artifactbuilder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Property;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.common.artifactbuilder.ArtifactBuilder;
import org.overlord.sramp.common.artifactbuilder.XmlArtifactBuilder;
import org.overlord.sramp.integration.teiid.Messages;
import org.overlord.sramp.integration.teiid.Utils;
import org.overlord.sramp.integration.teiid.model.TeiidExtendedType;
import org.overlord.sramp.integration.teiid.model.VdbDataPolicy;
import org.overlord.sramp.integration.teiid.model.VdbEntry;
import org.overlord.sramp.integration.teiid.model.VdbImport;
import org.overlord.sramp.integration.teiid.model.VdbManifest;
import org.overlord.sramp.integration.teiid.model.VdbPermission;
import org.overlord.sramp.integration.teiid.model.VdbSchema;
import org.overlord.sramp.integration.teiid.model.VdbSchemaSource;
import org.overlord.sramp.integration.teiid.model.VdbTranslator;
import org.overlord.sramp.integration.teiid.model.VdbValidationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Component(name="VDB Artifact Builder", immediate=true)
@Service(value={ArtifactBuilder.class})
public final class VdbManifestArtifactBuilder
extends XmlArtifactBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(VdbManifestArtifactBuilder.class);
    public static final char ROLE_NAME_DELIMETER = ',';
    private final Collection<BaseArtifactType> sources = new ArrayList<BaseArtifactType>();
    private final Collection<BaseArtifactType> translators = new ArrayList<BaseArtifactType>();
    private final List<BaseArtifactType> derivedArtifacts = new ArrayList<BaseArtifactType>();

    private static BaseArtifactType create(TeiidExtendedType extendedType) {
        ExtendedArtifactType artifact = new ExtendedArtifactType();
        artifact.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
        artifact.setExtendedType(extendedType.extendedType());
        artifact.setUuid(UUID.randomUUID().toString());
        return artifact;
    }

    protected void derive() throws IOException {
        LOGGER.debug("VdbManifestArtifactBuilder:root element='{}' of artifact '{}'", (Object)this.rootElement.getLocalName(), (Object)this.getPrimaryArtifact().getName());
        this.sources.clear();
        this.translators.clear();
        if (!(this.getPrimaryArtifact() instanceof ExtendedDocument) || !VdbManifest.ARTIFACT_TYPE.extendedType().equals(((ExtendedDocument)this.getPrimaryArtifact()).getExtendedType())) {
            throw new IllegalArgumentException(Messages.I18N.format("notVdbArtifact", new Object[]{this.getPrimaryArtifact().getName()}));
        }
        try {
            if (!"vdb".equals(this.rootElement.getLocalName())) {
                throw new IllegalArgumentException(Messages.I18N.format("missingVdbRootElement", new Object[]{this.getPrimaryArtifact().getName()}));
            }
            this.processVdb();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (!Utils.isEmpty(this.sources) && !Utils.isEmpty(this.translators)) {
            for (BaseArtifactType sourceArtifact : this.sources) {
                String translatorName = SrampModelUtils.getCustomProperty((BaseArtifactType)sourceArtifact, (String)"translatorName");
                if (Utils.isEmpty(translatorName)) continue;
                for (BaseArtifactType translatorArtifact : this.translators) {
                    if (!translatorName.equals(translatorArtifact.getName())) continue;
                    LOGGER.debug("VdbManifestArtifactBuilder:adding relationships between source '{}' and translator '{}'", (Object)sourceArtifact.getName(), (Object)translatorArtifact.getName());
                    Utils.addTwoWayRelationship(sourceArtifact, translatorArtifact, VdbSchemaSource.TRANSLATOR_RELATIONSHIP, VdbTranslator.SOURCES_RELATIONSHIP);
                }
            }
        }
    }

    public Collection<BaseArtifactType> getDerivedArtifacts() {
        return this.derivedArtifacts;
    }

    private void processDataRoles() throws Exception {
        NodeList dataPolicies = (NodeList)this.query(this.rootElement, Utils.getElementQueryString("data-role"), XPathConstants.NODESET);
        if (dataPolicies.getLength() != 0) {
            LOGGER.debug("VdbManifestArtifactBuilder:processing '{}' data policies", (Object)dataPolicies.getLength());
            int numDataPolicies = dataPolicies.getLength();
            for (int dataPolicyIndex = 0; dataPolicyIndex < numDataPolicies; ++dataPolicyIndex) {
                NodeList permissions;
                Element dataPolicy = (Element)dataPolicies.item(dataPolicyIndex);
                BaseArtifactType dataPolicyArtifact = VdbManifestArtifactBuilder.create(VdbDataPolicy.ARTIFACT_TYPE);
                this.derivedArtifacts.add(dataPolicyArtifact);
                String name = dataPolicy.getAttribute("name");
                dataPolicyArtifact.setName(name);
                String anyAuthenticated = dataPolicy.getAttribute("any-authenticated");
                SrampModelUtils.setCustomProperty((BaseArtifactType)dataPolicyArtifact, (String)"anyAuthenticated", (String)anyAuthenticated);
                String creatable = dataPolicy.getAttribute("allow-create-temporary-tables");
                SrampModelUtils.setCustomProperty((BaseArtifactType)dataPolicyArtifact, (String)"tempTableCreatable", (String)creatable);
                this.setDescriptionFromElementValue(dataPolicy, "description", dataPolicyArtifact, this.xpath);
                NodeList roleNames = (NodeList)this.query(dataPolicy, Utils.getElementQueryString("mapped-role-name"), XPathConstants.NODESET);
                if (roleNames.getLength() != 0) {
                    LOGGER.debug("VdbManifestArtifactBuilder:processing '{}' mapped role names for data policy '{}'", (Object)roleNames.getLength(), (Object)dataPolicyArtifact.getName());
                    StringBuilder mappedNames = new StringBuilder();
                    int numRoleNames = roleNames.getLength();
                    for (int roleNameIndex = 0; roleNameIndex < numRoleNames; ++roleNameIndex) {
                        if (roleNameIndex != 0) {
                            mappedNames.append(',');
                        }
                        Element roleName = (Element)roleNames.item(roleNameIndex);
                        String name2 = roleName.getTextContent();
                        mappedNames.append(name2);
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug("VdbManifestArtifactBuilder:found mapped role name '{}' for data policy '{}'", (Object)dataPolicyArtifact.getName());
                    }
                    SrampModelUtils.setCustomProperty((BaseArtifactType)dataPolicyArtifact, (String)"roleNames", (String)mappedNames.toString());
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("VdbManifestArtifactBuilder:data policy name '{}'", (Object)dataPolicyArtifact.getName());
                    LOGGER.debug("VdbManifestArtifactBuilder:data policy description '{}'", (Object)dataPolicyArtifact.getDescription());
                    for (Property prop : dataPolicyArtifact.getProperty()) {
                        LOGGER.debug("VdbManifestArtifactBuilder:data policy property '{}' with value '{}'", (Object)prop.getPropertyName(), (Object)prop.getPropertyValue());
                    }
                }
                if ((permissions = (NodeList)this.query(dataPolicy, Utils.getElementQueryString("permission"), XPathConstants.NODESET)).getLength() != 0) {
                    LOGGER.debug("VdbManifestArtifactBuilder:processing '{}' data permissions for data policy '{}'", (Object)permissions.getLength(), (Object)dataPolicyArtifact.getName());
                    int numPermissions = permissions.getLength();
                    for (int permissionIndex = 0; permissionIndex < numPermissions; ++permissionIndex) {
                        Element permission = (Element)permissions.item(permissionIndex);
                        BaseArtifactType permissionArtifact = VdbManifestArtifactBuilder.create(VdbPermission.ARTIFACT_TYPE);
                        this.derivedArtifacts.add(permissionArtifact);
                        Element element = (Element)this.query(permission, Utils.getElementQueryString("resource-name"), XPathConstants.NODE);
                        String resourceName = element.getTextContent();
                        permissionArtifact.setName(resourceName);
                        this.setPropertyFromElementValue(permission, "allow-alter", permissionArtifact, "alterable", this.xpath);
                        this.setPropertyFromElementValue(permission, "condition", permissionArtifact, "condition", this.xpath);
                        this.setPropertyFromElementValue(permission, "allow-create", permissionArtifact, "creatable", this.xpath);
                        this.setPropertyFromElementValue(permission, "allow-delete", permissionArtifact, "deletable", this.xpath);
                        this.setPropertyFromElementValue(permission, "allow-execute", permissionArtifact, "executable", this.xpath);
                        this.setPropertyFromElementValue(permission, "allow-language", permissionArtifact, "languagable", this.xpath);
                        this.setPropertyFromElementValue(permission, "mask", permissionArtifact, "mask", this.xpath);
                        this.setPropertyFromElementValue(permission, "allow-read", permissionArtifact, "readable", this.xpath);
                        this.setPropertyFromElementValue(permission, "allow-update", permissionArtifact, "updatable", this.xpath);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("VdbManifestArtifactBuilder:permission resource name '{}'", (Object)permissionArtifact.getName());
                            for (Property prop : permissionArtifact.getProperty()) {
                                LOGGER.debug("VdbManifestArtifactBuilder:Source property '{}' with value '{}'", (Object)prop.getPropertyName(), (Object)prop.getPropertyValue());
                            }
                        }
                        Utils.addTwoWayRelationship(dataPolicyArtifact, permissionArtifact, VdbDataPolicy.PERMISSIONS_RELATIONSHIP, VdbPermission.DATA_POLICY_RELATIONSHIP);
                    }
                }
                Utils.addRelationship(this.getPrimaryArtifact(), dataPolicyArtifact, VdbManifest.CONTAINS_RELATIONSHIP);
            }
        }
    }

    private void processEntries() throws Exception {
        NodeList entries = (NodeList)this.query(this.rootElement, Utils.getElementQueryString("entry"), XPathConstants.NODESET);
        if (entries.getLength() != 0) {
            LOGGER.debug("VdbManifestArtifactBuilder:processing '{}' entries", (Object)entries.getLength());
            int numEntries = entries.getLength();
            for (int entryIndex = 0; entryIndex < numEntries; ++entryIndex) {
                Element entry = (Element)entries.item(entryIndex);
                BaseArtifactType entryArtifact = VdbManifestArtifactBuilder.create(VdbEntry.ARTIFACT_TYPE);
                this.derivedArtifacts.add(entryArtifact);
                String path = entry.getAttribute("path");
                entryArtifact.setName(path);
                this.setDescriptionFromElementValue(entry, "description", entryArtifact, this.xpath);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("VdbManifestArtifactBuilder:entry path '{}'", (Object)entryArtifact.getName());
                    LOGGER.debug("VdbManifestArtifactBuilder:entry description '{}'", (Object)entryArtifact.getDescription());
                }
                this.processProperties(entryArtifact, entry);
                Utils.addRelationship(this.getPrimaryArtifact(), entryArtifact, VdbManifest.CONTAINS_RELATIONSHIP);
            }
        }
    }

    private void processProperties(BaseArtifactType artifact, Element element) throws Exception {
        NodeList props = (NodeList)this.query(element, Utils.getElementQueryString("property"), XPathConstants.NODESET);
        if (props.getLength() != 0) {
            LOGGER.debug("VdbManifestArtifactBuilder:processing '{}' properties", (Object)props.getLength());
            int numProps = props.getLength();
            for (int propIndex = 0; propIndex < numProps; ++propIndex) {
                Element prop = (Element)props.item(propIndex);
                String name = prop.getAttribute("name");
                String value = prop.getAttribute("value");
                SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)name, (String)value);
            }
            if (LOGGER.isDebugEnabled()) {
                for (Property prop : artifact.getProperty()) {
                    LOGGER.debug("VdbManifestArtifactBuilder:artifact '{}' has property '{}' with value '{}'", new Object[]{artifact.getName(), prop.getPropertyName(), prop.getPropertyValue()});
                }
            }
        }
    }

    private void processSchemas() throws Exception {
        NodeList schemas = (NodeList)this.query(this.rootElement, Utils.getElementQueryString("model"), XPathConstants.NODESET);
        if (schemas.getLength() != 0) {
            LOGGER.debug("VdbManifestArtifactBuilder:processing '{}' schemas", (Object)schemas.getLength());
            int numSchemas = schemas.getLength();
            for (int schemaIndex = 0; schemaIndex < numSchemas; ++schemaIndex) {
                String type;
                String path;
                String visible;
                Element schema = (Element)schemas.item(schemaIndex);
                BaseArtifactType schemaArtifact = VdbManifestArtifactBuilder.create(VdbSchema.ARTIFACT_TYPE);
                this.derivedArtifacts.add(schemaArtifact);
                String name = schema.getAttribute("name");
                schemaArtifact.setName(name);
                this.setDescriptionFromElementValue(schema, "description", schemaArtifact, this.xpath);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("VdbManifestArtifactBuilder:schema name '{}'", (Object)schemaArtifact.getName());
                    LOGGER.debug("VdbManifestArtifactBuilder:schema description '{}'", (Object)schemaArtifact.getDescription());
                }
                if (!Utils.isEmpty(visible = schema.getAttribute("visible"))) {
                    SrampModelUtils.setCustomProperty((BaseArtifactType)schemaArtifact, (String)"visible", (String)visible);
                }
                if (!Utils.isEmpty(path = schema.getAttribute("path"))) {
                    SrampModelUtils.setCustomProperty((BaseArtifactType)schemaArtifact, (String)"pathInVdb", (String)path);
                }
                if (Utils.isEmpty(type = schema.getAttribute("type"))) {
                    type = VdbSchema.DEFAULT_TYPE.name();
                }
                SrampModelUtils.setCustomProperty((BaseArtifactType)schemaArtifact, (String)"schemaType", (String)type);
                Element element = this.setPropertyFromElementValue(schema, "metadata", schemaArtifact, "metadata", this.xpath);
                if (element != null) {
                    String metadataType = element.getAttribute("type");
                    SrampModelUtils.setCustomProperty((BaseArtifactType)schemaArtifact, (String)"metadataType", (String)metadataType);
                }
                this.processProperties(schemaArtifact, schema);
                this.processSchemaValidationErrors(this.derivedArtifacts, schemaArtifact, schema, this.xpath);
                this.processSchemaSources(this.derivedArtifacts, schemaArtifact, schema, this.xpath);
                Utils.addRelationship(this.getPrimaryArtifact(), schemaArtifact, VdbManifest.CONTAINS_RELATIONSHIP);
            }
        }
    }

    private void processSchemaSources(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType schemaArtifact, Element schema, XPath xpath) throws Exception {
        NodeList sources = (NodeList)this.query(schema, Utils.getElementQueryString("source"), XPathConstants.NODESET);
        if (sources.getLength() != 0) {
            LOGGER.debug("VdbManifestArtifactBuilder:processing '{}' sources for schema '{}'", (Object)sources.getLength(), (Object)schemaArtifact.getName());
            int numSources = sources.getLength();
            for (int sourceIndex = 0; sourceIndex < numSources; ++sourceIndex) {
                Element source = (Element)sources.item(sourceIndex);
                BaseArtifactType sourceArtifact = VdbManifestArtifactBuilder.create(VdbSchemaSource.ARTIFACT_TYPE);
                derivedArtifacts.add(sourceArtifact);
                this.sources.add(sourceArtifact);
                String name = source.getAttribute("name");
                sourceArtifact.setName(name);
                String jndiName = source.getAttribute("connection-jndi-name");
                SrampModelUtils.setCustomProperty((BaseArtifactType)sourceArtifact, (String)"jndiName", (String)jndiName);
                String translatorName = source.getAttribute("translator-name");
                SrampModelUtils.setCustomProperty((BaseArtifactType)sourceArtifact, (String)"translatorName", (String)translatorName);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("VdbManifestArtifactBuilder:schema source name '{}'", (Object)sourceArtifact.getName());
                    for (Property prop : sourceArtifact.getProperty()) {
                        LOGGER.debug("VdbManifestArtifactBuilder:Source property '{}' with value '{}'", (Object)prop.getPropertyName(), (Object)prop.getPropertyValue());
                    }
                }
                Utils.addTwoWayRelationship(schemaArtifact, sourceArtifact, VdbSchema.SOURCES_RELATIONSHIP, VdbSchemaSource.SCHEMA_RELATIONSHIP);
            }
        }
    }

    private void processSchemaValidationErrors(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType schemaArtifact, Element modelElement, XPath xpath) throws Exception {
        NodeList errors = (NodeList)this.query(modelElement, Utils.getElementQueryString("validation-error"), XPathConstants.NODESET);
        if (errors.getLength() != 0) {
            LOGGER.debug("VdbManifestArtifactBuilder:processing '{}' validation errors for schema '{}'", (Object)errors.getLength(), (Object)schemaArtifact.getName());
            int numErrors = errors.getLength();
            for (int i = 0; i < numErrors; ++i) {
                Element errorElement = (Element)errors.item(i);
                BaseArtifactType errorArtifact = VdbManifestArtifactBuilder.create(VdbValidationError.ARTIFACT_TYPE);
                derivedArtifacts.add(errorArtifact);
                String path = errorElement.getAttribute("path");
                if (Utils.isEmpty(path)) {
                    path = "/";
                }
                errorArtifact.setName(path);
                String severity = errorElement.getAttribute("severity");
                SrampModelUtils.setCustomProperty((BaseArtifactType)errorArtifact, (String)"severity", (String)severity);
                String message = errorElement.getTextContent();
                SrampModelUtils.setCustomProperty((BaseArtifactType)errorArtifact, (String)"message", (String)message);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("VdbManifestArtifactBuilder:model artifact '{}' has validation error with severity '{}', path '{}', and message '{}'", new Object[]{schemaArtifact.getName(), SrampModelUtils.getCustomProperty((BaseArtifactType)errorArtifact, (String)"severity"), errorArtifact.getName(), SrampModelUtils.getCustomProperty((BaseArtifactType)errorArtifact, (String)"message")});
                }
                Utils.addTwoWayRelationship(schemaArtifact, errorArtifact, VdbSchema.VALIDATION_ERRORS_RELATIONSHIP, VdbValidationError.SOURCE_RELATIONSHIP);
            }
        }
    }

    private void processTranslators() throws Exception {
        NodeList translators = (NodeList)this.query(this.rootElement, Utils.getElementQueryString("translator"), XPathConstants.NODESET);
        if (translators.getLength() != 0) {
            LOGGER.debug("VdbManifestArtifactBuilder:processing '{}' translators", (Object)translators.getLength());
            int numTranslators = translators.getLength();
            for (int translatorIndex = 0; translatorIndex < numTranslators; ++translatorIndex) {
                Element translator = (Element)translators.item(translatorIndex);
                BaseArtifactType translatorArtifact = VdbManifestArtifactBuilder.create(VdbTranslator.ARTIFACT_TYPE);
                this.derivedArtifacts.add(translatorArtifact);
                this.translators.add(translatorArtifact);
                String name = translator.getAttribute("name");
                translatorArtifact.setName(name);
                String description = translator.getAttribute("description");
                translatorArtifact.setDescription(description);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("VdbManifestArtifactBuilder:translator name '{}'", (Object)translatorArtifact.getName());
                    LOGGER.debug("VdbManifestArtifactBuilder:translator description '{}'", (Object)translatorArtifact.getDescription());
                }
                String type = translator.getAttribute("type");
                SrampModelUtils.setCustomProperty((BaseArtifactType)translatorArtifact, (String)"translatorType", (String)type);
                this.processProperties(translatorArtifact, translator);
                Utils.addRelationship(this.getPrimaryArtifact(), translatorArtifact, VdbManifest.CONTAINS_RELATIONSHIP);
            }
        }
    }

    private void processVdb() throws Exception {
        String name = this.rootElement.getAttribute("name");
        this.getPrimaryArtifact().setName(name);
        this.setDescriptionFromElementValue(this.rootElement, "description", this.getPrimaryArtifact(), this.xpath);
        this.setVdbVersion(this.rootElement, "version", this.getPrimaryArtifact(), "vdbVersion");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("VdbManifestArtifactBuilder:VDB name '{}'", (Object)this.getPrimaryArtifact().getName());
            LOGGER.debug("VdbManifestArtifactBuilder:VDB description '{}'", (Object)this.getPrimaryArtifact().getDescription());
            LOGGER.debug("VdbManifestArtifactBuilder:VDB version '{}'", (Object)this.getPrimaryArtifact().getVersion());
        }
        this.processProperties(this.getPrimaryArtifact(), this.rootElement);
        this.processVdbImports();
        this.processTranslators();
        this.processDataRoles();
        this.processEntries();
        this.processSchemas();
    }

    private void processVdbImports() throws Exception {
        NodeList vdbImports = (NodeList)this.query(this.rootElement, Utils.getElementQueryString("import-vdb"), XPathConstants.NODESET);
        if (vdbImports.getLength() != 0) {
            LOGGER.debug("VdbManifestArtifactBuilder:processing '{}' VDB imports", (Object)vdbImports.getLength());
            int numVdbImports = vdbImports.getLength();
            for (int vdbImportIndex = 0; vdbImportIndex < numVdbImports; ++vdbImportIndex) {
                Element vdbImport = (Element)vdbImports.item(vdbImportIndex);
                BaseArtifactType vdbImportArtifact = VdbManifestArtifactBuilder.create(VdbImport.ARTIFACT_TYPE);
                this.derivedArtifacts.add(vdbImportArtifact);
                String name = vdbImport.getAttribute("name");
                vdbImportArtifact.setName(name);
                this.setVdbVersion(vdbImport, "version", vdbImportArtifact, "vdbVersion");
                String importDataPolicies = vdbImport.getAttribute("import-data-policies");
                if (Utils.isEmpty(importDataPolicies)) {
                    importDataPolicies = Boolean.toString(true);
                }
                SrampModelUtils.setCustomProperty((BaseArtifactType)vdbImportArtifact, (String)"importDataPolicies", (String)importDataPolicies);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("VdbManifestArtifactBuilder:Import VDB name '{}'", (Object)vdbImportArtifact.getName());
                    LOGGER.debug("VdbManifestArtifactBuilder:Import VDB version '{}'", (Object)vdbImportArtifact.getVersion());
                    for (Property prop : vdbImportArtifact.getProperty()) {
                        LOGGER.debug("VdbManifestArtifactBuilder:Import VDB property '{}' with value '{}'", (Object)prop.getPropertyName(), (Object)prop.getPropertyValue());
                    }
                }
                Utils.addRelationship(this.getPrimaryArtifact(), vdbImportArtifact, VdbManifest.CONTAINS_RELATIONSHIP);
            }
        }
    }

    protected Object query(Element context, String query, QName returnType) throws XPathExpressionException {
        LOGGER.debug("VdbManifestArtifactBuilder:executing query '{}'", (Object)query);
        return super.query(context, query, returnType);
    }

    private void setDescriptionFromElementValue(Element parent, String elementName, BaseArtifactType artifact, XPath xpath) throws Exception {
        Element element = (Element)this.query(parent, Utils.getElementQueryString(elementName), XPathConstants.NODE);
        if (element != null) {
            String description = element.getTextContent();
            artifact.setDescription(description);
        }
    }

    private Element setPropertyFromElementValue(Element parent, String elementName, BaseArtifactType artifact, String propertyName, XPath xpath) throws Exception {
        Element element = (Element)this.query(parent, Utils.getElementQueryString(elementName), XPathConstants.NODE);
        if (element != null) {
            String value = element.getTextContent();
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)propertyName, (String)value);
        }
        return element;
    }

    private void setVdbVersion(Element element, String attributeName, BaseArtifactType artifact, String propertyName) throws Exception {
        String version = element.getAttribute(attributeName);
        if (Utils.isEmpty(version)) {
            version = "1";
        }
        SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)propertyName, (String)version);
        if (Utils.isEmpty(artifact.getVersion())) {
            artifact.setVersion(version);
        }
    }
}

