/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.services.mvn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.SrampConstants;
import org.overlord.sramp.common.SrampException;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.repository.PersistenceFactory;
import org.overlord.sramp.repository.PersistenceManager;
import org.overlord.sramp.repository.QueryManager;
import org.overlord.sramp.repository.QueryManagerFactory;
import org.overlord.sramp.repository.query.ArtifactSet;
import org.overlord.sramp.repository.query.SrampQuery;
import org.overlord.sramp.server.i18n.Messages;
import org.overlord.sramp.server.services.MavenRepositoryService;
import org.overlord.sramp.server.services.mvn.MavenArtifactWrapper;
import org.overlord.sramp.server.services.mvn.MavenFileExtensionEnum;
import org.overlord.sramp.server.services.mvn.MavenMetaData;
import org.overlord.sramp.server.services.mvn.MavenRepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenRepositoryServiceImpl
implements MavenRepositoryService {
    private static Logger logger = LoggerFactory.getLogger(MavenRepositoryServiceImpl.class);
    private static final String MAVEN_SEPARATOR = "-";
    private static final String MAVEN_FILE_EXTENSION_SEPARATOR = ".";

    private ArtifactSet query(List<String> criteria, List<Object> parameters) throws SrampAtomException {
        ArtifactSet artifactSet = null;
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("/s-ramp");
        if (criteria.size() > 0) {
            queryBuilder.append("[");
            queryBuilder.append(StringUtils.join(criteria, (String)" and "));
            queryBuilder.append("]");
        }
        try {
            QueryManager queryManager = QueryManagerFactory.newInstance();
            SrampQuery srampQuery = queryManager.createQuery(queryBuilder.toString(), "lastModifiedTimestamp", false);
            for (Object parameter : parameters) {
                if (parameter instanceof String) {
                    srampQuery.setString((String)parameter);
                    continue;
                }
                if (!(parameter instanceof Date)) continue;
                srampQuery.setDate((Date)parameter);
            }
            artifactSet = srampQuery.executeQuery();
        }
        catch (Throwable e) {
            logger.error(Messages.i18n.format("maven.resource.query.error", new Object[]{queryBuilder.toString()}), e);
            throw new SrampAtomException(e);
        }
        return artifactSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MavenArtifactWrapper getArtifactContent(MavenMetaData metadata) throws MavenRepositoryException {
        ArrayList<String> criteria = new ArrayList<String>();
        ArrayList<String> parameters = new ArrayList<String>();
        criteria.add("@maven.artifactId = ?");
        criteria.add("@maven.groupId = ?");
        criteria.add("@maven.type = ?");
        parameters.add(metadata.getArtifactId());
        parameters.add(metadata.getGroupId());
        if (StringUtils.isNotBlank((String)metadata.getParentType())) {
            parameters.add(metadata.getParentType());
        } else {
            parameters.add(metadata.getType());
        }
        if (StringUtils.isNotBlank((String)metadata.getVersion())) {
            criteria.add("@maven.version = ?");
            parameters.add(metadata.getVersion());
        }
        if (StringUtils.isNotBlank((String)metadata.getClassifier())) {
            criteria.add("@maven.classifier = ?");
            parameters.add(metadata.getClassifier());
        } else {
            criteria.add("xp2:not(@maven.classifier)");
        }
        if (StringUtils.isNotBlank((String)metadata.getSnapshotId())) {
            criteria.add("@maven.snapshot.id = ?");
            parameters.add(metadata.getSnapshotId());
        } else {
            criteria.add("xp2:not(@maven.snapshot.id)");
        }
        ArtifactSet artifactSet = null;
        BaseArtifactType baseArtifact = null;
        try {
            artifactSet = this.query(criteria, parameters);
            if (artifactSet.size() >= 1L) {
                baseArtifact = (BaseArtifactType)artifactSet.iterator().next();
            }
        }
        catch (SrampAtomException e) {
            throw new MavenRepositoryException(Messages.i18n.format("", new Object[0]), (Exception)((Object)e));
        }
        finally {
            if (artifactSet != null) {
                artifactSet.close();
            }
        }
        if (baseArtifact != null) {
            InputStream artifactContent;
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            ArtifactType artifactType = ArtifactType.valueOf((BaseArtifactEnum)baseArtifact.getArtifactType());
            Date lastModifiedDate = null;
            if (baseArtifact.getLastModifiedTimestamp() != null) {
                lastModifiedDate = baseArtifact.getLastModifiedTimestamp().toGregorianCalendar().getTime();
            }
            int contentLength = -1;
            MavenFileExtensionEnum ext = MavenFileExtensionEnum.value((String)metadata.getType());
            if (ext != null && StringUtils.isNotBlank((String)ext.getCustomProperty())) {
                String content = SrampModelUtils.getCustomProperty((BaseArtifactType)baseArtifact, (String)ext.getCustomProperty());
                if (StringUtils.isNotBlank((String)content)) {
                    artifactContent = new ByteArrayInputStream(content.getBytes());
                    contentLength = content.length();
                    return new MavenArtifactWrapper(artifactContent, contentLength, lastModifiedDate, metadata.getFileName(), artifactType.getMimeType());
                }
                logger.info(Messages.i18n.format("maven.resource.get.subcontent.not.found", new Object[]{baseArtifact.getUuid(), ext.getCustomProperty()}));
                return null;
            }
            try {
                artifactContent = persistenceManager.getArtifactContent(baseArtifact.getUuid(), artifactType);
            }
            catch (SrampException e) {
                logger.error(Messages.i18n.format("maven.resource.get.content.error", new Object[]{baseArtifact.getUuid()}), (Throwable)e);
                throw new MavenRepositoryException(Messages.i18n.format("maven.resource.get.content.error", new Object[]{baseArtifact.getUuid()}), (Exception)((Object)e));
            }
            String contentSize = (String)baseArtifact.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_SIZE_QNAME);
            if (!StringUtils.isNotBlank((String)contentSize)) return new MavenArtifactWrapper(artifactContent, contentLength, lastModifiedDate, metadata.getFileName(), artifactType.getMimeType());
            contentLength = Integer.parseInt(contentSize);
            return new MavenArtifactWrapper(artifactContent, contentLength, lastModifiedDate, metadata.getFileName(), artifactType.getMimeType());
        }
        logger.error(Messages.i18n.format("maven.resource.item.null", new Object[]{metadata.toString()}));
        return null;
    }

    public Set<String> getItems(String path) throws MavenRepositoryException {
        int i;
        Set items = null;
        String[] tokens = path.split("/");
        StringBuilder groupId = new StringBuilder("");
        String version = "";
        String artifactId = "";
        for (i = 0; i < tokens.length; ++i) {
            if (i != 0) {
                groupId.append(MAVEN_FILE_EXTENSION_SEPARATOR);
            }
            groupId.append(tokens[i]);
        }
        items = this.getItems(groupId.toString(), null, null);
        if ((items == null || items.size() == 0) && tokens.length >= 2) {
            groupId = new StringBuilder("");
            version = "";
            artifactId = "";
            for (i = 0; i < tokens.length - 1; ++i) {
                if (i != 0) {
                    groupId.append(MAVEN_FILE_EXTENSION_SEPARATOR);
                }
                groupId.append(tokens[i]);
            }
            artifactId = tokens[tokens.length - 1];
            items = this.getItems(groupId.toString(), artifactId, null);
            if ((items == null || items.size() == 0) && tokens.length >= 3) {
                groupId = new StringBuilder("");
                version = "";
                artifactId = "";
                for (i = 0; i < tokens.length - 2; ++i) {
                    if (i != 0) {
                        groupId.append(MAVEN_FILE_EXTENSION_SEPARATOR);
                    }
                    groupId.append(tokens[i]);
                }
                artifactId = tokens[tokens.length - 2];
                version = tokens[tokens.length - 1];
                items = this.getItems(groupId.toString(), artifactId, version);
            }
        }
        return items;
    }

    private String generateName(BaseArtifactType artifact) {
        String artifactId = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.artifactId");
        String version = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.version");
        String snapshotId = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.snapshot.id");
        String classifier = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.classifier");
        String type = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.type");
        if (artifact.getName().contains(artifactId)) {
            StringBuilder name = new StringBuilder("");
            name.append(artifactId);
            if (version.contains("SNAPSHOT")) {
                if (StringUtils.isNotBlank((String)snapshotId)) {
                    name.append(MAVEN_SEPARATOR).append(version.substring(0, version.indexOf("SNAPSHOT"))).append(snapshotId);
                } else {
                    name.append(MAVEN_SEPARATOR).append(version);
                }
            } else {
                name.append(MAVEN_SEPARATOR).append(version);
            }
            if (classifier != null) {
                name.append(MAVEN_SEPARATOR).append(classifier);
            }
            name.append(MAVEN_FILE_EXTENSION_SEPARATOR).append(type);
            return name.toString();
        }
        return artifact.getName();
    }

    private Set<String> getItems(String groupId, String artifactId, String version) throws MavenRepositoryException {
        ArrayList<String> criteria = new ArrayList<String>();
        ArrayList<String> parameters = new ArrayList<String>();
        TreeSet<String> items = new TreeSet<String>();
        if (StringUtils.isNotBlank((String)groupId)) {
            criteria.add("fn:matches(@maven.groupId, ?)");
            parameters.add(groupId + ".*");
        } else {
            criteria.add("@maven.groupId");
        }
        if (StringUtils.isNotBlank((String)version)) {
            criteria.add("@maven.version= ?");
            parameters.add(version);
        }
        if (StringUtils.isNotBlank((String)artifactId)) {
            criteria.add("@maven.artifactId= ?");
            parameters.add(artifactId);
        }
        criteria.add("@derived='false'");
        ArtifactSet artifactSet = null;
        try {
            artifactSet = this.query(criteria, parameters);
            for (BaseArtifactType artifact : artifactSet) {
                String artifactGroupId = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.groupId");
                String artifactArtifactId = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.artifactId");
                if (StringUtils.isNotBlank((String)artifactId)) {
                    String toAdd = "";
                    if (StringUtils.isNotBlank((String)version)) {
                        String itemAdded;
                        toAdd = this.generateName(artifact);
                        items.add(toAdd);
                        String md5 = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.hash.md5");
                        String sha1 = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.hash.sha1");
                        if (StringUtils.isNotBlank((String)md5)) {
                            itemAdded = toAdd + ".md5";
                            items.add(itemAdded);
                        }
                        if (!StringUtils.isNotBlank((String)sha1)) continue;
                        itemAdded = toAdd + ".sha1";
                        items.add(itemAdded);
                        continue;
                    }
                    String artifactVersionId = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.version");
                    if (StringUtils.isNotBlank((String)artifactVersionId)) {
                        items.add(artifactVersionId);
                        continue;
                    }
                    items.add(artifact.getName());
                    continue;
                }
                String restGroupId = artifactGroupId.substring(artifactGroupId.indexOf(groupId) + groupId.length());
                if (restGroupId.startsWith(MAVEN_FILE_EXTENSION_SEPARATOR)) {
                    String removeBegin = restGroupId.substring(1);
                    if (removeBegin.contains(MAVEN_FILE_EXTENSION_SEPARATOR)) {
                        items.add(removeBegin.substring(0, removeBegin.indexOf(MAVEN_FILE_EXTENSION_SEPARATOR)) + "/");
                        continue;
                    }
                    items.add(removeBegin + "/");
                    continue;
                }
                if (restGroupId.contains(MAVEN_FILE_EXTENSION_SEPARATOR)) {
                    items.add(restGroupId.substring(0, restGroupId.indexOf(MAVEN_FILE_EXTENSION_SEPARATOR)) + "/");
                    continue;
                }
                if (restGroupId.trim().equals("")) {
                    items.add(artifactArtifactId + "/");
                    continue;
                }
                items.add(restGroupId);
            }
        }
        catch (SrampAtomException e) {
            throw new MavenRepositoryException(Messages.i18n.format("maven.resource.get.items.error", new Object[]{groupId, artifactId, version}), (Exception)((Object)e));
        }
        finally {
            if (artifactSet != null) {
                artifactSet.close();
            }
        }
        return items;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String uploadArtifact(MavenMetaData metadata, InputStream content) throws MavenRepositoryException {
        ArtifactType artifactType;
        String uuid = null;
        if (content == null) {
            throw new MavenRepositoryException(Messages.i18n.format("maven.resource.upload.no.content", new Object[0]));
        }
        String fileName = metadata.getFileName();
        PersistenceManager persistenceManager = PersistenceFactory.newInstance();
        ArrayList<String> criteria = new ArrayList<String>();
        ArrayList<String> parameters = new ArrayList<String>();
        criteria.add("@maven.artifactId = ?");
        criteria.add("@maven.groupId = ?");
        criteria.add("@maven.type = ?");
        parameters.add(metadata.getArtifactId());
        parameters.add(metadata.getGroupId());
        if (StringUtils.isNotBlank((String)metadata.getParentType())) {
            parameters.add(metadata.getParentType());
        } else {
            parameters.add(metadata.getType());
        }
        if (StringUtils.isNotBlank((String)metadata.getVersion())) {
            criteria.add("@maven.version = ?");
            parameters.add(metadata.getVersion());
        } else {
            criteria.add("xp2:not(@maven.version)");
        }
        if (StringUtils.isNotBlank((String)metadata.getParentFileName())) {
            criteria.add("@name = ?");
            parameters.add(metadata.getParentFileName());
        }
        if (StringUtils.isNotBlank((String)metadata.getSnapshotId())) {
            criteria.add("@maven.snapshot.id = ?");
            parameters.add(metadata.getSnapshotId());
        } else {
            criteria.add("xp2:not(@maven.snapshot.id)");
        }
        ArtifactSet artifactSet = null;
        BaseArtifactType baseArtifact = null;
        try {
            artifactSet = this.query(criteria, parameters);
            if (artifactSet.size() >= 1L) {
                baseArtifact = (BaseArtifactType)artifactSet.iterator().next();
            }
        }
        catch (SrampAtomException e) {
            throw new MavenRepositoryException(Messages.i18n.format("maven.resource.upload.sramp.query.error", new Object[]{metadata.toString()}), (Exception)((Object)e));
        }
        finally {
            if (artifactSet != null) {
                artifactSet.close();
            }
        }
        if (MavenFileExtensionEnum.value((String)metadata.getType()) != null) {
            if (baseArtifact == null) return uuid;
            boolean update = false;
            ArtifactType artifactType2 = ArtifactType.valueOf((BaseArtifactEnum)baseArtifact.getArtifactType());
            if (metadata.getType().equals(MavenFileExtensionEnum.HASH_MD5.getExtension()) || metadata.getType().equals(MavenFileExtensionEnum.HASH_SHA1.getExtension())) {
                String content_value = "";
                try {
                    content_value = IOUtils.toString((InputStream)content);
                }
                catch (IOException e1) {
                    throw new MavenRepositoryException(Messages.i18n.format("maven.resource.upload.sramp.error", new Object[]{metadata.toString()}), (Exception)e1);
                }
                if (!StringUtils.isNotBlank((String)content_value)) return uuid;
                if (metadata.getType().equals(MavenFileExtensionEnum.HASH_MD5.getExtension())) {
                    SrampModelUtils.setCustomProperty((BaseArtifactType)baseArtifact, (String)"maven.hash.md5", (String)content_value);
                    update = true;
                } else if (metadata.getType().equals(MavenFileExtensionEnum.HASH_SHA1.getExtension())) {
                    SrampModelUtils.setCustomProperty((BaseArtifactType)baseArtifact, (String)"maven.hash.sha1", (String)content_value);
                    update = true;
                }
                if (!update) return uuid;
                try {
                    persistenceManager.updateArtifact(baseArtifact, artifactType2);
                    return uuid;
                }
                catch (SrampException e) {
                    throw new MavenRepositoryException(Messages.i18n.format("maven.resource.upload.sramp.error", new Object[]{metadata.toString()}), (Exception)((Object)e));
                }
            }
            try {
                persistenceManager.updateArtifactContent(baseArtifact.getUuid(), artifactType2, content);
                return uuid;
            }
            catch (SrampException e) {
                throw new MavenRepositoryException(Messages.i18n.format("maven.resource.upload.sramp.error", new Object[]{metadata.toString()}), (Exception)((Object)e));
            }
        }
        BaseArtifactType persisted = null;
        if (baseArtifact != null) {
            if (!metadata.isSnapshotVersion() && !metadata.getFileName().equals("maven-metadata.xml")) throw new MavenRepositoryException(Messages.i18n.format("maven.resource.upload.sramp.release.artifact.exist", new Object[]{metadata.getFullName()}));
            artifactType = ArtifactType.valueOf((BaseArtifactType)baseArtifact);
            try {
                persistenceManager.updateArtifactContent(baseArtifact.getUuid(), artifactType, content);
            }
            catch (SrampException e) {
                throw new MavenRepositoryException(Messages.i18n.format("maven.resource.upload.sramp.update.content.error", new Object[]{baseArtifact.getUuid()}), (Exception)((Object)e));
            }
            persisted = baseArtifact;
        } else {
            artifactType = this.determineArtifactType(fileName);
            BaseArtifactType baseArtifactType = artifactType.newArtifactInstance();
            try {
                persisted = persistenceManager.persistArtifact(baseArtifactType, content);
            }
            catch (SrampException e1) {
                throw new MavenRepositoryException(Messages.i18n.format("maven.resource.upload.sramp.new.content.error", new Object[0]), (Exception)((Object)e1));
            }
        }
        SrampModelUtils.setCustomProperty((BaseArtifactType)persisted, (String)"maven.groupId", (String)metadata.getGroupId());
        SrampModelUtils.setCustomProperty((BaseArtifactType)persisted, (String)"maven.artifactId", (String)metadata.getArtifactId());
        SrampModelUtils.setCustomProperty((BaseArtifactType)persisted, (String)"maven.version", (String)metadata.getVersion());
        if (StringUtils.isNotBlank((String)metadata.getClassifier())) {
            SrampModelUtils.setCustomProperty((BaseArtifactType)persisted, (String)"maven.classifier", (String)metadata.getClassifier());
        }
        if (StringUtils.isNotBlank((String)metadata.getType())) {
            SrampModelUtils.setCustomProperty((BaseArtifactType)persisted, (String)"maven.type", (String)metadata.getType());
        }
        if (StringUtils.isNotBlank((String)metadata.getSnapshotId())) {
            SrampModelUtils.setCustomProperty((BaseArtifactType)persisted, (String)"maven.snapshot.id", (String)metadata.getSnapshotId());
        }
        try {
            persisted.getOtherAttributes().put(SrampConstants.SRAMP_CONTENT_SIZE_QNAME, content.available() + "");
        }
        catch (IOException e) {
            logger.error("");
        }
        persisted.setName(metadata.getFileName());
        artifactType = ArtifactType.valueOf((BaseArtifactType)persisted);
        try {
            persistenceManager.updateArtifact(persisted, artifactType);
            return persisted.getUuid();
        }
        catch (SrampException e) {
            throw new MavenRepositoryException(Messages.i18n.format("maven.resource.upload.sramp.update.content.metadata.error", new Object[]{persisted.getUuid()}), (Exception)((Object)e));
        }
    }

    private ArtifactType determineArtifactType(String fileName) {
        ArtifactType type = null;
        String extension = FilenameUtils.getExtension((String)fileName);
        type = "jar".equals(extension) ? ArtifactType.ExtendedDocument((String)"JavaArchive") : ("war".equals(extension) ? ArtifactType.ExtendedDocument((String)"JavaWebApplication") : ("ear".equals(extension) ? ArtifactType.ExtendedDocument((String)"JavaEnterpriseApplication") : ("pom".equals(extension) ? ArtifactType.ExtendedDocument((String)"MavenPom") : ArtifactType.Document())));
        return type;
    }
}

