/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.mvn.services;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.StringUtils;
import org.overlord.sramp.repository.QueryManager;
import org.overlord.sramp.repository.QueryManagerFactory;
import org.overlord.sramp.repository.query.ArtifactSet;
import org.overlord.sramp.repository.query.SrampQuery;
import org.overlord.sramp.server.i18n.Messages;
import org.overlord.sramp.server.mvn.services.MavenFileExtensionEnum;
import org.overlord.sramp.server.mvn.services.MavenMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenMetaDataBuilder {
    private static Logger logger = LoggerFactory.getLogger(MavenMetaDataBuilder.class);

    public static MavenMetaData build(String url) {
        String without_ext;
        String[] tokens;
        String groupId = "";
        String artifactId = "";
        String version = "";
        String type = "";
        String classifier = "";
        String parentType = "";
        String fileName = "";
        String snapshotId = "";
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        int lastPathSegmentIdx = url.lastIndexOf(47);
        String lastPathSegment = null;
        if (lastPathSegmentIdx != -1) {
            lastPathSegment = url.substring(lastPathSegmentIdx + 1);
        }
        if (lastPathSegment != null && lastPathSegment.indexOf(46) != -1 && (tokens = url.split("/")) != null && tokens.length > 0 && tokens.length >= 3) {
            if (lastPathSegment.contains("maven-metadata.xml")) {
                int i;
                String possibleGroupId = "";
                boolean isGroup = false;
                for (int i2 = 0; i2 < tokens.length - 2; ++i2) {
                    possibleGroupId = possibleGroupId + tokens[i2];
                    if (i2 >= tokens.length - 1) continue;
                    possibleGroupId = possibleGroupId + ".";
                }
                int iterations = StringUtils.countMatches((String)possibleGroupId, (String)".") + 1;
                for (i = 0; i < iterations; ++i) {
                    if (MavenMetaDataBuilder.isGroupId(possibleGroupId)) {
                        isGroup = true;
                        break;
                    }
                    if (possibleGroupId.lastIndexOf(".") == -1) continue;
                    possibleGroupId = possibleGroupId.substring(0, possibleGroupId.lastIndexOf("."));
                }
                if (isGroup) {
                    groupId = possibleGroupId;
                    String lastGroupIdToken = "";
                    lastGroupIdToken = groupId.contains(".") ? groupId.substring(groupId.lastIndexOf(".") + 1) : groupId;
                    int groupIdIndex = 0;
                    for (groupIdIndex = 0; groupIdIndex < tokens.length && !tokens[groupIdIndex].equals(lastGroupIdToken); ++groupIdIndex) {
                    }
                    if (tokens.length == groupIdIndex + 3) {
                        artifactId = tokens[groupIdIndex + 1];
                        if (!MavenMetaDataBuilder.existVersion(groupId, tokens[groupIdIndex + 2])) {
                            fileName = tokens[groupIdIndex + 2];
                        }
                    } else if (tokens.length == groupIdIndex + 4) {
                        artifactId = tokens[groupIdIndex + 1];
                        version = tokens[groupIdIndex + 2];
                        fileName = tokens[groupIdIndex + 3];
                    }
                } else {
                    version = tokens[tokens.length - 2];
                    for (i = 0; i < tokens.length - 2; ++i) {
                        if (i < tokens.length - 3) {
                            if (i != 0) {
                                groupId = groupId + ".";
                            }
                            groupId = groupId + tokens[i];
                            continue;
                        }
                        artifactId = tokens[i];
                    }
                    fileName = tokens[tokens.length - 1];
                }
            } else {
                version = tokens[tokens.length - 2];
                for (int i = 0; i < tokens.length - 2; ++i) {
                    if (i < tokens.length - 3) {
                        if (i != 0) {
                            groupId = groupId + ".";
                        }
                        groupId = groupId + tokens[i];
                        continue;
                    }
                    artifactId = tokens[i];
                }
                fileName = tokens[tokens.length - 1];
            }
            if (StringUtils.isNotBlank((String)fileName)) {
                type = fileName.substring(fileName.lastIndexOf(".") + 1);
                classifier = "";
                if (StringUtils.isNotBlank((String)version)) {
                    int versionLen;
                    int versionIdx;
                    int classifierIdx;
                    String without_extension;
                    String versionParsed = "";
                    versionParsed = version.contains("-SNAPSHOT") ? version.substring(0, version.lastIndexOf("-SNAPSHOT")) : version;
                    if (fileName.startsWith(artifactId + "-" + versionParsed) && StringUtils.countMatches((String)(without_extension = fileName.substring(0, fileName.lastIndexOf("."))), (String)"-") >= 2 && (classifierIdx = (versionIdx = without_extension.indexOf(versionParsed)) + (versionLen = versionParsed.length())) < without_extension.length()) {
                        if (version.contains("SNAPSHOT") && !version.equals(versionParsed)) {
                            String rest = without_extension.substring(classifierIdx + 1);
                            String[] tokens_file_name = rest.split("-");
                            if (tokens_file_name.length > 0) {
                                if (MavenMetaDataBuilder.isMavenTimeStamp(tokens_file_name[0])) {
                                    if (tokens_file_name.length > 1) {
                                        try {
                                            String[] counter = StringUtils.split((String)tokens_file_name[1], (String)".");
                                            Integer.parseInt(counter[0]);
                                            snapshotId = tokens_file_name[0] + "-" + counter[0];
                                            if (tokens_file_name.length > 2) {
                                                classifier = tokens_file_name[2];
                                            } else if (counter.length == 2) {
                                                parentType = counter[1];
                                            }
                                        }
                                        catch (NumberFormatException nfe) {
                                            classifier = rest.substring(tokens_file_name[0].length() + 1);
                                        }
                                    }
                                } else {
                                    classifier = rest;
                                }
                            }
                        } else {
                            classifier = without_extension.substring(classifierIdx);
                        }
                        if (StringUtils.isNotBlank((String)classifier) && classifier.contains(".")) {
                            if (classifier.startsWith(".")) {
                                parentType = classifier.substring(1);
                                classifier = "";
                            } else {
                                parentType = classifier.substring(classifier.lastIndexOf(".") + 1);
                                classifier = classifier.substring(0, classifier.lastIndexOf("."));
                            }
                        }
                    }
                }
            }
        }
        if (MavenFileExtensionEnum.value(type) != null && (without_ext = fileName.substring(0, fileName.lastIndexOf("." + type))).contains(".")) {
            parentType = without_ext.substring(without_ext.lastIndexOf(".") + 1);
        }
        return new MavenMetaData(groupId, artifactId, version, type, classifier, snapshotId, parentType, fileName);
    }

    private static boolean isGroupId(String groupId) {
        String query = "/s-ramp[@maven.groupId = ?]";
        try {
            QueryManager queryManager = QueryManagerFactory.newInstance();
            SrampQuery srampQuery = queryManager.createQuery(query);
            srampQuery.setString(groupId);
            ArtifactSet artifactSet = srampQuery.executeQuery();
            if (artifactSet.size() > 0L) {
                return true;
            }
        }
        catch (Throwable e) {
            logger.error(Messages.i18n.format("maven.resource.query.error", new Object[]{query}), e);
        }
        return false;
    }

    private static boolean existVersion(String groupId, String version) {
        String query = "/s-ramp[@maven.groupId = ? and @maven.version = ? ]";
        try {
            QueryManager queryManager = QueryManagerFactory.newInstance();
            SrampQuery srampQuery = queryManager.createQuery(query);
            srampQuery.setString(groupId);
            srampQuery.setString(version);
            ArtifactSet artifactSet = srampQuery.executeQuery();
            if (artifactSet.size() > 0L) {
                return true;
            }
        }
        catch (Throwable e) {
            logger.error(Messages.i18n.format("maven.resource.query.error", new Object[]{query}), e);
        }
        return false;
    }

    private static boolean isMavenTimeStamp(String possibleTimestamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd.HHmmss");
        try {
            sdf.parse(possibleTimestamp);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }
}

