/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell;

import java.util.List;
import javax.xml.namespace.QName;
import jline.console.completer.Completer;
import org.overlord.sramp.shell.ShellCommandFactory;
import org.overlord.sramp.shell.api.Arguments;
import org.overlord.sramp.shell.api.ShellCommand;
import org.overlord.sramp.shell.api.ShellContext;

public class TabCompleter
implements Completer {
    private ShellCommandFactory factory;
    private ShellContext context;

    public TabCompleter(ShellCommandFactory factory, ShellContext context) {
        this.factory = factory;
        this.context = context;
    }

    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        if (buffer.trim().length() == 0) {
            for (String ns : this.factory.getNamespaces()) {
                candidates.add(ns + ":");
            }
            return cursor;
        }
        if (!buffer.contains(":") && !buffer.contains(" ")) {
            for (String ns : this.factory.getNamespaces()) {
                if (!ns.startsWith(buffer)) continue;
                candidates.add(ns + ":");
            }
            if (candidates.isEmpty()) {
                for (QName cmdName : this.factory.getCommandNames("s-ramp")) {
                    if (!cmdName.getLocalPart().startsWith(buffer)) continue;
                    candidates.add("s-ramp:" + cmdName.getLocalPart() + " ");
                }
            }
            return 0;
        }
        if (buffer.endsWith(":") && !buffer.contains(" ")) {
            String ns = buffer.substring(0, buffer.length() - 1);
            for (QName cmdName : this.factory.getCommandNames(ns)) {
                candidates.add(cmdName.getLocalPart() + " ");
            }
            return cursor;
        }
        if (buffer.contains(":") && !buffer.endsWith(":") && !buffer.contains(" ")) {
            int colonIdx = buffer.indexOf(58);
            String ns = buffer.substring(0, colonIdx);
            String name = buffer.substring(colonIdx + 1);
            for (QName cmdName : this.factory.getCommandNames(ns)) {
                if (!cmdName.getLocalPart().startsWith(name)) continue;
                candidates.add(cmdName.getLocalPart() + " ");
            }
            return colonIdx + 1;
        }
        String args = buffer.substring(0, cursor);
        Arguments arguments = new Arguments(args);
        QName commandName = arguments.removeCommandName();
        String lastArgument = null;
        if (arguments.size() > 0 && !args.endsWith(" ")) {
            lastArgument = (String)arguments.remove(arguments.size() - 1);
        }
        try {
            ShellCommand command = this.factory.createCommand(commandName);
            if (command != null) {
                command.setContext(this.context);
                command.setArguments(arguments);
                int rval = command.tabCompletion(lastArgument, candidates);
                if (!candidates.isEmpty()) {
                    int curs = args.length() - (lastArgument == null ? 0 : lastArgument.length());
                    return curs + rval;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return cursor;
    }
}

