/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.core;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.overlord.sramp.shell.api.AbstractShellCommand;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;

public class ClassificationCommand
extends AbstractShellCommand {
    private static final Set<String> subcommands = new HashSet<String>();

    public ClassificationCommand() {
        subcommands.add("add");
        subcommands.add("remove");
        subcommands.add("clear");
    }

    public void printUsage() {
        this.print("s-ramp:classification <subCommand> <subCommandArguments>", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'classification' command manipulates the classifications of the", new Object[0]);
        this.print("currently active S-RAMP artifact.  The artifact must first be in the", new Object[0]);
        this.print("current session through the s-ramp:getMetaData command.  This command", new Object[0]);
        this.print("adds or removes classifications on that active artifact.", new Object[0]);
        this.print("", new Object[0]);
        this.print("Supported sub-commands:  add, remove, clear", new Object[0]);
        this.print("", new Object[0]);
        this.print("Example usage:", new Object[0]);
        this.print(">  s-ramp:classification add http://www.example.org/regions.owl#China", new Object[0]);
        this.print(">  s-ramp:classification remove http://www.example.org/regions.owl#China", new Object[0]);
        this.print(">  s-ramp:classification clear", new Object[0]);
    }

    public void execute() throws Exception {
        block12: {
            String subcmdArg = this.requiredArgument(0, "Please specify a sub-command (add, remove, clear).");
            String classificationArg = null;
            if ("add".equals(subcmdArg) || "remove".equals(subcmdArg)) {
                classificationArg = this.requiredArgument(1, "Please specify a classification URI.");
            }
            QName artifactVarName = new QName("s-ramp", "artifact");
            BaseArtifactType artifact = (BaseArtifactType)this.getContext().getVariable(artifactVarName);
            if (artifact == null) {
                this.print("No active S-RAMP artifact exists.  Use s-ramp:getMetaData.", new Object[0]);
                return;
            }
            try {
                if ("add".equals(subcmdArg)) {
                    artifact.getClassifiedBy().add(classificationArg);
                    this.print("Successfully added classification '%1$s'.", new Object[]{classificationArg});
                    break block12;
                }
                if ("remove".equals(subcmdArg)) {
                    if (artifact.getClassifiedBy().remove(classificationArg)) {
                        this.print("Successfully removed classification '%1$s'.", new Object[]{classificationArg});
                    } else {
                        this.print("Classification '%1$s' does not exist on the active artifact.", new Object[]{classificationArg});
                    }
                    break block12;
                }
                if ("clear".equals(subcmdArg)) {
                    if (!artifact.getClassifiedBy().isEmpty()) {
                        artifact.getClassifiedBy().clear();
                        this.print("Successfully removed all classifications.", new Object[0]);
                    } else {
                        this.print("No classifications exist on the active artifact.", new Object[0]);
                    }
                    break block12;
                }
                throw new InvalidCommandArgumentException(0, "Invalid sub-command, must be one of ['add', 'remove', 'clear'].");
            }
            catch (InvalidCommandArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                this.print("FAILED to modify the artifact's classifications.", new Object[0]);
                this.print("\t" + e.getMessage(), new Object[0]);
            }
        }
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        BaseArtifactType artifact;
        QName artifactVarName = new QName("s-ramp", "artifact");
        if (this.getArguments().isEmpty()) {
            for (String subcmd : subcommands) {
                if (lastArgument != null && !subcmd.startsWith(lastArgument)) continue;
                candidates.add(subcmd + " ");
            }
            return 0;
        }
        if (this.getArguments().size() == 1 && this.getArguments().contains((Object)"remove") && (artifact = (BaseArtifactType)this.getContext().getVariable(artifactVarName)) != null) {
            TreeSet classifications = new TreeSet();
            classifications.addAll(artifact.getClassifiedBy());
            for (String classification : classifications) {
                if (lastArgument != null && !classification.startsWith(lastArgument)) continue;
                candidates.add(classification);
            }
            return 0;
        }
        return -1;
    }
}

