/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.shell.api.AbstractShellCommand;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;
import org.overlord.sramp.shell.util.FileNameCompleter;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;

public class GetContentCommand
extends AbstractShellCommand {
    public void printUsage() {
        this.print("s-ramp:getContent <artifactId> <outputFilePath>", new Object[0]);
        this.print("\tValid formats for artifactId:", new Object[0]);
        this.print("\t  feed:<feedIndex> - an index into the most recent feed", new Object[0]);
        this.print("\t  uuid:<srampUUID> - the UUID of an s-ramp artifact", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'getContent' command downloads the file content for", new Object[0]);
        this.print("a single artifact from the S-RAMP repository.  The artifact", new Object[0]);
        this.print("can be identified either by its unique S-RAMP uuid or else", new Object[0]);
        this.print("by an index into the most recent Feed.", new Object[0]);
        this.print("", new Object[0]);
        this.print("Note: a Feed can be obtained, for example, by using the ", new Object[0]);
        this.print("s-ramp:query command.", new Object[0]);
        this.print("", new Object[0]);
        this.print("Example usage:", new Object[0]);
        this.print(">  s-ramp:query /s-ramp/wsdl/WsdlDocument", new Object[0]);
        this.print(">  s-ramp:getContent feed:1 /home/user/files/", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        int feedIdx;
        QueryResultSet rset;
        String artifactIdArg = this.requiredArgument(0, "Please specify a valid artifact identifier.");
        String outputFilePathArg = this.requiredArgument(1, "Please specify an output path (file or directory).");
        if (!artifactIdArg.contains(":")) {
            throw new InvalidCommandArgumentException(0, "Invalid artifact id format.");
        }
        QName clientVarName = new QName("s-ramp", "client");
        QName feedVarName = new QName("s-ramp", "feed");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print("No S-RAMP repository connection is currently open.", new Object[0]);
            return;
        }
        BaseArtifactType artifact = null;
        String idType = artifactIdArg.substring(0, artifactIdArg.indexOf(58));
        if ("feed".equals(idType)) {
            rset = (QueryResultSet)this.getContext().getVariable(feedVarName);
            feedIdx = Integer.parseInt(artifactIdArg.substring(artifactIdArg.indexOf(58) + 1)) - 1;
            if (feedIdx < 0 || (long)feedIdx >= rset.size()) {
                throw new InvalidCommandArgumentException(0, "Feed index out of range.");
            }
        } else {
            if ("uuid".equals(idType)) {
                throw new InvalidCommandArgumentException(0, "uuid: style artifact identifiers not yet implemented.");
            }
            throw new InvalidCommandArgumentException(0, "Invalid artifact id format.");
        }
        ArtifactSummary summary = rset.get(feedIdx);
        String artifactUUID = summary.getUuid();
        artifact = client.getArtifactMetaData(summary.getType(), artifactUUID);
        File outFile = new File(outputFilePathArg);
        if (outFile.isFile()) {
            throw new InvalidCommandArgumentException(1, "Output file already exists: " + outFile.getCanonicalPath());
        }
        if (outFile.isDirectory()) {
            String fileName = artifact.getName();
            outFile = new File(outFile, fileName);
        }
        outFile.getParentFile().mkdirs();
        InputStream artifactContent = null;
        FileOutputStream outputStream = null;
        try {
            artifactContent = client.getArtifactContent(ArtifactType.valueOf((BaseArtifactType)artifact), artifact.getUuid());
            outputStream = new FileOutputStream(outFile);
            IOUtils.copy((InputStream)artifactContent, (OutputStream)outputStream);
            this.print("Artifact content saved to " + outFile.getCanonicalPath(), new Object[0]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(artifactContent);
            IOUtils.closeQuietly(outputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)artifactContent);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (this.getArguments().isEmpty() && (lastArgument == null || "feed:".startsWith(lastArgument))) {
            QName feedVarName = new QName("s-ramp", "feed");
            QueryResultSet rset = (QueryResultSet)this.getContext().getVariable(feedVarName);
            if (rset != null) {
                int idx = 0;
                while ((long)idx < rset.size()) {
                    String candidate = "feed:" + (idx + 1);
                    if (lastArgument == null) {
                        candidates.add(candidate);
                    }
                    if (lastArgument != null && candidate.startsWith(lastArgument)) {
                        candidates.add(candidate);
                    }
                    ++idx;
                }
            }
            return 0;
        }
        if (this.getArguments().size() == 1) {
            if (lastArgument == null) {
                lastArgument = "";
            }
            FileNameCompleter delegate = new FileNameCompleter();
            return delegate.complete(lastArgument, lastArgument.length(), candidates);
        }
        return -1;
    }
}

