/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.namespace.QName;
import org.overlord.sramp.shell.ShellCommandFactory;
import org.overlord.sramp.shell.ShellCommandReader;
import org.overlord.sramp.shell.api.Arguments;
import org.overlord.sramp.shell.api.ShellCommand;
import org.overlord.sramp.shell.api.ShellContext;
import org.overlord.sramp.shell.commands.NoOpCommand;

public abstract class AbstractShellCommandReader
implements ShellCommandReader {
    private ShellContext context;
    private ShellCommandFactory factory;

    public AbstractShellCommandReader(ShellCommandFactory factory, ShellContext context) {
        this.factory = factory;
        this.context = context;
    }

    @Override
    public abstract void open() throws IOException;

    @Override
    public final ShellCommand read() throws Exception {
        String line = this.readLine();
        if (line == null) {
            return null;
        }
        Arguments arguments = new Arguments(line);
        if (arguments.isEmpty()) {
            return new NoOpCommand();
        }
        QName commandName = arguments.removeCommandName();
        ShellCommand command = this.factory.createCommand(commandName);
        command.setContext(this.context);
        command.setArguments(arguments);
        command.setOutput(this.getCommandOutput());
        return command;
    }

    protected Writer getCommandOutput() {
        return new OutputStreamWriter(System.out);
    }

    protected abstract String readLine() throws IOException;

    @Override
    public void close() throws IOException {
    }

    public ShellCommandFactory getFactory() {
        return this.factory;
    }

    public ShellContext getContext() {
        return this.context;
    }
}

