/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.shell.api.AbstractShellCommand;

public class AddEntryArchiveCommand
extends AbstractShellCommand {
    public void printUsage() {
        this.print("archive:addEntry <archivePath> <srampArtifactType> [<pathToFileContent>]", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'addEntry' command provides a way to add a single entry to the ", new Object[0]);
        this.print("currently open S-RAMP batch archive.  The command requires a path", new Object[0]);
        this.print("within the archive to be specified.  In addition, the type of ", new Object[0]);
        this.print("artifact must be included along with an optional path to a file", new Object[0]);
        this.print("representing the content.", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws Exception {
        String archivePathArg = this.requiredArgument(0, "Please include an entry path (relative archive path).");
        String artifactTypeArg = this.requiredArgument(1, "Please include an entry path (relative archive path).");
        String pathToContent = this.optionalArgument(2);
        QName varName = new QName("archive", "active-archive");
        SrampArchive archive = (SrampArchive)this.getContext().getVariable(varName);
        if (archive == null) {
            this.print("No S-RAMP archive is currently open.", new Object[0]);
            return;
        }
        FileInputStream contentStream = null;
        try {
            ArtifactType type = ArtifactType.valueOf((String)artifactTypeArg);
            String name = new File(archivePathArg).getName();
            if (pathToContent != null) {
                File contentFile = new File(pathToContent);
                contentStream = FileUtils.openInputStream((File)contentFile);
            }
            BaseArtifactType artifact = type.newArtifactInstance();
            artifact.setName(name);
            archive.addEntry(archivePathArg, artifact, (InputStream)contentStream);
            this.print("Entry added to S-RAMP archive:  " + archivePathArg, new Object[0]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(contentStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)contentStream);
    }
}

