/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.overlord.sramp.shell.AbstractShellCommandReader;
import org.overlord.sramp.shell.ShellCommandFactory;
import org.overlord.sramp.shell.ShellContextImpl;

public class StdInShellCommandReader
extends AbstractShellCommandReader {
    private BufferedReader stdinReader;

    public StdInShellCommandReader(ShellCommandFactory factory, ShellContextImpl context) {
        super(factory, context);
    }

    @Override
    public void open() throws IOException {
        this.stdinReader = new BufferedReader(new InputStreamReader(System.in));
    }

    @Override
    protected String readLine() throws IOException {
        if (!this.stdinReader.ready()) {
            System.out.print("sramp> ");
        }
        return this.stdinReader.readLine();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public String promptForInput(String prompt) {
        try {
            if (!this.stdinReader.ready()) {
                System.out.print(prompt);
            }
            return this.stdinReader.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String promptForPassword(String prompt) {
        return this.promptForInput(prompt);
    }
}

