/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.archive;

import java.io.File;
import java.util.List;
import javax.xml.namespace.QName;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.shell.AbstractShellContextVariableLifecycleHandler;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.api.ShellContextVariableLifecycleHandler;
import org.overlord.sramp.shell.i18n.Messages;
import org.overlord.sramp.shell.util.FileNameCompleter;

public class OpenArchiveCommand
extends BuiltInShellCommand {
    public boolean execute() throws Exception {
        String pathToArchive = this.requiredArgument(0, Messages.i18n.format("OpenArchive.InvalidArgMsg.PathToArchive", new Object[0]));
        SrampArchive archive = null;
        QName varName = new QName("archive", "active-archive");
        archive = (SrampArchive)this.getContext().getVariable(varName);
        if (archive != null) {
            this.print(Messages.i18n.format("OpenArchive.AlreadyOpen", new Object[0]), new Object[0]);
            return false;
        }
        File archiveFile = new File(pathToArchive);
        archive = new SrampArchive(archiveFile);
        this.getContext().setVariable(varName, (Object)archive, (ShellContextVariableLifecycleHandler)new AbstractShellContextVariableLifecycleHandler(){

            @Override
            public void onRemove(Object object) {
                SrampArchive.closeQuietly((SrampArchive)((SrampArchive)object));
            }

            @Override
            public void onContextDestroyed(Object object) {
                SrampArchive.closeQuietly((SrampArchive)((SrampArchive)object));
            }
        });
        this.print(Messages.i18n.format("OpenArchive.Opened", new Object[]{archiveFile.getCanonicalPath()}), new Object[0]);
        return true;
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (this.getArguments().isEmpty()) {
            if (lastArgument == null) {
                lastArgument = "";
            }
            FileNameCompleter delegate = new FileNameCompleter();
            return delegate.complete(lastArgument, lastArgument.length(), candidates);
        }
        return -1;
    }
}

