/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.ontology;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.ontology.OntologySummary;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;
import org.overlord.sramp.shell.i18n.Messages;
import org.overlord.sramp.shell.util.FileNameCompleter;

public class UpdateOntologyCommand
extends BuiltInShellCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws Exception {
        String ontologyIdArg = this.requiredArgument(0, Messages.i18n.format("UpdateOntology.InvalidArgMsg.OntologyId", new Object[0]));
        String filePathArg = this.requiredArgument(1, Messages.i18n.format("UpdateOntology.InvalidArgMsg.MissingPath", new Object[0]));
        QName feedVarName = new QName("ontology", "feed");
        QName clientVarName = new QName("s-ramp", "client");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print(Messages.i18n.format("MissingSRAMPConnection", new Object[0]), new Object[0]);
            return false;
        }
        if (!ontologyIdArg.contains(":") || ontologyIdArg.endsWith(":")) {
            throw new InvalidCommandArgumentException(0, Messages.i18n.format("InvalidOntologyIdFormat", new Object[0]));
        }
        String ontologyUuid = null;
        int colonIdx = ontologyIdArg.indexOf(58);
        String idType = ontologyIdArg.substring(0, colonIdx);
        String idValue = ontologyIdArg.substring(colonIdx + 1);
        if ("feed".equals(idType)) {
            List ontologies = (List)this.getContext().getVariable(feedVarName);
            if (ontologies == null) {
                throw new InvalidCommandArgumentException(0, Messages.i18n.format("DeleteOntology.NoOntologyFeed", new Object[0]));
            }
            int feedIdx = Integer.parseInt(idValue) - 1;
            if (feedIdx < 0 || feedIdx >= ontologies.size()) {
                throw new InvalidCommandArgumentException(0, Messages.i18n.format("FeedIndexOutOfRange", new Object[0]));
            }
            OntologySummary summary = (OntologySummary)ontologies.get(feedIdx);
            ontologyUuid = summary.getUuid();
        } else if ("uuid".equals(idType)) {
            ontologyUuid = idValue;
        } else {
            throw new InvalidCommandArgumentException(0, Messages.i18n.format("InvalidIdFormat", new Object[0]));
        }
        InputStream content = null;
        try {
            File file = new File(filePathArg);
            if (file.exists()) {
                content = FileUtils.openInputStream((File)file);
            } else {
                URL url = ((Object)((Object)this)).getClass().getResource(filePathArg);
                if (url != null) {
                    this.print(Messages.i18n.format("UpdateOntology.ReadingOntology", new Object[]{url.toExternalForm()}), new Object[0]);
                    content = url.openStream();
                } else {
                    this.print(Messages.i18n.format("UpdateOntology.CannotFind", new Object[]{filePathArg}), new Object[0]);
                }
            }
            client.updateOntology(ontologyUuid, content);
            this.print(Messages.i18n.format("UpdateOntology.SuccessfulUpdate", new Object[0]), new Object[0]);
        }
        catch (Exception e) {
            boolean bl;
            try {
                this.print(Messages.i18n.format("UpdateOntology.UpdateFailed", new Object[0]), new Object[0]);
                this.print("\t" + e.getMessage(), new Object[0]);
                IOUtils.closeQuietly((InputStream)content);
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(content);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)content);
            return bl;
        }
        IOUtils.closeQuietly((InputStream)content);
        return true;
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (this.getArguments().isEmpty() && (lastArgument == null || "feed:".startsWith(lastArgument))) {
            QName feedVarName = new QName("ontology", "feed");
            List ontologies = (List)this.getContext().getVariable(feedVarName);
            if (ontologies != null) {
                for (int idx = 0; idx < ontologies.size(); ++idx) {
                    String candidate = "feed:" + (idx + 1);
                    if (lastArgument == null) {
                        candidates.add(candidate);
                    }
                    if (lastArgument == null || !candidate.startsWith(lastArgument)) continue;
                    candidates.add(candidate);
                }
            }
            return 0;
        }
        if (this.getArguments().size() == 1) {
            if (lastArgument == null) {
                lastArgument = "";
            }
            FileNameCompleter delegate = new FileNameCompleter();
            return delegate.complete(lastArgument, lastArgument.length(), candidates);
        }
        return -1;
    }
}

