/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.ontology;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.api.Arguments;
import org.overlord.sramp.shell.api.ShellContext;
import org.overlord.sramp.shell.api.SimpleShellContext;
import org.overlord.sramp.shell.i18n.Messages;
import org.overlord.sramp.shell.util.FileNameCompleter;

public class UploadOntologyCommand
extends BuiltInShellCommand {
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            throw new Exception("Usage: " + UploadOntologyCommand.class + " [-file | -resource] [<filePath> | <resourcePath>]");
        }
        String type = args[0];
        String path = args[1];
        StringBuilder argLine = new StringBuilder();
        boolean isResource = "-resource".equals(type);
        if (isResource) {
            URL url = UploadOntologyCommand.class.getResource(path);
            if (url == null) {
                throw new Exception("Could not find " + path + " on the classpath");
            }
            argLine.append(url.toExternalForm());
        } else {
            File file = new File(path);
            if (!file.isFile()) {
                throw new FileNotFoundException(path);
            }
            argLine.append(file.getCanonicalPath());
        }
        SrampAtomApiClient client = new SrampAtomApiClient("http://localhost:8080/s-ramp-server");
        QName clientVarName = new QName("s-ramp", "client");
        SimpleShellContext context = new SimpleShellContext();
        context.setVariable(clientVarName, (Object)client);
        UploadOntologyCommand cmd = new UploadOntologyCommand();
        cmd.setArguments(new Arguments(argLine.toString()));
        cmd.setContext((ShellContext)context);
        cmd.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws Exception {
        String filePathArg = this.requiredArgument(0, Messages.i18n.format("UploadOntology.InvalidArgMsg.MissingPath", new Object[0]));
        QName clientVarName = new QName("s-ramp", "client");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print(Messages.i18n.format("MissingSRAMPConnection", new Object[0]), new Object[0]);
            return false;
        }
        InputStream content = null;
        try {
            File file = new File(filePathArg);
            if (file.exists()) {
                content = FileUtils.openInputStream((File)file);
            } else {
                URL url = ((Object)((Object)this)).getClass().getResource(filePathArg);
                if (url != null) {
                    this.print(Messages.i18n.format("UploadOntology.ReadingOntology", new Object[]{url.toExternalForm()}), new Object[0]);
                    content = url.openStream();
                } else {
                    this.print(Messages.i18n.format("UploadOntology.CannotFind", new Object[]{filePathArg}), new Object[0]);
                }
            }
            client.uploadOntology(content);
            this.print(Messages.i18n.format("UploadOntology.SuccessfulUpload", new Object[0]), new Object[0]);
        }
        catch (Exception e) {
            boolean bl;
            try {
                this.print(Messages.i18n.format("UploadOntology.UploadFailed", new Object[0]), new Object[0]);
                this.print("\t" + e.getMessage(), new Object[0]);
                IOUtils.closeQuietly((InputStream)content);
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(content);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)content);
            return bl;
        }
        IOUtils.closeQuietly((InputStream)content);
        this.print("**********************************************************************", new Object[0]);
        return true;
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (lastArgument == null) {
            lastArgument = "";
        }
        if (this.getArguments().isEmpty()) {
            FileNameCompleter delegate = new FileNameCompleter();
            return delegate.complete(lastArgument, lastArgument.length(), candidates);
        }
        return -1;
    }
}

