/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.ontology;

import java.io.File;
import java.io.OutputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.ontology.OntologySummary;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;
import org.overlord.sramp.shell.commands.ontology.FeedTabCompleter;
import org.overlord.sramp.shell.i18n.Messages;
import org.overlord.sramp.shell.util.FileNameCompleter;
import org.w3._1999._02._22_rdf_syntax_ns_.RDF;

public class GetOntologyCommand
extends BuiltInShellCommand {
    public boolean execute() throws Exception {
        String ontologyIdArg = this.requiredArgument(0, Messages.i18n.format("GetOntology.InvalidArgMsg.OntologyId", new Object[0]));
        String filePathArg = this.optionalArgument(1);
        QName feedVarName = new QName("ontology", "feed");
        QName clientVarName = new QName("s-ramp", "client");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print(Messages.i18n.format("MissingSRAMPConnection", new Object[0]), new Object[0]);
            return false;
        }
        if (!ontologyIdArg.contains(":") || ontologyIdArg.endsWith(":")) {
            throw new InvalidCommandArgumentException(0, Messages.i18n.format("InvalidOntologyIdFormat", new Object[0]));
        }
        File filePath = null;
        if (filePathArg != null) {
            filePath = new File(filePathArg);
            if (filePath.exists()) {
                this.print(Messages.i18n.format("GetOntology.PathExists", new Object[]{filePath}), new Object[0]);
                return false;
            }
            if (filePath.getParentFile() != null && filePath.getParentFile().isFile()) {
                this.print(Messages.i18n.format("GetOntology.InvalidOutputPath", new Object[]{filePath}), new Object[0]);
                return false;
            }
        }
        String ontologyUuid = null;
        int colonIdx = ontologyIdArg.indexOf(58);
        String idType = ontologyIdArg.substring(0, colonIdx);
        String idValue = ontologyIdArg.substring(colonIdx + 1);
        if ("feed".equals(idType)) {
            List ontologies = (List)this.getContext().getVariable(feedVarName);
            if (ontologies == null) {
                throw new InvalidCommandArgumentException(0, Messages.i18n.format("DeleteOntology.NoOntologyFeed", new Object[0]));
            }
            int feedIdx = Integer.parseInt(idValue) - 1;
            if (feedIdx < 0 || feedIdx >= ontologies.size()) {
                throw new InvalidCommandArgumentException(0, Messages.i18n.format("FeedIndexOutOfRange", new Object[0]));
            }
            OntologySummary summary = (OntologySummary)ontologies.get(feedIdx);
            ontologyUuid = summary.getUuid();
        } else if ("uuid".equals(idType)) {
            ontologyUuid = idValue;
        } else {
            throw new InvalidCommandArgumentException(0, Messages.i18n.format("InvalidIdFormat", new Object[0]));
        }
        try {
            RDF ontology = client.getOntology(ontologyUuid);
            if (filePathArg != null) {
                this.saveOntologyToFile(ontology, filePath);
            } else {
                this.printOntology(ontology);
            }
        }
        catch (Exception e) {
            this.print(Messages.i18n.format("GetOntology.GetFailed", new Object[0]), new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
            return false;
        }
        return true;
    }

    private void printOntology(RDF ontology) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{RDF.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)ontology, (OutputStream)System.out);
    }

    private void saveOntologyToFile(RDF ontology, File filePath) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{RDF.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)ontology, filePath);
        this.print(Messages.i18n.format("GetOntology.OntologySaved", new Object[]{filePath.getCanonicalPath()}), new Object[0]);
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        int toReturn = FeedTabCompleter.tabCompletion(this.getArguments(), this.getContext(), lastArgument, candidates);
        if (this.getArguments().size() == 1) {
            if (lastArgument == null) {
                lastArgument = "";
            }
            FileNameCompleter delegate = new FileNameCompleter();
            return delegate.complete(lastArgument, lastArgument.length(), candidates);
        }
        return toReturn;
    }
}

