/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.api.ShellCommand;
import org.overlord.sramp.shell.api.ShellCommandProvider;
import org.overlord.sramp.shell.commands.CommandNotFoundCommand;
import org.overlord.sramp.shell.commands.EchoCommand;
import org.overlord.sramp.shell.commands.ExitCommand;
import org.overlord.sramp.shell.commands.HelpCommand;
import org.overlord.sramp.shell.commands.archive.AddEntryArchiveCommand;
import org.overlord.sramp.shell.commands.archive.CloseArchiveCommand;
import org.overlord.sramp.shell.commands.archive.ListArchiveCommand;
import org.overlord.sramp.shell.commands.archive.ListEntryArchiveCommand;
import org.overlord.sramp.shell.commands.archive.NewArchiveCommand;
import org.overlord.sramp.shell.commands.archive.OpenArchiveCommand;
import org.overlord.sramp.shell.commands.archive.PackArchiveCommand;
import org.overlord.sramp.shell.commands.archive.RemoveEntryArchiveCommand;
import org.overlord.sramp.shell.commands.archive.UpdateEntryArchiveCommand;
import org.overlord.sramp.shell.commands.archive.UploadArchiveCommand;
import org.overlord.sramp.shell.commands.audit.ShowAuditTrailCommand;
import org.overlord.sramp.shell.commands.core.ClassificationCommand;
import org.overlord.sramp.shell.commands.core.ConnectCommand;
import org.overlord.sramp.shell.commands.core.CreateArtifactCommand;
import org.overlord.sramp.shell.commands.core.DeleteCommand;
import org.overlord.sramp.shell.commands.core.DisconnectCommand;
import org.overlord.sramp.shell.commands.core.GetContentCommand;
import org.overlord.sramp.shell.commands.core.GetMetaDataCommand;
import org.overlord.sramp.shell.commands.core.PropertyCommand;
import org.overlord.sramp.shell.commands.core.QueryCommand;
import org.overlord.sramp.shell.commands.core.RefreshMetaDataCommand;
import org.overlord.sramp.shell.commands.core.ShowMetaDataCommand;
import org.overlord.sramp.shell.commands.core.StatusCommand;
import org.overlord.sramp.shell.commands.core.UpdateContentCommand;
import org.overlord.sramp.shell.commands.core.UpdateMetaDataCommand;
import org.overlord.sramp.shell.commands.core.UploadArtifactCommand;
import org.overlord.sramp.shell.commands.maven.DeployCommand;
import org.overlord.sramp.shell.commands.ontology.DeleteOntologyCommand;
import org.overlord.sramp.shell.commands.ontology.GetOntologyCommand;
import org.overlord.sramp.shell.commands.ontology.ListOntologiesCommand;
import org.overlord.sramp.shell.commands.ontology.UpdateOntologyCommand;
import org.overlord.sramp.shell.commands.ontology.UploadOntologyCommand;

public class ShellCommandFactory {
    private static QName HELP_CMD_NAME = new QName("s-ramp", "help");
    private static QName EXIT_CMD_NAME = new QName("s-ramp", "exit");
    private static QName QUIT_CMD_NAME = new QName("s-ramp", "quit");
    private static QName ECHO_CMD_NAME = new QName("s-ramp", "echo");
    private Map<QName, Class<? extends ShellCommand>> registry;

    public ShellCommandFactory() {
        this.registerCommands();
    }

    private void registerCommands() {
        this.registry = new HashMap<QName, Class<? extends ShellCommand>>();
        this.registry.put(new QName("s-ramp", "connect"), ConnectCommand.class);
        this.registry.put(new QName("s-ramp", "disconnect"), DisconnectCommand.class);
        this.registry.put(new QName("s-ramp", "status"), StatusCommand.class);
        this.registry.put(new QName("s-ramp", "query"), QueryCommand.class);
        this.registry.put(new QName("s-ramp", "getMetaData"), GetMetaDataCommand.class);
        this.registry.put(new QName("s-ramp", "getContent"), GetContentCommand.class);
        this.registry.put(new QName("s-ramp", "upload"), UploadArtifactCommand.class);
        this.registry.put(new QName("s-ramp", "updateMetaData"), UpdateMetaDataCommand.class);
        this.registry.put(new QName("s-ramp", "updateContent"), UpdateContentCommand.class);
        this.registry.put(new QName("s-ramp", "property"), PropertyCommand.class);
        this.registry.put(new QName("s-ramp", "classification"), ClassificationCommand.class);
        this.registry.put(new QName("s-ramp", "showMetaData"), ShowMetaDataCommand.class);
        this.registry.put(new QName("s-ramp", "refreshMetaData"), RefreshMetaDataCommand.class);
        this.registry.put(new QName("s-ramp", "delete"), DeleteCommand.class);
        this.registry.put(new QName("s-ramp", "create"), CreateArtifactCommand.class);
        this.registry.put(new QName("archive", "new"), NewArchiveCommand.class);
        this.registry.put(new QName("archive", "open"), OpenArchiveCommand.class);
        this.registry.put(new QName("archive", "close"), CloseArchiveCommand.class);
        this.registry.put(new QName("archive", "list"), ListArchiveCommand.class);
        this.registry.put(new QName("archive", "addEntry"), AddEntryArchiveCommand.class);
        this.registry.put(new QName("archive", "updateEntry"), UpdateEntryArchiveCommand.class);
        this.registry.put(new QName("archive", "removeEntry"), RemoveEntryArchiveCommand.class);
        this.registry.put(new QName("archive", "listEntry"), ListEntryArchiveCommand.class);
        this.registry.put(new QName("archive", "pack"), PackArchiveCommand.class);
        this.registry.put(new QName("archive", "upload"), UploadArchiveCommand.class);
        this.registry.put(new QName("ontology", "upload"), UploadOntologyCommand.class);
        this.registry.put(new QName("ontology", "list"), ListOntologiesCommand.class);
        this.registry.put(new QName("ontology", "delete"), DeleteOntologyCommand.class);
        this.registry.put(new QName("ontology", "get"), GetOntologyCommand.class);
        this.registry.put(new QName("ontology", "update"), UpdateOntologyCommand.class);
        this.registry.put(new QName("audit", "showAuditTrail"), ShowAuditTrailCommand.class);
        this.registry.put(new QName("maven", "deploy"), DeployCommand.class);
        this.discoverContributedCommands();
    }

    private void discoverContributedCommands() {
        ArrayList<ClassLoader> commandClassloaders = new ArrayList<ClassLoader>();
        commandClassloaders.add(Thread.currentThread().getContextClassLoader());
        String userHome = System.getProperty("user.home", "/");
        String commandsDirName = System.getProperty("s-ramp.shell.commandsDir", userHome + "/.s-ramp/commands");
        File commandsDir = new File(commandsDirName);
        if (!commandsDir.exists()) {
            commandsDir.mkdirs();
        }
        if (commandsDir.isDirectory()) {
            try {
                Collection jarFiles = FileUtils.listFiles((File)commandsDir, (String[])new String[]{"jar"}, (boolean)false);
                ArrayList<URL> jarURLs = new ArrayList<URL>(jarFiles.size());
                for (File jarFile : jarFiles) {
                    jarURLs.add(jarFile.toURI().toURL());
                }
                URL[] urls = jarURLs.toArray(new URL[jarURLs.size()]);
                URLClassLoader extraCommandsCL = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
                commandClassloaders.add(extraCommandsCL);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (ClassLoader classLoader : commandClassloaders) {
            for (ShellCommandProvider provider : ServiceLoader.load(ShellCommandProvider.class, classLoader)) {
                Map commands = provider.provideCommands();
                for (Map.Entry entry : commands.entrySet()) {
                    QName qualifiedCmdName = new QName(provider.getNamespace(), (String)entry.getKey());
                    this.registry.put(qualifiedCmdName, (Class<? extends ShellCommand>)entry.getValue());
                }
            }
        }
    }

    public ShellCommand createCommand(QName commandName) throws Exception {
        BuiltInShellCommand command = null;
        if (commandName.equals(HELP_CMD_NAME)) {
            command = new HelpCommand(this.getCommands(), this.getNamespaces());
        } else if (commandName.equals(QUIT_CMD_NAME)) {
            command = new ExitCommand();
        } else if (commandName.equals(EXIT_CMD_NAME)) {
            command = new ExitCommand();
        } else if (commandName.equals(ECHO_CMD_NAME)) {
            command = new EchoCommand();
        } else {
            Class<? extends ShellCommand> commandClass = this.registry.get(commandName);
            if (commandClass == null) {
                return new CommandNotFoundCommand();
            }
            command = commandClass.newInstance();
        }
        return command;
    }

    private Map<QName, Class<? extends ShellCommand>> getCommands() {
        TreeMap<QName, Class<? extends ShellCommand>> treeMap = new TreeMap<QName, Class<? extends ShellCommand>>(new Comparator<QName>(){

            @Override
            public int compare(QName name1, QName name2) {
                return name1.toString().compareTo(name2.toString());
            }
        });
        treeMap.putAll(this.registry);
        return treeMap;
    }

    public Set<String> getNamespaces() {
        TreeSet<String> namespaces = new TreeSet<String>();
        for (QName cmdName : this.registry.keySet()) {
            namespaces.add(cmdName.getNamespaceURI());
        }
        return namespaces;
    }

    public Set<QName> getCommandNames(String namespace) {
        TreeSet<QName> commandNames = new TreeSet<QName>(new Comparator<QName>(){

            @Override
            public int compare(QName o1, QName o2) {
                return o1.getLocalPart().compareTo(o2.getLocalPart());
            }
        });
        for (QName cmdName : this.registry.keySet()) {
            if (!namespace.equals(cmdName.getNamespaceURI())) continue;
            commandNames.add(cmdName);
        }
        return commandNames;
    }
}

