/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.overlord.sramp.shell.ShellArguments;
import org.overlord.sramp.shell.ShellCommandFactory;
import org.overlord.sramp.shell.ShellCommandReader;
import org.overlord.sramp.shell.api.Arguments;
import org.overlord.sramp.shell.api.ShellCommand;
import org.overlord.sramp.shell.api.ShellContext;
import org.overlord.sramp.shell.commands.NoOpCommand;

public abstract class AbstractShellCommandReader
implements ShellCommandReader {
    private final ShellContext context;
    private final ShellCommandFactory factory;
    private final ShellArguments args;

    public AbstractShellCommandReader(ShellCommandFactory factory, ShellContext context, ShellArguments args) {
        this.factory = factory;
        this.context = context;
        this.args = args;
        if (args.hasLogFile()) {
            try {
                new FileWriter(args.getLogFilePath(), false).write("");
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    @Override
    public abstract void open() throws IOException;

    @Override
    public final ShellCommand read() throws Exception {
        Arguments arguments;
        String line = this.readLine();
        if (line == null) {
            return null;
        }
        if (this.args.hasLogFile()) {
            FileWriter writer = new FileWriter(this.args.getLogFilePath(), true);
            writer.append(line + "\n");
            writer.close();
        }
        if ((arguments = new Arguments(line = AbstractShellCommandReader.interpolate(line, this.args.getPropertiesFromFile()))).isEmpty()) {
            return new NoOpCommand();
        }
        QName commandName = arguments.removeCommandName();
        ShellCommand command = this.factory.createCommand(commandName);
        command.setContext(this.context);
        command.setArguments(arguments);
        command.setOutput(this.getCommandOutput());
        return command;
    }

    protected static String interpolate(String line, Map<String, String> properties) {
        String interpolated = line;
        Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher matcher = pattern.matcher(line);
        while (matcher.find()) {
            String match = matcher.group();
            String keyWithOptionalDefault = match.substring(2, match.length() - 1);
            int idx = keyWithOptionalDefault.indexOf(58);
            String key = keyWithOptionalDefault;
            String defaultVal = null;
            if (idx > 0) {
                key = keyWithOptionalDefault.substring(0, idx);
                defaultVal = keyWithOptionalDefault.substring(idx + 1);
            }
            if (properties.containsKey(key)) {
                interpolated = interpolated.replace(match, properties.get(key));
                continue;
            }
            if (System.getProperties().containsKey(key)) {
                interpolated = interpolated.replace(match, System.getProperty(key));
                continue;
            }
            if (defaultVal == null) continue;
            interpolated = interpolated.replace(match, defaultVal);
        }
        return interpolated;
    }

    protected Writer getCommandOutput() {
        return new OutputStreamWriter(System.out);
    }

    protected abstract String readLine() throws IOException;

    @Override
    public void close() throws IOException {
    }

    public ShellCommandFactory getFactory() {
        return this.factory;
    }

    public ShellContext getContext() {
        return this.context;
    }

    public ShellArguments getArgs() {
        return this.args;
    }

    @Override
    public boolean isBatch() {
        return false;
    }
}

