/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.storedquery;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.StoredQuery;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.commands.storedquery.StoredQueryCommandUtil;
import org.overlord.sramp.shell.i18n.Messages;

public class ListStoredQueriesCommand
extends BuiltInShellCommand {
    public boolean execute() throws Exception {
        SrampAtomApiClient client = StoredQueryCommandUtil.client(this, this.getContext());
        if (client == null) {
            return false;
        }
        try {
            List storedQueries = client.getStoredQueries();
            for (StoredQuery storedQuery : storedQueries) {
                this.print(storedQuery.getQueryName() + ": " + storedQuery.getQueryExpression(), new Object[0]);
                if (storedQuery.getPropertyName().size() <= 0) continue;
                this.print("     property names: " + StringUtils.join((Collection)storedQuery.getPropertyName(), (String)", "), new Object[0]);
            }
        }
        catch (Exception e) {
            this.print(Messages.i18n.format("ListStoredQueriesCommand.Fail", new Object[0]), new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
            return false;
        }
        return true;
    }
}

