/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.test;

import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.junit.After;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.overlord.sramp.atom.client.ClientRequest;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.client.ontology.OntologySummary;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;

@RunWith(value=Arquillian.class)
public abstract class AbstractIntegrationTest {
    private static final String HOST = "localhost";
    private static final int PORT = 8080;
    private static final String BASE_URL = "http://localhost:8080/s-ramp-server";
    protected static final String USERNAME = "admin";
    protected static final String PASSWORD = "overlord1!";

    @After
    public void cleanup() {
        SrampAtomApiClient client;
        try {
            client = this.client();
            QueryResultSet results = client.query("/s-ramp", 0, 10000, "name", true);
            for (ArtifactSummary summary : results) {
                if (summary.isDerived()) continue;
                client.deleteArtifact(summary.getUuid(), summary.getType());
            }
        }
        catch (Exception e) {
            Assert.fail((String)"Unable to cleanup test artifacts.");
        }
        try {
            client = this.client();
            List ontologies = client.getOntologies();
            for (OntologySummary ontology : ontologies) {
                client.deleteOntology(ontology.getUuid());
            }
        }
        catch (Exception e) {
            Assert.fail((String)"Unable to cleanup test artifacts.");
        }
    }

    protected String getHost() {
        return HOST;
    }

    protected int getPort() {
        return 8080;
    }

    protected String getUsername() {
        return USERNAME;
    }

    protected String getPassword() {
        return PASSWORD;
    }

    protected SrampAtomApiClient client() throws SrampClientException, SrampAtomException {
        return new SrampAtomApiClient(BASE_URL, USERNAME, PASSWORD, true);
    }

    protected ClientRequest clientRequest(String endpoint) {
        DefaultHttpClient client = new DefaultHttpClient();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(USERNAME, PASSWORD);
        client.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY), (Credentials)credentials);
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        HttpHost targetHost = new HttpHost(HOST, 8080);
        authCache.put(targetHost, (AuthScheme)basicAuth);
        BasicHttpContext localContext = new BasicHttpContext();
        localContext.setAttribute("http.auth.auth-cache", (Object)authCache);
        ApacheHttpClient4Executor executor = new ApacheHttpClient4Executor((HttpClient)client, (HttpContext)localContext);
        ClientRequest clientRequest = new ClientRequest(BASE_URL + endpoint, (ClientExecutor)executor);
        return clientRequest;
    }

    protected String generateURL(String endpoint) {
        return BASE_URL + endpoint;
    }
}

