/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.test.client;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XmlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocument;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.atom.mappers.RdfToOntologyMapper;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.ontology.OntologySummary;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.common.ontology.SrampOntology;
import org.overlord.sramp.test.client.AbstractNoAuditingClientTest;
import org.w3._1999._02._22_rdf_syntax_ns_.RDF;

public class SrampAtomApiClientTest
extends AbstractNoAuditingClientTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUploadArtifact() throws Exception {
        String artifactFileName = "PO.xsd";
        InputStream is = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            SrampAtomApiClient client = this.client();
            BaseArtifactType artifact = client.uploadArtifact(ArtifactType.XsdDocument(), is, artifactFileName);
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)artifactFileName, (Object)artifact.getName());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    @Test
    public void testCreateArtifact() throws Exception {
        ExtendedArtifactType artifact = new ExtendedArtifactType();
        artifact.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
        artifact.setExtendedType("TestArtifact");
        artifact.setName("My Test Artifact");
        artifact.setDescription("Description of my test artifact.");
        SrampAtomApiClient client = this.client();
        BaseArtifactType createdArtifact = client.createArtifact((BaseArtifactType)artifact);
        Assert.assertNotNull((Object)artifact);
        Assert.assertEquals((Object)"My Test Artifact", (Object)createdArtifact.getName());
        Assert.assertEquals((Object)"Description of my test artifact.", (Object)createdArtifact.getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExtendedDocumentArtifact() throws Exception {
        String artifactFileName = "PO.xsd";
        InputStream is = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            SrampAtomApiClient client = this.client();
            BaseArtifactType artifact = client.uploadArtifact(ArtifactType.ExtendedDocument((String)"TestDocument"), is, artifactFileName);
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)artifactFileName, (Object)artifact.getName());
            Assert.assertEquals((Object)BaseArtifactEnum.EXTENDED_DOCUMENT, (Object)artifact.getArtifactType());
            Assert.assertEquals(ExtendedDocument.class, artifact.getClass());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetArtifactMetaData() throws Exception {
        SrampAtomApiClient client;
        String uuid = null;
        String artifactFileName = "PO.xsd";
        InputStream is = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            client = this.client();
            BaseArtifactType artifact = client.uploadArtifact(ArtifactType.XsdDocument(), is, artifactFileName);
            Assert.assertNotNull((Object)artifact);
            uuid = artifact.getUuid();
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        client = this.client();
        BaseArtifactType metaData = client.getArtifactMetaData(ArtifactType.XsdDocument(), uuid);
        Assert.assertNotNull((Object)metaData);
        Assert.assertEquals((Object)artifactFileName, (Object)metaData.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetArtifactMetaDataNoType() throws Exception {
        SrampAtomApiClient client;
        String uuid = null;
        String artifactFileName = "PO.xsd";
        InputStream is = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            client = this.client();
            BaseArtifactType artifact = client.uploadArtifact(ArtifactType.XsdDocument(), is, artifactFileName);
            Assert.assertNotNull((Object)artifact);
            uuid = artifact.getUuid();
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        client = this.client();
        BaseArtifactType metaData = client.getArtifactMetaData(uuid);
        Assert.assertNotNull((Object)metaData);
        Assert.assertEquals((Object)artifactFileName, (Object)metaData.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUploadArtifactAndContent() throws Exception {
        String uuid = UUID.randomUUID().toString();
        String artifactFileName = "PO.xsd";
        InputStream is = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            SrampAtomApiClient client = this.client();
            XsdDocument xsdDocument = new XsdDocument();
            xsdDocument.setName(artifactFileName);
            xsdDocument.setUuid(uuid);
            BaseArtifactType artifact = client.uploadArtifact((BaseArtifactType)xsdDocument, is);
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)artifactFileName, (Object)artifact.getName());
            Assert.assertEquals((Object)uuid, (Object)artifact.getUuid());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetArtifactContent() throws Exception {
        SrampAtomApiClient client = this.client();
        String uuid = null;
        String artifactFileName = "PO.xsd";
        InputStream is = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            BaseArtifactType artifact = client.uploadArtifact(ArtifactType.XsdDocument(), is, artifactFileName);
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)artifactFileName, (Object)artifact.getName());
            uuid = artifact.getUuid();
        }
        finally {
            is.close();
        }
        InputStream content = client.getArtifactContent(ArtifactType.XsdDocument(), uuid.toString());
        try {
            Assert.assertNotNull((Object)content);
            BufferedReader reader = new BufferedReader(new InputStreamReader(content));
            String line1 = reader.readLine();
            String line2 = reader.readLine();
            Assert.assertTrue((String)"Unexpected content found.", (boolean)line1.startsWith("<?xml version=\"1.0\""));
            Assert.assertTrue((String)"Unexpected content found.", (boolean)line2.startsWith("<xsd:schema"));
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateArtifactMetaData() throws Exception {
        BaseArtifactType artifact;
        SrampAtomApiClient client = this.client();
        String uuid = null;
        XsdDocument xsdDoc = null;
        String artifactFileName = "PO.xsd";
        InputStream is = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            artifact = client.uploadArtifact(ArtifactType.XsdDocument(), is, artifactFileName);
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)artifactFileName, (Object)artifact.getName());
            uuid = artifact.getUuid();
            xsdDoc = (XsdDocument)artifact;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        xsdDoc.setDescription("** DESCRIPTION UPDATED **");
        client.updateArtifactMetaData((BaseArtifactType)xsdDoc);
        artifact = client.getArtifactMetaData(ArtifactType.XsdDocument(), uuid.toString());
        Assert.assertEquals((Object)"** DESCRIPTION UPDATED **", (Object)artifact.getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateArtifactContent() throws Exception {
        BaseArtifactType artifact;
        SrampAtomApiClient client = this.client();
        String uuid = null;
        XsdDocument xsdDoc = null;
        String artifactFileName = "PO.xsd";
        InputStream is = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            artifact = client.uploadArtifact(ArtifactType.XsdDocument(), is, artifactFileName);
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)artifactFileName, (Object)artifact.getName());
            uuid = artifact.getUuid();
            xsdDoc = (XsdDocument)artifact;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        is = this.getClass().getResourceAsStream("/sample-files/xsd/PO-updated.xsd");
        try {
            client.updateArtifactContent((BaseArtifactType)xsdDoc, is);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        artifact = client.getArtifactMetaData(ArtifactType.XsdDocument(), uuid.toString());
        xsdDoc = (XsdDocument)artifact;
        Assert.assertEquals((Object)new Long(2583L), (Object)xsdDoc.getContentSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQuery() throws Exception {
        SrampAtomApiClient client = this.client();
        String uuid = null;
        String artifactFileName = "PO.xsd";
        InputStream is = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            BaseArtifactType artifact = client.uploadArtifact(ArtifactType.XsdDocument(), is, artifactFileName);
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)artifactFileName, (Object)artifact.getName());
            uuid = artifact.getUuid();
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        QueryResultSet rset = client.query("/s-ramp/xsd/XsdDocument", 0, 50, "name", false);
        boolean uuidFound = false;
        for (ArtifactSummary entry : rset) {
            if (!entry.getUuid().equals(uuid)) continue;
            uuidFound = true;
        }
        Assert.assertTrue((String)"Failed to find the artifact we just added!", (boolean)uuidFound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryWithPropertyName() throws Exception {
        SrampAtomApiClient client = this.client();
        String uuid = null;
        String artifactFileName = "PO.xsd";
        InputStream is = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            BaseArtifactType artifact = client.uploadArtifact(ArtifactType.XsdDocument(), is, artifactFileName);
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)artifactFileName, (Object)artifact.getName());
            uuid = artifact.getUuid();
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"prop1", (String)"foo");
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"prop2", (String)"bar");
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"prop3", (String)"baz");
            client.updateArtifactMetaData(artifact);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        HashSet<String> propertyNames = new HashSet<String>();
        propertyNames.add("prop1");
        propertyNames.add("prop2");
        QueryResultSet rset = client.query("/s-ramp/xsd/XsdDocument[@uuid='" + uuid + "']", 0, 50, "name", false, propertyNames);
        Assert.assertEquals((String)"Expected a single artifact returned.", (long)1L, (long)rset.size());
        ArtifactSummary summary = rset.get(0);
        Assert.assertEquals((Object)"foo", (Object)summary.getCustomPropertyValue("prop1"));
        Assert.assertEquals((Object)"bar", (Object)summary.getCustomPropertyValue("prop2"));
        Assert.assertNull((String)"I didn't ask for 'prop3' to be returned!", (Object)summary.getCustomPropertyValue("prop3"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildQuery() throws Exception {
        SrampAtomApiClient client = this.client();
        String uuid = null;
        String artifactFileName = "PO.xsd";
        InputStream is = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            BaseArtifactType artifact = client.uploadArtifact(ArtifactType.XsdDocument(), is, artifactFileName);
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)artifactFileName, (Object)artifact.getName());
            uuid = artifact.getUuid();
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        QueryResultSet rset = client.buildQuery("/s-ramp/xsd/XsdDocument[@uuid = ?]").parameter(uuid).count(1).query();
        Assert.assertTrue((String)"Failed to find the artifact we just added!", (rset.size() == 1L ? 1 : 0) != 0);
        rset = client.buildQuery("/s-ramp[@lastModifiedTimestamp < ?]").parameter(new Date(System.currentTimeMillis() + 86400000L)).count(1).query();
        Assert.assertTrue((String)"Failed to find an artifact by lastModifiedTimestamp!", (rset.size() == 1L ? 1 : 0) != 0);
        rset = client.buildQuery("/s-ramp[@lastModifiedTimestamp > ?]").parameter(new Date(System.currentTimeMillis() + 86400000L)).count(1).query();
        Assert.assertTrue((String)"Found an artifact by lastModifiedTimestamp, but should *not* have!", (rset.size() == 0L ? 1 : 0) != 0);
        Calendar endOfToday = Calendar.getInstance();
        endOfToday.set(11, 0);
        endOfToday.set(12, 0);
        endOfToday.set(13, 0);
        endOfToday.set(14, 0);
        endOfToday.add(6, 1);
        rset = client.buildQuery("/s-ramp[@lastModifiedTimestamp < ?]").parameter(endOfToday).count(1).query();
        Assert.assertTrue((String)"Failed to find an artifact by lastModifiedTimestamp!", (rset.size() == 1L ? 1 : 0) != 0);
        rset = client.buildQuery("/s-ramp[@lastModifiedTimestamp > ?]").parameter(endOfToday).count(1).query();
        Assert.assertTrue((String)"Found an artifact by lastModifiedTimestamp, but should *not* have!", (rset.size() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testResultSetAttributes() throws Exception {
        SrampAtomApiClient client = this.client();
        for (int i = 0; i < 20; ++i) {
            this.addXmlDoc();
        }
        QueryResultSet rs = client.buildQuery("/s-ramp/core").count(2).startIndex(5).query();
        Assert.assertEquals((long)20L, (long)rs.getTotalResults());
        Assert.assertEquals((long)2L, (long)rs.getItemsPerPage());
        Assert.assertEquals((long)5L, (long)rs.getStartIndex());
    }

    @Test
    public void testQueryError() throws Exception {
        SrampAtomApiClient client = this.client();
        try {
            QueryResultSet rset = client.query("12345", 0, 20, "name", false);
            Assert.fail((String)("Expected a remote exception from the s-ramp server, but got: " + rset));
        }
        catch (SrampAtomException e) {
            Assert.assertEquals((Object)"Invalid artifact set (step 2).", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArchiveUpload() throws Exception {
        SrampArchive archive = null;
        InputStream is1 = null;
        InputStream is2 = null;
        try {
            archive = new SrampArchive();
            String artifactFileName = "PO.xsd";
            is1 = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
            XsdDocument metaData = new XsdDocument();
            metaData.setName("PO.xsd");
            metaData.setVersion("1.1");
            metaData.setDescription("This is a test description (XSD).");
            archive.addEntry("schemas/PO.xsd", (BaseArtifactType)metaData, is1);
            artifactFileName = "PO.xml";
            is2 = this.getClass().getResourceAsStream("/sample-files/core/" + artifactFileName);
            metaData = new XsdDocument();
            metaData.setName("PO.xml");
            metaData.setVersion("1.2");
            metaData.setDescription("This is a test description (XML).");
            archive.addEntry("core/PO.xml", (BaseArtifactType)metaData, is2);
        }
        catch (Exception e) {
            try {
                SrampArchive.closeQuietly((SrampArchive)archive);
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is1);
                IOUtils.closeQuietly(is2);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is1);
        IOUtils.closeQuietly((InputStream)is2);
        try {
            SrampAtomApiClient client = this.client();
            Map results = client.uploadBatch(archive);
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertTrue((boolean)results.keySet().contains("schemas/PO.xsd"));
            Assert.assertTrue((boolean)results.keySet().contains("core/PO.xml"));
            XsdDocument xsdDoc = (XsdDocument)results.get("schemas/PO.xsd");
            Assert.assertNotNull((Object)xsdDoc);
            Assert.assertEquals((Object)"PO.xsd", (Object)xsdDoc.getName());
            Assert.assertEquals((Object)"1.1", (Object)xsdDoc.getVersion());
            XmlDocument xmlDoc = (XmlDocument)results.get("core/PO.xml");
            Assert.assertNotNull((Object)xmlDoc);
            Assert.assertEquals((Object)"PO.xml", (Object)xmlDoc.getName());
            Assert.assertEquals((Object)"1.2", (Object)xmlDoc.getVersion());
        }
        finally {
            SrampArchive.closeQuietly((SrampArchive)archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArchiveUpload_Empty() throws Exception {
        SrampArchive archive = null;
        try {
            archive = new SrampArchive();
        }
        catch (Exception e) {
            SrampArchive.closeQuietly((SrampArchive)archive);
            throw e;
        }
        try {
            SrampAtomApiClient client = this.client();
            Map results = client.uploadBatch(archive);
            Assert.assertTrue((boolean)results.isEmpty());
        }
        finally {
            SrampArchive.closeQuietly((SrampArchive)archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArchiveUpload_AtomOnly() throws Exception {
        SrampArchive archive = null;
        try {
            archive = new SrampArchive();
            ExtendedArtifactType nonDocArtifact = new ExtendedArtifactType();
            nonDocArtifact.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
            nonDocArtifact.setExtendedType("TestArtifact");
            nonDocArtifact.setName("My Test Artifact");
            archive.addEntry("myLogicalArtifact", (BaseArtifactType)nonDocArtifact, null);
        }
        catch (Exception e) {
            SrampArchive.closeQuietly((SrampArchive)archive);
            throw e;
        }
        try {
            SrampAtomApiClient client = this.client();
            Map results = client.uploadBatch(archive);
            Assert.assertFalse((boolean)results.isEmpty());
            Assert.assertEquals((long)1L, (long)results.size());
            QueryResultSet resultSet = client.buildQuery("/s-ramp/ext").query();
            Assert.assertNotNull((Object)resultSet);
            Assert.assertEquals((long)1L, (long)resultSet.getTotalResults());
            resultSet = client.buildQuery("/s-ramp/ext/TestArtifact").query();
            Assert.assertNotNull((Object)resultSet);
            Assert.assertEquals((long)1L, (long)resultSet.getTotalResults());
            resultSet = client.buildQuery("/s-ramp/ext/TestArtifact[@name = 'My Test Artifact']").query();
            Assert.assertNotNull((Object)resultSet);
            Assert.assertEquals((long)1L, (long)resultSet.getTotalResults());
        }
        finally {
            SrampArchive.closeQuietly((SrampArchive)archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArchiveUploadWithError() throws Exception {
        SrampArchive archive = null;
        InputStream is1 = null;
        InputStream is2 = null;
        try {
            archive = new SrampArchive();
            String artifactFileName = "PO.xsd";
            is1 = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
            XsdDocument metaData = new XsdDocument();
            metaData.setName("PO.xsd");
            metaData.setVersion("1.1");
            metaData.setDescription("This is a test description (XSD).");
            archive.addEntry("schemas/PO.xsd", (BaseArtifactType)metaData, is1);
            artifactFileName = "PO.xml";
            metaData = new XsdDocument();
            metaData.setName("PO.xml");
            metaData.setVersion("1.2");
            metaData.setDescription("This is a test description (XML).");
            archive.addEntry("core/PO.xml", (BaseArtifactType)metaData, null);
        }
        catch (Exception e) {
            try {
                SrampArchive.closeQuietly((SrampArchive)archive);
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is1);
                IOUtils.closeQuietly(is2);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is1);
        IOUtils.closeQuietly(is2);
        try {
            SrampAtomApiClient client = this.client();
            Map results = client.uploadBatch(archive);
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertTrue((boolean)results.keySet().contains("schemas/PO.xsd"));
            Assert.assertTrue((boolean)results.keySet().contains("core/PO.xml"));
            XsdDocument xsdDoc = (XsdDocument)results.get("schemas/PO.xsd");
            Assert.assertNotNull((Object)xsdDoc);
            Assert.assertEquals((Object)"PO.xsd", (Object)xsdDoc.getName());
            Assert.assertEquals((Object)"1.1", (Object)xsdDoc.getVersion());
            Exception xmlError = (Exception)results.get("core/PO.xml");
            Assert.assertNotNull((Object)xmlError);
        }
        finally {
            SrampArchive.closeQuietly((SrampArchive)archive);
        }
    }

    @Test
    public void testUploadOntology() throws Exception {
        SrampOntology ontology = this.uploadOntology();
        this.client().deleteOntology(ontology.getUuid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SrampOntology uploadOntology() throws Exception {
        String ontologyFileName = "colors.owl.xml";
        InputStream is = this.getClass().getResourceAsStream("/sample-files/ontologies/" + ontologyFileName);
        Assert.assertNotNull((Object)is);
        try {
            SrampAtomApiClient client = this.client();
            RDF rdf = client.uploadOntology(is);
            Assert.assertNotNull((Object)rdf);
            SrampOntology ontology = RdfToOntologyMapper.rdf2ontology((RDF)rdf);
            Assert.assertNotNull((Object)ontology);
            Assert.assertEquals((Object)"http://www.example.org/colors.owl", (Object)ontology.getBase());
            Assert.assertNotNull((Object)ontology.getUuid());
            SrampOntology srampOntology = ontology;
            return srampOntology;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    @Test
    public void testGetOntologies() throws Exception {
        SrampAtomApiClient client = this.client();
        List ontologies = client.getOntologies();
        Assert.assertNotNull((Object)ontologies);
        Assert.assertTrue((boolean)ontologies.isEmpty());
        SrampOntology ontology = this.uploadOntology();
        ontologies = client.getOntologies();
        Assert.assertNotNull((Object)ontologies);
        Assert.assertFalse((boolean)ontologies.isEmpty());
        Assert.assertEquals((long)1L, (long)ontologies.size());
        OntologySummary ontologySummary = (OntologySummary)ontologies.get(0);
        Assert.assertEquals((Object)"http://www.example.org/colors.owl", (Object)ontologySummary.getBase());
        Assert.assertEquals((Object)"Colors ontology", (Object)ontologySummary.getComment());
        Assert.assertEquals((Object)"Colors", (Object)ontologySummary.getId());
        Assert.assertEquals((Object)"Colors", (Object)ontologySummary.getLabel());
        Assert.assertNotNull((Object)ontologySummary.getUuid());
        this.client().deleteOntology(ontology.getUuid());
    }

    @Test
    public void testGetOntology() throws Exception {
        SrampAtomApiClient client = this.client();
        RDF rdf = null;
        try {
            rdf = client.getOntology("INVALID_UUID");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"No ontology found with UUID: INVALID_UUID", (Object)e.getMessage());
        }
        Assert.assertNull((Object)rdf);
        this.uploadOntology();
        List ontologies = client.getOntologies();
        Assert.assertNotNull((Object)ontologies);
        Assert.assertFalse((boolean)ontologies.isEmpty());
        Assert.assertEquals((long)1L, (long)ontologies.size());
        OntologySummary ontologySummary = (OntologySummary)ontologies.get(0);
        String uuid = ontologySummary.getUuid();
        rdf = client.getOntology(uuid);
        Assert.assertNotNull((Object)rdf);
        SrampOntology ontology = RdfToOntologyMapper.rdf2ontology((RDF)rdf);
        Assert.assertNotNull((Object)ontology);
        Assert.assertEquals((Object)"http://www.example.org/colors.owl", (Object)ontology.getBase());
        Assert.assertNotNull((Object)ontology.getUuid());
        this.client().deleteOntology(ontology.getUuid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryWithPropertyName_SRAMP389() throws Exception {
        SrampAtomApiClient client = this.client();
        for (int count = 0; count < 10; ++count) {
            String artifactFileName = "PO-" + count + ".xsd";
            InputStream is = this.getClass().getResourceAsStream("/sample-files/xsd/PO.xsd");
            try {
                BaseArtifactType artifact = client.uploadArtifact(ArtifactType.XsdDocument(), is, artifactFileName);
                Assert.assertNotNull((Object)artifact);
                Assert.assertEquals((Object)artifactFileName, (Object)artifact.getName());
                SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"count", (String)String.valueOf(count));
                SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"prop1", (String)"foo");
                SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"test", (String)"SRAMP-389");
                client.updateArtifactMetaData(artifact);
                continue;
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        QueryResultSet rset = client.buildQuery("/s-ramp[@test = 'SRAMP-389']").propertyName("count").propertyName("prop1").orderBy("createdTimestamp").descending().query();
        StringBuilder builder = new StringBuilder();
        System.out.println("----- Query done, iterating result set");
        long start = System.currentTimeMillis();
        for (ArtifactSummary artifactSummary : rset) {
            String prop = artifactSummary.getCustomPropertyValue("count");
            builder.append(prop);
            builder.append("|");
        }
        long end = System.currentTimeMillis();
        System.out.println("----- Done iterating in: " + (end - start) + "ms");
        Assert.assertEquals((Object)"9|8|7|6|5|4|3|2|1|0|", (Object)builder.toString());
    }
}

