/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.test.client;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.StoredQuery;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.test.client.AbstractNoAuditingClientTest;

public class StoredQueryClientTest
extends AbstractNoAuditingClientTest {
    @Test
    public void testStoredQuery() throws Exception {
        SrampAtomApiClient client = this.client();
        ExtendedArtifactType artifact = new ExtendedArtifactType();
        artifact.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
        artifact.setExtendedType("TestArtifact");
        artifact.setName("My Test Artifact");
        artifact.setDescription("Description of my test artifact.");
        BaseArtifactType createdArtifact = client.createArtifact((BaseArtifactType)artifact);
        StoredQuery storedQuery = new StoredQuery();
        storedQuery.setQueryName("fooQuery");
        storedQuery.setQueryExpression("/s-ramp/ext/TestArtifact");
        storedQuery.getPropertyName().add("fooProperty");
        StoredQuery returnedStoredQuery = client.createStoredQuery(storedQuery);
        Assert.assertNotNull((Object)returnedStoredQuery);
        Assert.assertEquals((Object)storedQuery.getQueryName(), (Object)returnedStoredQuery.getQueryName());
        Assert.assertEquals((Object)storedQuery.getQueryExpression(), (Object)returnedStoredQuery.getQueryExpression());
        Assert.assertEquals((long)1L, (long)returnedStoredQuery.getPropertyName().size());
        Assert.assertEquals(storedQuery.getPropertyName().get(0), returnedStoredQuery.getPropertyName().get(0));
        returnedStoredQuery = client.getStoredQuery(storedQuery.getQueryName());
        Assert.assertNotNull((Object)returnedStoredQuery);
        Assert.assertEquals((Object)storedQuery.getQueryName(), (Object)returnedStoredQuery.getQueryName());
        Assert.assertEquals((Object)storedQuery.getQueryExpression(), (Object)returnedStoredQuery.getQueryExpression());
        Assert.assertEquals((long)1L, (long)returnedStoredQuery.getPropertyName().size());
        Assert.assertEquals(storedQuery.getPropertyName().get(0), returnedStoredQuery.getPropertyName().get(0));
        List returnedStoredQueries = client.getStoredQueries();
        Assert.assertNotNull((Object)returnedStoredQueries);
        Assert.assertEquals((long)1L, (long)returnedStoredQueries.size());
        Assert.assertEquals((Object)storedQuery.getQueryName(), (Object)((StoredQuery)returnedStoredQueries.get(0)).getQueryName());
        Assert.assertEquals((Object)storedQuery.getQueryExpression(), (Object)((StoredQuery)returnedStoredQueries.get(0)).getQueryExpression());
        Assert.assertEquals((long)1L, (long)((StoredQuery)returnedStoredQueries.get(0)).getPropertyName().size());
        Assert.assertEquals(storedQuery.getPropertyName().get(0), ((StoredQuery)returnedStoredQueries.get(0)).getPropertyName().get(0));
        storedQuery.setQueryExpression("/s-ramp/ext/TestArtifact[@uuid='" + createdArtifact.getUuid() + "']");
        client.updateStoredQuery(storedQuery.getQueryName(), storedQuery);
        returnedStoredQuery = client.getStoredQuery(storedQuery.getQueryName());
        Assert.assertNotNull((Object)returnedStoredQuery);
        Assert.assertEquals((Object)storedQuery.getQueryName(), (Object)returnedStoredQuery.getQueryName());
        Assert.assertEquals((Object)storedQuery.getQueryExpression(), (Object)returnedStoredQuery.getQueryExpression());
        Assert.assertEquals((long)1L, (long)returnedStoredQuery.getPropertyName().size());
        Assert.assertEquals(storedQuery.getPropertyName().get(0), returnedStoredQuery.getPropertyName().get(0));
        QueryResultSet queryResults = client.queryWithStoredQuery(storedQuery.getQueryName());
        Assert.assertNotNull((Object)queryResults);
        Assert.assertEquals((long)1L, (long)queryResults.getTotalResults());
        ArtifactSummary queryResult = queryResults.get(0);
        Assert.assertEquals((Object)artifact.getName(), (Object)queryResult.getName());
        Assert.assertEquals((Object)artifact.getDescription(), (Object)queryResult.getDescription());
        client.deleteStoredQuery(storedQuery.getQueryName());
        returnedStoredQueries = client.getStoredQueries();
        Assert.assertNotNull((Object)returnedStoredQueries);
        Assert.assertEquals((long)0L, (long)returnedStoredQueries.size());
    }
}

