/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.test.server.atom.services;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedOutput;
import org.jgroups.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Artifact;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Document;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Message;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PartEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PartTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XmlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocument;
import org.overlord.sramp.atom.MediaType;
import org.overlord.sramp.atom.SrampAtomUtils;
import org.overlord.sramp.atom.client.ClientRequest;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.atom.providers.SrampAtomExceptionProvider;
import org.overlord.sramp.common.SrampConstants;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.test.TestUtils;
import org.overlord.sramp.test.server.atom.services.AbstractNoAuditingResourceTest;

public class ArtifactResourceTest
extends AbstractNoAuditingResourceTest {
    String uuid = null;

    @Test
    public void testDerivedArtifactCreate() throws Exception {
        ClientRequest request = this.clientRequest("/s-ramp/xsd/ElementDeclaration");
        String artifactFileName = "PO.xsd";
        InputStream POXsd = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        String xmltext = TestUtils.convertStreamToString(POXsd);
        POXsd.close();
        request.header("Slug", (Object)artifactFileName);
        request.body("application/xml", (Object)xmltext);
        try {
            request.post(String.class);
            Assert.fail((String)"Expected an error here.");
        }
        catch (SrampAtomException e) {
            Assert.assertEquals((Object)"Failed to create artifact because \"ElementDeclaration\" is a derived type.", (Object)e.getMessage());
            String stack = SrampAtomExceptionProvider.getRootStackTrace((Throwable)e);
            Assert.assertTrue((boolean)stack.contains("org.overlord.sramp.server.atom.services.ArtifactResource.create"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPDFDocument() throws Exception {
        Document doc;
        BaseArtifactType arty;
        Entry entry;
        ClientResponse response;
        ClientRequest request;
        String artifactFileName = "sample.pdf";
        InputStream contentStream = this.getClass().getResourceAsStream("/sample-files/core/" + artifactFileName);
        try {
            request = this.clientRequest("/s-ramp/core/Document");
            request.header("Slug", (Object)artifactFileName);
            request.body("application/pdf", (Object)contentStream);
            response = request.post(Entry.class);
            entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)artifactFileName, (Object)entry.getTitle());
            arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertTrue((boolean)(arty instanceof Document));
            doc = (Document)arty;
            Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
            Assert.assertEquals((Object)218882L, (Object)doc.getContentSize());
            Assert.assertEquals((Object)"application/pdf", (Object)doc.getContentType());
            this.uuid = doc.getUuid();
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
        request = this.clientRequest("/s-ramp/core/Document/" + this.uuid);
        response = request.get(Entry.class);
        entry = (Entry)response.getEntity();
        arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        Assert.assertTrue((boolean)(arty instanceof Document));
        doc = (Document)arty;
        Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
        Assert.assertEquals((Object)218882L, (Object)doc.getContentSize());
        Assert.assertEquals((Object)"sample.pdf", (Object)doc.getName());
        Assert.assertEquals((Object)"application/pdf", (Object)doc.getContentType());
        ClientRequest request2 = this.clientRequest("/s-ramp/core/Document/" + this.uuid + "/media");
        ClientResponse response2 = request2.get(InputStream.class);
        if (response2.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
        }
        InputStream in = (InputStream)response2.getEntity();
        File file = new File("target/SRAMP-sample.pdf");
        FileOutputStream out = new FileOutputStream(file);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        out.flush();
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    @Test
    public void testExtendedArtifactType() throws Exception {
        ExtendedArtifactType artifact = new ExtendedArtifactType();
        artifact.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
        artifact.setExtendedType("FooApplication");
        artifact.setName("Extended Artifact Name");
        artifact.setDescription("Extended Artifact Description");
        ClientRequest request = this.clientRequest("/s-ramp/ext/FooApplication");
        Entry requestEntry = SrampAtomUtils.wrapSrampArtifact((BaseArtifactType)artifact);
        request.body("application/atom+xml;type=entry", (Object)requestEntry);
        ClientResponse response = request.post(Entry.class);
        Entry responseEntry = (Entry)response.getEntity();
        Assert.assertEquals((Object)"Extended Artifact Name", (Object)responseEntry.getTitle());
        BaseArtifactType arty = SrampAtomUtils.unwrapSrampArtifact((Entry)responseEntry);
        Assert.assertTrue((boolean)(arty instanceof ExtendedArtifactType));
        ExtendedArtifactType extArty = (ExtendedArtifactType)arty;
        Assert.assertEquals((Object)"Extended Artifact Name", (Object)extArty.getName());
        Assert.assertEquals((Object)"Extended Artifact Description", (Object)extArty.getDescription());
        this.uuid = extArty.getUuid();
        request = this.clientRequest("/s-ramp/ext/FooApplication/" + this.uuid);
        response = request.get(Entry.class);
        Entry entry = (Entry)response.getEntity();
        arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        Assert.assertTrue((boolean)(arty instanceof ExtendedArtifactType));
        extArty = (ExtendedArtifactType)arty;
        Assert.assertEquals((Object)"Extended Artifact Name", (Object)extArty.getName());
        Assert.assertEquals((Object)"Extended Artifact Description", (Object)extArty.getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBrmsPkgDocument() throws Exception {
        ExtendedDocument doc;
        BaseArtifactType arty;
        Entry entry;
        ClientResponse response;
        ClientRequest request;
        String artifactFileName = "defaultPackage.pkg";
        InputStream contentStream = this.getClass().getResourceAsStream("/sample-files/ext/" + artifactFileName);
        String uuid = null;
        try {
            request = this.clientRequest("/s-ramp/ext/BrmsPkgDocument");
            request.header("Slug", (Object)artifactFileName);
            request.body("application/octet-stream", (Object)contentStream);
            response = request.post(Entry.class);
            entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)artifactFileName, (Object)entry.getTitle());
            arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertTrue((boolean)(arty instanceof ExtendedDocument));
            doc = (ExtendedDocument)arty;
            Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
            Assert.assertEquals((Object)"BrmsPkgDocument", (Object)doc.getExtendedType());
            Assert.assertEquals((Object)17043L, (Object)Long.valueOf((String)doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_SIZE_QNAME)));
            Assert.assertEquals((Object)"application/octet-stream", doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_TYPE_QNAME));
            uuid = doc.getUuid();
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
        request = this.clientRequest("/s-ramp/ext/BrmsPkgDocument/" + uuid);
        response = request.get(Entry.class);
        entry = (Entry)response.getEntity();
        arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        Assert.assertTrue((boolean)(arty instanceof ExtendedDocument));
        doc = (ExtendedDocument)arty;
        Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
        Assert.assertEquals((Object)17043L, (Object)Long.valueOf((String)doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_SIZE_QNAME)));
        Assert.assertEquals((Object)"defaultPackage.pkg", (Object)doc.getName());
        Assert.assertEquals((Object)"application/octet-stream", doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_TYPE_QNAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJPGDocument() throws Exception {
        ExtendedDocument doc;
        BaseArtifactType arty;
        Entry entry;
        ClientResponse response;
        ClientRequest request;
        String artifactFileName = "photo.jpg";
        InputStream contentStream = this.getClass().getResourceAsStream("/sample-files/ext/" + artifactFileName);
        String uuid = null;
        try {
            request = this.clientRequest("/s-ramp/ext/JpgDocument");
            request.header("Slug", (Object)artifactFileName);
            request.body("application/octet-stream", (Object)contentStream);
            response = request.post(Entry.class);
            entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)artifactFileName, (Object)entry.getTitle());
            arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertTrue((boolean)(arty instanceof ExtendedDocument));
            doc = (ExtendedDocument)arty;
            Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
            Assert.assertEquals((Object)"JpgDocument", (Object)doc.getExtendedType());
            Assert.assertEquals((Object)2398L, (Object)Long.valueOf((String)doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_SIZE_QNAME)));
            Assert.assertEquals((Object)"image/jpeg", doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_TYPE_QNAME));
            uuid = doc.getUuid();
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
        request = this.clientRequest("/s-ramp/ext/JpgDocument/" + uuid);
        response = request.get(Entry.class);
        entry = (Entry)response.getEntity();
        arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        Assert.assertTrue((boolean)(arty instanceof ExtendedDocument));
        doc = (ExtendedDocument)arty;
        Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
        Assert.assertEquals((Object)2398L, (Object)Long.valueOf((String)doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_SIZE_QNAME)));
        Assert.assertEquals((Object)"photo.jpg", (Object)doc.getName());
        Assert.assertEquals((Object)"image/jpeg", doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_TYPE_QNAME));
        ClientRequest request2 = this.clientRequest("/s-ramp/ext/JpgDocument/" + uuid + "/media");
        ClientResponse response2 = request2.get(InputStream.class);
        if (response2.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
        }
        InputStream in = (InputStream)response2.getEntity();
        File file = new File("target/SRAMP-photo.jpg");
        FileOutputStream out = new FileOutputStream(file);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        out.flush();
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBpmnExtendedDocumentCreate() throws Exception {
        ExtendedDocument doc;
        BaseArtifactType arty;
        Entry entry;
        ClientResponse response;
        ClientRequest request;
        String artifactFileName = "Evaluation.bpmn";
        InputStream contentStream = this.getClass().getResourceAsStream("/sample-files/ext/" + artifactFileName);
        String uuid = null;
        try {
            request = this.clientRequest("/s-ramp/ext/BpmnDocument");
            request.header("Slug", (Object)artifactFileName);
            request.body("application/xml", (Object)contentStream);
            response = request.post(Entry.class);
            entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)artifactFileName, (Object)entry.getTitle());
            arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertTrue((boolean)(arty instanceof ExtendedDocument));
            doc = (ExtendedDocument)arty;
            Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
            Assert.assertEquals((Object)"BpmnDocument", (Object)doc.getExtendedType());
            long size = Long.valueOf((String)doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_SIZE_QNAME));
            Assert.assertTrue((size >= 12482L ? 1 : 0) != 0);
            Assert.assertEquals((Object)"application/xml", doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_TYPE_QNAME));
            uuid = doc.getUuid();
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
        request = this.clientRequest("/s-ramp/ext/BpmnDocument/" + uuid);
        response = request.get(Entry.class);
        entry = (Entry)response.getEntity();
        arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        Assert.assertTrue((boolean)(arty instanceof ExtendedDocument));
        doc = (ExtendedDocument)arty;
        Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
        Assert.assertEquals((Object)"Evaluation.bpmn", (Object)doc.getName());
        Assert.assertEquals((Object)"application/xml", doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_TYPE_QNAME));
        ClientResponse content = request.get(String.class);
        String c = (String)content.getEntity();
        Assert.assertNotNull((Object)c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWslaExtendedDocumentCreate() throws Exception {
        ExtendedDocument doc;
        BaseArtifactType arty;
        Entry entry;
        ClientResponse response;
        ClientRequest request;
        String artifactFileName = "Sample.wsla";
        InputStream contentStream = this.getClass().getResourceAsStream("/sample-files/ext/" + artifactFileName);
        String uuid = null;
        try {
            request = this.clientRequest("/s-ramp/ext/WslaDocument");
            request.header("Slug", (Object)artifactFileName);
            request.body("application/xml", (Object)contentStream);
            response = request.post(Entry.class);
            entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)artifactFileName, (Object)entry.getTitle());
            arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertTrue((boolean)(arty instanceof ExtendedDocument));
            doc = (ExtendedDocument)arty;
            Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
            Assert.assertEquals((Object)"WslaDocument", (Object)doc.getExtendedType());
            long size = Long.valueOf((String)doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_SIZE_QNAME));
            Assert.assertTrue((size >= 6556L ? 1 : 0) != 0);
            Assert.assertEquals((Object)"application/xml", doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_TYPE_QNAME));
            uuid = doc.getUuid();
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
        request = this.clientRequest("/s-ramp/ext/WslaDocument/" + uuid);
        response = request.get(Entry.class);
        entry = (Entry)response.getEntity();
        arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        Assert.assertTrue((boolean)(arty instanceof ExtendedDocument));
        doc = (ExtendedDocument)arty;
        Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
        Assert.assertEquals((Object)"Sample.wsla", (Object)doc.getName());
        Assert.assertEquals((Object)"application/xml", doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_TYPE_QNAME));
        ClientResponse content = request.get(String.class);
        String c = (String)content.getEntity();
        Assert.assertNotNull((Object)c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWsdlDocumentCreate() throws Exception {
        BaseArtifactType arty;
        Entry entry;
        ClientResponse response;
        String artifactFileName = "sample.wsdl";
        InputStream contentStream = this.getClass().getResourceAsStream("/sample-files/wsdl/" + artifactFileName);
        String uuid = null;
        ClientRequest request = null;
        try {
            request = this.clientRequest("/s-ramp/wsdl/WsdlDocument");
            request.header("Slug", (Object)artifactFileName);
            request.body("application/xml", (Object)contentStream);
            response = request.post(Entry.class);
            entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)artifactFileName, (Object)entry.getTitle());
            arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertTrue((boolean)(arty instanceof WsdlDocument));
            WsdlDocument doc = (WsdlDocument)arty;
            Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
            Long size = doc.getContentSize();
            Assert.assertTrue((size >= 1642L ? 1 : 0) != 0);
            Assert.assertEquals((Object)"application/xml", (Object)doc.getContentType());
            uuid = doc.getUuid();
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
        request = this.clientRequest("/s-ramp/wsdl/WsdlDocument/" + uuid);
        response = request.get(Entry.class);
        entry = (Entry)response.getEntity();
        arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        Assert.assertNotNull((Object)arty);
        Assert.assertTrue((boolean)(arty instanceof WsdlDocument));
        WsdlDocument wsdlDoc = (WsdlDocument)arty;
        Assert.assertEquals((Object)"sample.wsdl", (Object)wsdlDoc.getName());
        ClientRequest frequest = this.clientRequest("/s-ramp/wsdl/Message");
        ClientResponse fresponse = frequest.get(Feed.class);
        Feed feed = (Feed)fresponse.getEntity();
        Object totalResultsAttr = feed.getExtensionAttributes().get(SrampConstants.SRAMP_TOTAL_RESULTS_QNAME);
        int total = Integer.parseInt(String.valueOf(totalResultsAttr));
        Assert.assertNotNull((Object)feed);
        Assert.assertEquals((long)2L, (long)total);
        String findReqMsgUuid = null;
        for (Entry atomEntry : feed.getEntries()) {
            if (!"findRequest".equals(atomEntry.getTitle())) continue;
            findReqMsgUuid = atomEntry.getId().toString();
        }
        Assert.assertNotNull(findReqMsgUuid);
        request = this.clientRequest("/s-ramp/wsdl/Message/" + findReqMsgUuid);
        response = request.get(Entry.class);
        entry = (Entry)response.getEntity();
        arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        Assert.assertNotNull((Object)arty);
        Assert.assertTrue((boolean)(arty instanceof Message));
        Message message = (Message)arty;
        Assert.assertEquals((Object)"findRequest", (Object)message.getNCName());
        Assert.assertEquals((Object)"http://ewittman.redhat.com/sample/2012/09/wsdl/sample.wsdl", (Object)message.getNamespace());
        DocumentArtifactTarget relatedDocumentTarget = message.getRelatedDocument();
        Assert.assertEquals((Object)DocumentArtifactEnum.WSDL_DOCUMENT, (Object)relatedDocumentTarget.getArtifactType());
        Assert.assertEquals((Object)uuid, (Object)relatedDocumentTarget.getValue());
        List parts = message.getPart();
        Assert.assertNotNull((Object)parts);
        Assert.assertEquals((long)1L, (long)parts.size());
        Assert.assertEquals((Object)PartEnum.PART, (Object)((PartTarget)parts.get(0)).getArtifactType());
        Assert.assertNotNull((Object)((PartTarget)parts.get(0)).getValue());
    }

    @Test
    public void testMultiPartCreate() {
        String uuid = UUID.randomUUID().toString();
        try {
            ClientRequest request = this.clientRequest("/s-ramp/core/XmlDocument");
            MultipartRelatedOutput output = new MultipartRelatedOutput();
            XmlDocument xmlDocument = new XmlDocument();
            xmlDocument.setArtifactType(BaseArtifactEnum.XML_DOCUMENT);
            xmlDocument.setCreatedBy("kurt");
            xmlDocument.setDescription("In depth description of this XML document");
            xmlDocument.setName("PO.xml");
            xmlDocument.setUuid(uuid);
            xmlDocument.setVersion("1.0");
            Entry atomEntry = new Entry();
            Artifact arty = new Artifact();
            arty.setXmlDocument(xmlDocument);
            atomEntry.setAnyOtherJAXBObject((Object)arty);
            MediaType mediaType = new MediaType("application", "atom+xml");
            output.addPart((Object)atomEntry, (javax.ws.rs.core.MediaType)mediaType);
            String artifactFileName = "PO.xml";
            InputStream contentStream = this.getClass().getResourceAsStream("/sample-files/core/" + artifactFileName);
            MediaType mediaType2 = new MediaType("application", "xml");
            output.addPart((Object)contentStream, (javax.ws.rs.core.MediaType)mediaType2);
            request.body("multipart/related", (Object)output);
            ClientResponse response = request.post(Entry.class);
            Entry entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)artifactFileName, (Object)entry.getTitle());
            Artifact artifact = (Artifact)entry.getAnyOtherJAXBObject(Artifact.class, new Class[0]);
            Assert.assertEquals((Object)uuid, (Object)artifact.getXmlDocument().getUuid());
            Long size = artifact.getXmlDocument().getContentSize();
            Assert.assertTrue((size >= 825L ? 1 : 0) != 0);
            Assert.assertEquals((Object)artifactFileName, (Object)artifact.getXmlDocument().getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateNoSlug() throws Exception {
        String artifactFileName = "sample.wsdl";
        InputStream contentStream = this.getClass().getResourceAsStream("/sample-files/wsdl/" + artifactFileName);
        try {
            ClientRequest request = this.clientRequest("/s-ramp/wsdl/WsdlDocument");
            request.body("application/xml", (Object)contentStream);
            ClientResponse response = request.post(Entry.class);
            Entry entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)"newartifact.wsdl", (Object)entry.getTitle());
            BaseArtifactType arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertTrue((boolean)(arty instanceof WsdlDocument));
            WsdlDocument doc = (WsdlDocument)arty;
            Assert.assertEquals((Object)"newartifact.wsdl", (Object)doc.getName());
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArtifactDerivation() throws Exception {
        ClientResponse response;
        String artifactFileName = "PO.xsd";
        InputStream contentStream = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        ClientRequest request = null;
        try {
            request = this.clientRequest("/s-ramp/xsd/XsdDocument");
            request.body("application/xml", (Object)contentStream);
            response = request.post(Entry.class);
            response.getEntity();
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
        request = this.clientRequest("/s-ramp/xsd/ElementDeclaration");
        response = request.get(Feed.class);
        Feed feed = (Feed)response.getEntity();
        Object totalResultsAttr = feed.getExtensionAttributes().get(SrampConstants.SRAMP_TOTAL_RESULTS_QNAME);
        int total = Integer.parseInt(String.valueOf(totalResultsAttr));
        Assert.assertEquals((long)2L, (long)total);
    }

    @Test
    public void testFullPurchaseOrderXSD() throws Exception {
        Entry entry = this.doAddXsd();
        URI entryId = entry.getId();
        entry = this.doGetXsdEntry(entryId);
        String content = this.doGetXsdContent(entryId);
        this.verifyXsdContent(content);
        this.doUpdateXsdEntry(entry);
        entry = this.doGetXsdEntry(entryId);
        this.verifyEntryUpdated(entry);
        this.doUpdateXsdContent(entry);
        content = this.doGetXsdContent(entryId);
        this.verifyContentUpdated(content);
        this.deleteXsdEntry(entryId);
        this.verifyEntryDeleted(entryId);
    }

    private Entry doAddXsd() throws Exception {
        ClientRequest request = this.clientRequest("/s-ramp/xsd/XsdDocument");
        String artifactFileName = "PO.xsd";
        InputStream POXsd = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        String xmltext = TestUtils.convertStreamToString(POXsd);
        POXsd.close();
        request.header("Slug", (Object)artifactFileName);
        request.body("application/xml", (Object)xmltext);
        ClientResponse response = request.post(Entry.class);
        Entry entry = (Entry)response.getEntity();
        Assert.assertEquals((Object)artifactFileName, (Object)entry.getTitle());
        Artifact artifact = (Artifact)entry.getAnyOtherJAXBObject(Artifact.class, new Class[0]);
        Long size = artifact.getXsdDocument().getContentSize();
        Assert.assertTrue((size >= 2376L ? 1 : 0) != 0);
        Assert.assertEquals((Object)artifactFileName, (Object)artifact.getXsdDocument().getName());
        return entry;
    }

    private Entry doGetXsdEntry(URI entryId) throws Exception {
        String uuid = entryId.toString();
        ClientRequest request = this.clientRequest("/s-ramp/xsd/XsdDocument/" + uuid);
        ClientResponse response = request.get(Entry.class);
        Entry entry = (Entry)response.getEntity();
        Artifact artifact = (Artifact)entry.getAnyOtherJAXBObject(Artifact.class, new Class[0]);
        Assert.assertNotNull((Object)artifact.getXsdDocument());
        return entry;
    }

    private String doGetXsdContent(URI entryId) throws Exception {
        String uuid = entryId.toString();
        ClientRequest request = this.clientRequest("/s-ramp/xsd/XsdDocument/" + uuid + "/media");
        ClientResponse response = request.get(String.class);
        return (String)response.getEntity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyXsdContent(String content) throws IOException {
        Assert.assertNotNull((Object)content);
        String artifactFileName = "PO.xsd";
        InputStream POXsd = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            String expectedContent = TestUtils.convertStreamToString(POXsd);
            Assert.assertEquals((Object)expectedContent, (Object)content);
        }
        finally {
            POXsd.close();
        }
    }

    private void doUpdateXsdEntry(Entry entry) throws Exception {
        XsdDocument xsdDocument = (XsdDocument)SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        String uuid = xsdDocument.getUuid();
        xsdDocument.setDescription("** Updated description! **");
        SrampModelUtils.setCustomProperty((BaseArtifactType)xsdDocument, (String)"my.property", (String)"Hello World");
        SrampModelUtils.addGenericRelationship((BaseArtifactType)xsdDocument, (String)"NoTargetRel", null);
        Artifact arty = new Artifact();
        arty.setXsdDocument(xsdDocument);
        entry.setAnyOtherJAXBObject((Object)arty);
        ClientRequest request = this.clientRequest("/s-ramp/xsd/XsdDocument/" + uuid);
        request.body("application/atom+xml;type=entry", (Object)entry);
        request.put(Void.class);
    }

    private void verifyEntryUpdated(Entry entry) throws Exception {
        Artifact srampArtifactWrapper = (Artifact)entry.getAnyOtherJAXBObject(Artifact.class, new Class[0]);
        XsdDocument xsdDocument = srampArtifactWrapper.getXsdDocument();
        Assert.assertEquals((Object)"** Updated description! **", (Object)xsdDocument.getDescription());
        Assert.assertEquals((Object)"Hello World", (Object)SrampModelUtils.getCustomProperty((BaseArtifactType)xsdDocument, (String)"my.property"));
        Assert.assertNull((Object)SrampModelUtils.getCustomProperty((BaseArtifactType)xsdDocument, (String)"my.missing.property"));
        Assert.assertNotNull((Object)SrampModelUtils.getGenericRelationship((BaseArtifactType)xsdDocument, (String)"NoTargetRel"));
        Assert.assertNull((Object)SrampModelUtils.getGenericRelationship((BaseArtifactType)xsdDocument, (String)"MissingRel"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateXsdContent(Entry entry) throws Exception {
        XsdDocument xsdDocument = (XsdDocument)SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        String uuid = xsdDocument.getUuid();
        ClientRequest request = this.clientRequest("/s-ramp/xsd/XsdDocument/" + uuid + "/media");
        String artifactFileName = "PO-updated.xsd";
        InputStream xsdStream = null;
        try {
            xsdStream = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
            request.body("application/xml", (Object)xsdStream);
            request.put(Void.class);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(xsdStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)xsdStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyContentUpdated(String content) throws IOException {
        Assert.assertNotNull((Object)content);
        InputStream xsdStream = this.getClass().getResourceAsStream("/sample-files/xsd/PO-updated.xsd");
        try {
            String expectedContent = TestUtils.convertStreamToString(xsdStream);
            Assert.assertEquals((Object)expectedContent, (Object)content);
        }
        finally {
            xsdStream.close();
        }
    }

    private void deleteXsdEntry(URI entryId) throws Exception {
        String uuid = entryId.toString();
        ClientRequest request = this.clientRequest("/s-ramp/xsd/XsdDocument/" + uuid);
        request.delete(Void.class);
    }

    private void verifyEntryDeleted(URI entryId) throws Exception {
        String uuid = entryId.toString();
        ClientRequest request = this.clientRequest("/s-ramp/xsd/XsdDocument/" + uuid);
        try {
            request.get(String.class);
            Assert.fail((String)"Expected an 'Artifact not found.' error here.");
        }
        catch (SrampAtomException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("No artifact found with UUID:"));
        }
    }
}

