/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.test.server.atom.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInput;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XmlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocument;
import org.overlord.sramp.atom.SrampAtomUtils;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.beans.HttpResponseBean;
import org.overlord.sramp.atom.client.ClientRequest;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.test.server.atom.services.AbstractNoAuditingResourceTest;

public class BatchResourceTest
extends AbstractNoAuditingResourceTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZipPackage() throws Exception {
        SrampArchive archive = null;
        InputStream xsd1ContentStream = null;
        InputStream xsd2ContentStream = null;
        File zipFile = null;
        FileInputStream zipStream = null;
        ClientRequest request = null;
        try {
            archive = new SrampArchive();
            xsd1ContentStream = this.getClass().getResourceAsStream("/sample-files/xsd/PO.xsd");
            XsdDocument metaData = new XsdDocument();
            metaData.setArtifactType(BaseArtifactEnum.XSD_DOCUMENT);
            metaData.setName("PO.xsd");
            archive.addEntry("schemas/PO.xsd", (BaseArtifactType)metaData, xsd1ContentStream);
            xsd2ContentStream = this.getClass().getResourceAsStream("/sample-files/xsd/XMLSchema.xsd");
            metaData = new XsdDocument();
            metaData.setArtifactType(BaseArtifactEnum.XSD_DOCUMENT);
            metaData.setName("XMLSchema.xsd");
            metaData.setVersion("1.0");
            archive.addEntry("schemas/XMLSchema.xsd", (BaseArtifactType)metaData, xsd2ContentStream);
            zipFile = archive.pack();
            zipStream = FileUtils.openInputStream((File)zipFile);
            request = this.clientRequest("/s-ramp");
            request.body("application/zip", (Object)zipStream);
            ClientResponse clientResponse = request.post(MultipartInput.class);
            MultipartInput response = (MultipartInput)clientResponse.getEntity();
            List parts = response.getParts();
            HashMap<String, BaseArtifactType> artyMap = new HashMap<String, BaseArtifactType>();
            for (InputPart part : parts) {
                String id = (String)part.getHeaders().getFirst((Object)"Content-ID");
                HttpResponseBean rbean = (HttpResponseBean)part.getBody(HttpResponseBean.class, null);
                Assert.assertEquals((long)201L, (long)rbean.getCode());
                Entry entry = (Entry)rbean.getBody();
                BaseArtifactType artifact = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
                artyMap.put(id, artifact);
            }
            Assert.assertTrue((boolean)artyMap.keySet().contains("<schemas/PO.xsd@package>"));
            Assert.assertTrue((boolean)artyMap.keySet().contains("<schemas/XMLSchema.xsd@package>"));
            BaseArtifactType arty = (BaseArtifactType)artyMap.get("<schemas/PO.xsd@package>");
            Assert.assertNotNull((Object)arty);
            Assert.assertEquals((Object)"PO.xsd", (Object)arty.getName());
            Assert.assertNull((Object)arty.getVersion());
            arty = (BaseArtifactType)artyMap.get("<schemas/XMLSchema.xsd@package>");
            Assert.assertNotNull((Object)arty);
            Assert.assertEquals((Object)"XMLSchema.xsd", (Object)arty.getName());
            Assert.assertEquals((Object)"1.0", (Object)arty.getVersion());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(xsd1ContentStream);
            IOUtils.closeQuietly(xsd2ContentStream);
            SrampArchive.closeQuietly((SrampArchive)archive);
            IOUtils.closeQuietly(zipStream);
            FileUtils.deleteQuietly(zipFile);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)xsd1ContentStream);
        IOUtils.closeQuietly((InputStream)xsd2ContentStream);
        SrampArchive.closeQuietly((SrampArchive)archive);
        IOUtils.closeQuietly((InputStream)zipStream);
        FileUtils.deleteQuietly((File)zipFile);
        request = this.clientRequest("/s-ramp/xsd/XsdDocument");
        ClientResponse response = request.get(Feed.class);
        Feed feed = (Feed)response.getEntity();
        Assert.assertEquals((long)2L, (long)feed.getEntries().size());
        HashSet<String> artyNames = new HashSet<String>();
        for (Entry entry : feed.getEntries()) {
            artyNames.add(entry.getTitle());
        }
        Assert.assertTrue((boolean)artyNames.contains("PO.xsd"));
        Assert.assertTrue((boolean)artyNames.contains("XMLSchema.xsd"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZipPackage_Multi() throws Exception {
        BaseArtifactType artifact;
        SrampArchive archive = null;
        InputStream xsd1ContentStream = null;
        InputStream wsdlContentStream = null;
        File zipFile = null;
        FileInputStream zipStream = null;
        ClientRequest request = null;
        WsdlDocument wsdlDoc = this.createWsdlArtifact();
        XmlDocument xmlDoc = this.createXmlArtifact();
        String xsdUuid = null;
        String wsdlUuid = null;
        String xmlUuid = null;
        try {
            archive = new SrampArchive();
            xsd1ContentStream = this.getClass().getResourceAsStream("/sample-files/xsd/PO.xsd");
            XsdDocument metaData = new XsdDocument();
            metaData.setArtifactType(BaseArtifactEnum.XSD_DOCUMENT);
            metaData.setUuid(UUID.randomUUID().toString());
            metaData.setName("PO.xsd");
            archive.addEntry("schemas/PO.xsd", (BaseArtifactType)metaData, xsd1ContentStream);
            wsdlContentStream = this.getClass().getResourceAsStream("/sample-files/wsdl/sample-updated.wsdl");
            metaData = wsdlDoc;
            metaData.setVersion("2.0");
            SrampModelUtils.setCustomProperty((BaseArtifactType)metaData, (String)"foo", (String)"bar");
            archive.addEntry("wsdl/sample.wsdl", (BaseArtifactType)metaData, wsdlContentStream);
            metaData = xmlDoc;
            metaData.setVersion("3.0");
            SrampModelUtils.setCustomProperty((BaseArtifactType)metaData, (String)"far", (String)"baz");
            archive.addEntry("core/PO.xml", (BaseArtifactType)metaData, null);
            zipFile = archive.pack();
            zipStream = FileUtils.openInputStream((File)zipFile);
            request = this.clientRequest("/s-ramp");
            request.body("application/zip", (Object)zipStream);
            ClientResponse clientResponse = request.post(MultipartInput.class);
            MultipartInput response = (MultipartInput)clientResponse.getEntity();
            List parts = response.getParts();
            HashMap<String, HttpResponseBean> respMap = new HashMap<String, HttpResponseBean>();
            for (InputPart part : parts) {
                String id = (String)part.getHeaders().getFirst((Object)"Content-ID");
                HttpResponseBean rbean = (HttpResponseBean)part.getBody(HttpResponseBean.class, null);
                respMap.put(id, rbean);
            }
            Assert.assertEquals((long)3L, (long)respMap.size());
            Assert.assertTrue((boolean)respMap.keySet().contains("<schemas/PO.xsd@package>"));
            Assert.assertTrue((boolean)respMap.keySet().contains("<wsdl/sample.wsdl@package>"));
            Assert.assertTrue((boolean)respMap.keySet().contains("<core/PO.xml@package>"));
            HttpResponseBean httpResp = (HttpResponseBean)respMap.get("<schemas/PO.xsd@package>");
            Assert.assertEquals((long)201L, (long)httpResp.getCode());
            Assert.assertEquals((Object)"Created", (Object)httpResp.getStatus());
            Entry entry = (Entry)httpResp.getBody();
            BaseArtifactType artifact2 = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertEquals((Object)"PO.xsd", (Object)artifact2.getName());
            Assert.assertNull((Object)artifact2.getVersion());
            Long size = ((XsdDocument)artifact2).getContentSize();
            Assert.assertTrue((size >= 2376L ? 1 : 0) != 0);
            xsdUuid = artifact2.getUuid();
            httpResp = (HttpResponseBean)respMap.get("<wsdl/sample.wsdl@package>");
            Assert.assertEquals((long)200L, (long)httpResp.getCode());
            Assert.assertEquals((Object)"OK", (Object)httpResp.getStatus());
            entry = (Entry)httpResp.getBody();
            artifact2 = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertEquals((Object)"sample.wsdl", (Object)artifact2.getName());
            Assert.assertEquals((Object)"2.0", (Object)artifact2.getVersion());
            wsdlUuid = artifact2.getUuid();
            httpResp = (HttpResponseBean)respMap.get("<core/PO.xml@package>");
            Assert.assertEquals((long)200L, (long)httpResp.getCode());
            Assert.assertEquals((Object)"OK", (Object)httpResp.getStatus());
            entry = (Entry)httpResp.getBody();
            artifact2 = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertEquals((Object)"PO.xml", (Object)artifact2.getName());
            Assert.assertEquals((Object)"3.0", (Object)artifact2.getVersion());
            xmlUuid = artifact2.getUuid();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(xsd1ContentStream);
            IOUtils.closeQuietly(wsdlContentStream);
            SrampArchive.closeQuietly((SrampArchive)archive);
            IOUtils.closeQuietly(zipStream);
            FileUtils.deleteQuietly(zipFile);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)xsd1ContentStream);
        IOUtils.closeQuietly((InputStream)wsdlContentStream);
        SrampArchive.closeQuietly((SrampArchive)archive);
        IOUtils.closeQuietly((InputStream)zipStream);
        FileUtils.deleteQuietly((File)zipFile);
        HashMap<String, BaseArtifactType> artyMap = new HashMap<String, BaseArtifactType>();
        request = this.clientRequest("/s-ramp/xsd/XsdDocument");
        ClientResponse response = request.get(Feed.class);
        Feed feed = (Feed)response.getEntity();
        Assert.assertEquals((long)1L, (long)feed.getEntries().size());
        for (Entry entry : feed.getEntries()) {
            request = this.clientRequest("/s-ramp/xsd/XsdDocument/" + entry.getId().toString());
            artifact = SrampAtomUtils.unwrapSrampArtifact((Entry)((Entry)request.get(Entry.class).getEntity()));
            artyMap.put(artifact.getUuid(), artifact);
        }
        request = this.clientRequest("/s-ramp/wsdl/WsdlDocument");
        response = request.get(Feed.class);
        feed = (Feed)response.getEntity();
        Assert.assertEquals((long)1L, (long)feed.getEntries().size());
        for (Entry entry : feed.getEntries()) {
            request = this.clientRequest("/s-ramp/wsdl/WsdlDocument/" + entry.getId().toString());
            artifact = SrampAtomUtils.unwrapSrampArtifact((Entry)((Entry)request.get(Entry.class).getEntity()));
            artyMap.put(artifact.getUuid(), artifact);
        }
        request = this.clientRequest("/s-ramp/core/XmlDocument");
        response = request.get(Feed.class);
        feed = (Feed)response.getEntity();
        Assert.assertEquals((long)1L, (long)feed.getEntries().size());
        for (Entry entry : feed.getEntries()) {
            request = this.clientRequest("/s-ramp/core/XmlDocument/" + entry.getId().toString());
            artifact = SrampAtomUtils.unwrapSrampArtifact((Entry)((Entry)request.get(Entry.class).getEntity()));
            artyMap.put(artifact.getUuid(), artifact);
        }
        Assert.assertEquals((long)3L, (long)artyMap.size());
        BaseArtifactType artifact3 = (BaseArtifactType)artyMap.get(xsdUuid);
        Assert.assertEquals((Object)"PO.xsd", (Object)artifact3.getName());
        Assert.assertNull((Object)artifact3.getVersion());
        artifact3 = (BaseArtifactType)artyMap.get(wsdlUuid);
        Assert.assertEquals((Object)"sample.wsdl", (Object)artifact3.getName());
        Assert.assertEquals((Object)"2.0", (Object)artifact3.getVersion());
        artifact3 = (BaseArtifactType)artyMap.get(xmlUuid);
        Assert.assertEquals((Object)"PO.xml", (Object)artifact3.getName());
        Assert.assertEquals((Object)"3.0", (Object)artifact3.getVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlDocument createXmlArtifact() throws Exception {
        String artifactFileName = "PO.xml";
        InputStream contentStream = this.getClass().getResourceAsStream("/sample-files/core/" + artifactFileName);
        try {
            ClientRequest request = this.clientRequest("/s-ramp/core/XmlDocument");
            request.header("Slug", (Object)artifactFileName);
            request.body("application/xml", (Object)contentStream);
            ClientResponse response = request.post(Entry.class);
            Entry entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)artifactFileName, (Object)entry.getTitle());
            BaseArtifactType arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertTrue((boolean)(arty instanceof XmlDocument));
            XmlDocument doc = (XmlDocument)arty;
            Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
            Long size = doc.getContentSize();
            Assert.assertTrue((size >= 825L ? 1 : 0) != 0);
            Assert.assertEquals((Object)"application/xml", (Object)doc.getContentType());
            XmlDocument xmlDocument = doc;
            return xmlDocument;
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WsdlDocument createWsdlArtifact() throws Exception {
        String artifactFileName = "sample.wsdl";
        InputStream contentStream = this.getClass().getResourceAsStream("/sample-files/wsdl/" + artifactFileName);
        try {
            ClientRequest request = this.clientRequest("/s-ramp/wsdl/WsdlDocument");
            request.header("Slug", (Object)artifactFileName);
            request.body("application/xml", (Object)contentStream);
            ClientResponse response = request.post(Entry.class);
            Entry entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)artifactFileName, (Object)entry.getTitle());
            BaseArtifactType arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertTrue((boolean)(arty instanceof WsdlDocument));
            WsdlDocument doc = (WsdlDocument)arty;
            Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
            Assert.assertEquals((Object)"application/xml", (Object)doc.getContentType());
            WsdlDocument wsdlDocument = doc;
            return wsdlDocument;
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
    }
}

