/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.test.server.atom.services;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Artifact;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Property;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocument;
import org.overlord.sramp.atom.client.ClientRequest;
import org.overlord.sramp.test.TestUtils;
import org.overlord.sramp.test.server.atom.services.AbstractNoAuditingResourceTest;

public class FeedResourceTest
extends AbstractNoAuditingResourceTest {
    @Test
    public void testArtifactFeed() throws Exception {
        int numEntries = 10;
        HashSet<String> uuids = new HashSet<String>();
        for (int i = 0; i < numEntries; ++i) {
            Entry entry = this.doAddXsd(new String[0]);
            URI entryId = entry.getId();
            String uuid = entryId.toString();
            uuids.add(uuid);
        }
        ClientRequest request = this.clientRequest("/s-ramp/xsd/XsdDocument");
        ClientResponse response = request.get(Feed.class);
        Feed feed = (Feed)response.getEntity();
        int uuidsFound = 0;
        for (Entry entry : feed.getEntries()) {
            String entryUuid = entry.getId().toString();
            if (!uuids.contains(entryUuid)) continue;
            ++uuidsFound;
        }
        Assert.assertEquals((long)numEntries, (long)uuidsFound);
        request = this.clientRequest("/s-ramp/xsd/XsdDocument?startPage=2&count=2");
        response = request.get(Feed.class);
        feed = (Feed)response.getEntity();
        Assert.assertTrue((String)"Expected 2 entries.", (feed.getEntries().size() == 2 ? 1 : 0) != 0);
    }

    private Entry doAddXsd(String ... properties) throws Exception {
        ClientRequest request = this.clientRequest("/s-ramp/xsd/XsdDocument");
        String artifactFileName = "PO.xsd";
        InputStream POXsd = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        String xmltext = TestUtils.convertStreamToString(POXsd);
        POXsd.close();
        request.header("Slug", (Object)artifactFileName);
        request.body("application/xml", (Object)xmltext);
        ClientResponse response = request.post(Entry.class);
        Entry entry = (Entry)response.getEntity();
        if (properties.length > 0) {
            Artifact srampArtifactWrapper = (Artifact)entry.getAnyOtherJAXBObject(Artifact.class, new Class[0]);
            XsdDocument xsdDocument = srampArtifactWrapper.getXsdDocument();
            for (int i = 0; i < properties.length; i += 2) {
                String propname = properties[i];
                String propvalue = properties[i + 1];
                Property prop = new Property();
                prop.setPropertyName(propname);
                prop.setPropertyValue(propvalue);
                xsdDocument.getProperty().add(prop);
            }
            String uuid = xsdDocument.getUuid();
            entry.setAnyOtherJAXBObject((Object)srampArtifactWrapper);
            request = this.clientRequest("/s-ramp/xsd/XsdDocument/" + uuid);
            request.body("application/atom+xml;type=entry", (Object)entry);
            request.put(Void.class);
        }
        return entry;
    }

    @Test
    public void testExtendedTypeFeed() throws Exception {
        String entryUuid;
        HashSet<String> pkgUuids = new HashSet<String>();
        for (int i = 0; i < 5; ++i) {
            Entry entry = this.doAddExtended("PkgDocument", "/sample-files/ext/defaultPackage.pkg");
            URI entryId = entry.getId();
            String uuid = entryId.toString();
            pkgUuids.add(uuid);
        }
        HashSet<String> bpmnUuids = new HashSet<String>();
        for (int i = 0; i < 3; ++i) {
            Entry entry = this.doAddExtended("BpmnDocument", "/sample-files/ext/Evaluation.bpmn");
            URI entryId = entry.getId();
            String uuid = entryId.toString();
            bpmnUuids.add(uuid);
        }
        ClientRequest request = this.clientRequest("/s-ramp/ext/PkgDocument");
        ClientResponse response = request.get(Feed.class);
        Feed feed = (Feed)response.getEntity();
        for (Entry entry : feed.getEntries()) {
            entryUuid = entry.getId().toString();
            pkgUuids.remove(entryUuid);
        }
        Assert.assertEquals((String)"The feed did not contain the expected PkgDocument entries.", (long)0L, (long)pkgUuids.size());
        request = this.clientRequest("/s-ramp/ext/BpmnDocument");
        response = request.get(Feed.class);
        feed = (Feed)response.getEntity();
        for (Entry entry : feed.getEntries()) {
            entryUuid = entry.getId().toString();
            bpmnUuids.remove(entryUuid);
        }
        Assert.assertEquals((String)"The feed did not contain the expected BpmnDocument entries.", (long)0L, (long)pkgUuids.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry doAddExtended(String extendedType, String testFilePath) throws Exception {
        ClientRequest request = this.clientRequest("/s-ramp/ext/" + extendedType);
        File f = new File(testFilePath);
        String artifactFileName = f.getName();
        InputStream contentStream = this.getClass().getResourceAsStream(testFilePath);
        if (contentStream == null) {
            throw new NullPointerException("Failed to find: " + testFilePath);
        }
        try {
            Entry entry;
            request.header("Slug", (Object)artifactFileName);
            request.body("application/octet-stream", (Object)contentStream);
            ClientResponse response = request.post(Entry.class);
            Entry entry2 = entry = (Entry)response.getEntity();
            return entry2;
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
    }

    @Test
    public void testModelFeed() throws Exception {
        HashSet<String> xsdUuids = new HashSet<String>();
        for (int i = 0; i < 5; ++i) {
            Entry entry = this.doAddXsd(new String[0]);
            URI entryId = entry.getId();
            String uuid = entryId.toString();
            xsdUuids.add(uuid);
        }
        HashSet<String> pkgUuids = new HashSet<String>();
        for (int i = 0; i < 5; ++i) {
            Entry entry = this.doAddExtended("PkgDocument", "/sample-files/ext/defaultPackage.pkg");
            URI entryId = entry.getId();
            String uuid = entryId.toString();
            pkgUuids.add(uuid);
        }
        HashSet<String> bpmnUuids = new HashSet<String>();
        for (int i = 0; i < 3; ++i) {
            Entry entry = this.doAddExtended("BpmnDocument", "/sample-files/ext/Evaluation.bpmn");
            URI entryId = entry.getId();
            String uuid = entryId.toString();
            bpmnUuids.add(uuid);
        }
        ClientRequest request = this.clientRequest("/s-ramp/ext");
        ClientResponse response = request.get(Feed.class);
        Feed feed = (Feed)response.getEntity();
        int uuidsFound = 0;
        for (Entry entry : feed.getEntries()) {
            String entryUuid = entry.getId().toString();
            if (!pkgUuids.contains(entryUuid) && !bpmnUuids.contains(entryUuid)) continue;
            ++uuidsFound;
        }
        Assert.assertEquals((long)8L, (long)uuidsFound);
        request = this.clientRequest("/s-ramp/xsd?startPage=1&count=2");
        response = request.get(Feed.class);
        feed = (Feed)response.getEntity();
        Assert.assertTrue((String)"Expected 2 entries.", (feed.getEntries().size() == 2 ? 1 : 0) != 0);
    }
}

