/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.test.server.atom.services;

import java.io.InputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Artifact;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Property;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocument;
import org.overlord.sramp.atom.MediaType;
import org.overlord.sramp.atom.SrampAtomUtils;
import org.overlord.sramp.atom.client.ClientRequest;
import org.overlord.sramp.common.SrampConstants;
import org.overlord.sramp.test.TestUtils;
import org.overlord.sramp.test.server.atom.services.AbstractNoAuditingResourceTest;

public class QueryResourceTest
extends AbstractNoAuditingResourceTest {
    @Test
    public void testQueries() throws Exception {
        int numEntries = 10;
        HashSet<String> uuids = new HashSet<String>();
        for (int i = 0; i < numEntries; ++i) {
            Entry entry = this.doAddXsd(new String[0]);
            URI entryId = entry.getId();
            String uuid = entryId.toString();
            uuids.add(uuid);
        }
        ClientRequest request = this.clientRequest("/s-ramp?query=xsd/XsdDocument");
        ClientResponse response = request.get(Feed.class);
        Feed feed = (Feed)response.getEntity();
        int uuidsFound = 0;
        for (Entry entry : feed.getEntries()) {
            String entryUuid = entry.getId().toString();
            if (!uuids.contains(entryUuid)) continue;
            ++uuidsFound;
        }
        Assert.assertEquals((long)numEntries, (long)uuidsFound);
        request = this.clientRequest("/s-ramp");
        MultipartFormDataOutput formData = new MultipartFormDataOutput();
        formData.addFormData("query", (Object)"xsd/XsdDocument", MediaType.TEXT_PLAIN_TYPE);
        request.body(MediaType.MULTIPART_FORM_DATA_TYPE, (Object)formData);
        response = request.post(Feed.class);
        feed = (Feed)response.getEntity();
        uuidsFound = 0;
        for (Entry entry : feed.getEntries()) {
            String entryUuid = entry.getId().toString();
            if (!uuids.contains(entryUuid)) continue;
            ++uuidsFound;
        }
        Assert.assertEquals((long)numEntries, (long)uuidsFound);
        String stampVal = UUID.randomUUID().toString();
        HashSet<String> allTidxVals = new HashSet<String>();
        for (int i = 0; i < 5; ++i) {
            String propname = "tidx";
            String propval = String.valueOf(i);
            this.doAddXsd("foo", "bar", "stamp", stampVal, propname, propval);
            allTidxVals.add(propval);
        }
        String query = String.format("xsd/XsdDocument[@stamp%%3D'%1$s']", stampVal);
        request = this.clientRequest("/s-ramp?query=" + query);
        response = request.get(Feed.class);
        feed = (Feed)response.getEntity();
        Assert.assertEquals((long)5L, (long)feed.getEntries().size());
        query = String.format("xsd/XsdDocument[@stamp%%3D'%1$s']", stampVal);
        request = this.clientRequest("/s-ramp?startIndex=0&count=2&query=" + query);
        response = request.get(Feed.class);
        feed = (Feed)response.getEntity();
        Assert.assertEquals((long)2L, (long)feed.getEntries().size());
        query = String.format("xsd/XsdDocument[@stamp%%3D'%1$s']", stampVal);
        request = this.clientRequest("/s-ramp?propertyName=tidx&propertyName=stamp&query=" + query);
        response = request.get(Feed.class);
        feed = (Feed)response.getEntity();
        Assert.assertEquals((long)5L, (long)feed.getEntries().size());
        HashSet<String> actualTidxVals = new HashSet<String>();
        for (Entry entry : feed.getEntries()) {
            Artifact arty = (Artifact)entry.getAnyOtherJAXBObject(Artifact.class, new Class[0]);
            if (arty == null) continue;
            XsdDocument xsdDoc = arty.getXsdDocument();
            List properties = xsdDoc.getProperty();
            for (Property prop : properties) {
                if (!"tidx".equals(prop.getPropertyName())) continue;
                actualTidxVals.add(prop.getPropertyValue());
            }
        }
        Assert.assertEquals(allTidxVals, actualTidxVals);
    }

    @Test
    public void testSearchResultAttributes() throws Exception {
        int numEntries = 20;
        for (int i = 0; i < numEntries; ++i) {
            this.addJpegDocument("photo" + i + ".jpg");
        }
        ClientRequest request = this.clientRequest("/s-ramp?query=ext");
        ClientResponse response = request.get(Feed.class);
        Feed feed = (Feed)response.getEntity();
        Object startIndexAttr = feed.getExtensionAttributes().get(SrampConstants.SRAMP_START_INDEX_QNAME);
        Object itemsPerPageAttr = feed.getExtensionAttributes().get(SrampConstants.SRAMP_ITEMS_PER_PAGE_QNAME);
        Object totalResultsAttr = feed.getExtensionAttributes().get(SrampConstants.SRAMP_TOTAL_RESULTS_QNAME);
        Assert.assertNotNull((String)"The startIndex attribute wasn't returned!", startIndexAttr);
        Assert.assertNotNull((String)"The itemsPerPage attribute wasn't returned!", itemsPerPageAttr);
        Assert.assertNotNull((String)"The totalResults attribute wasn't returned!", totalResultsAttr);
        int startIndex = Integer.parseInt(String.valueOf(startIndexAttr));
        int itemsPerPage = Integer.parseInt(String.valueOf(itemsPerPageAttr));
        int totalResults = Integer.parseInt(String.valueOf(totalResultsAttr));
        Assert.assertEquals((long)0L, (long)startIndex);
        Assert.assertEquals((long)100L, (long)itemsPerPage);
        Assert.assertEquals((long)20L, (long)totalResults);
        request = this.clientRequest("/s-ramp?query=ext&startIndex=5&count=2");
        response = request.get(Feed.class);
        feed = (Feed)response.getEntity();
        startIndexAttr = feed.getExtensionAttributes().get(SrampConstants.SRAMP_START_INDEX_QNAME);
        itemsPerPageAttr = feed.getExtensionAttributes().get(SrampConstants.SRAMP_ITEMS_PER_PAGE_QNAME);
        totalResultsAttr = feed.getExtensionAttributes().get(SrampConstants.SRAMP_TOTAL_RESULTS_QNAME);
        Assert.assertNotNull((String)"The startIndex attribute wasn't returned!", startIndexAttr);
        Assert.assertNotNull((String)"The itemsPerPage attribute wasn't returned!", itemsPerPageAttr);
        Assert.assertNotNull((String)"The totalResults attribute wasn't returned!", totalResultsAttr);
        startIndex = Integer.parseInt(String.valueOf(startIndexAttr));
        itemsPerPage = Integer.parseInt(String.valueOf(itemsPerPageAttr));
        totalResults = Integer.parseInt(String.valueOf(totalResultsAttr));
        Assert.assertEquals((long)5L, (long)startIndex);
        Assert.assertEquals((long)2L, (long)itemsPerPage);
        Assert.assertEquals((long)20L, (long)totalResults);
    }

    private Entry doAddXsd(String ... properties) throws Exception {
        ClientRequest request = this.clientRequest("/s-ramp/xsd/XsdDocument");
        String artifactFileName = "PO.xsd";
        InputStream POXsd = this.getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        String xmltext = TestUtils.convertStreamToString(POXsd);
        POXsd.close();
        request.header("Slug", (Object)artifactFileName);
        request.body("application/xml", (Object)xmltext);
        ClientResponse response = request.post(Entry.class);
        Entry entry = (Entry)response.getEntity();
        if (properties.length > 0) {
            Artifact srampArtifactWrapper = (Artifact)entry.getAnyOtherJAXBObject(Artifact.class, new Class[0]);
            XsdDocument xsdDocument = srampArtifactWrapper.getXsdDocument();
            for (int i = 0; i < properties.length; i += 2) {
                String propname = properties[i];
                String propvalue = properties[i + 1];
                Property prop = new Property();
                prop.setPropertyName(propname);
                prop.setPropertyValue(propvalue);
                xsdDocument.getProperty().add(prop);
            }
            String uuid = xsdDocument.getUuid();
            entry.setAnyOtherJAXBObject((Object)srampArtifactWrapper);
            request = this.clientRequest("/s-ramp/xsd/XsdDocument/" + uuid);
            request.body("application/atom+xml;type=entry", (Object)entry);
            request.put(Void.class);
        }
        return entry;
    }

    @Test
    public void testQueriesExtended() throws Exception {
        this.addJpegDocument("photo1.jpg");
        this.addJpegDocument("photo2.jpg");
        ClientRequest request = this.clientRequest("/s-ramp?query=ext/JpgDocument");
        ClientResponse response = request.get(Feed.class);
        Feed feed = (Feed)response.getEntity();
        Object totalResultsAttr = feed.getExtensionAttributes().get(SrampConstants.SRAMP_TOTAL_RESULTS_QNAME);
        int total = Integer.parseInt(String.valueOf(totalResultsAttr));
        Assert.assertEquals((long)2L, (long)total);
        request = this.clientRequest("/s-ramp/ext/JpgDocument");
        response = request.get(Feed.class);
        feed = (Feed)response.getEntity();
        totalResultsAttr = feed.getExtensionAttributes().get(SrampConstants.SRAMP_TOTAL_RESULTS_QNAME);
        total = Integer.parseInt(String.valueOf(totalResultsAttr));
        Assert.assertEquals((long)2L, (long)total);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJpegDocument(String fname) throws Exception {
        String artifactFileName = "photo.jpg";
        InputStream contentStream = this.getClass().getResourceAsStream("/sample-files/ext/" + artifactFileName);
        try {
            ClientRequest request = this.clientRequest("/s-ramp/ext/JpgDocument");
            request.header("Slug", (Object)fname);
            request.body("application/octet-stream", (Object)contentStream);
            ClientResponse response = request.post(Entry.class);
            Entry entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)fname, (Object)entry.getTitle());
            BaseArtifactType arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertTrue((boolean)(arty instanceof ExtendedDocument));
            ExtendedDocument doc = (ExtendedDocument)arty;
            Assert.assertEquals((Object)fname, (Object)doc.getName());
            Assert.assertEquals((Object)"JpgDocument", (Object)doc.getExtendedType());
            Assert.assertEquals((Object)2398L, (Object)Long.valueOf((String)doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_SIZE_QNAME)));
            Assert.assertEquals((Object)"image/jpeg", doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_TYPE_QNAME));
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
    }
}

