/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.test.simple;

import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.test.AbstractIntegrationTest;

public class SimpleClientTest
extends AbstractIntegrationTest {
    @Test
    public void testSimple() {
        try {
            SrampAtomApiClient client = this.client();
            ExtendedArtifactType artifact = new ExtendedArtifactType();
            artifact.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
            artifact.setExtendedType("FooArtifactType");
            artifact.setName("Foo");
            artifact.setDescription("I'm a Foo");
            BaseArtifactType createdArtifact = client.createArtifact((BaseArtifactType)artifact);
            Assert.assertNotNull((Object)createdArtifact);
            Assert.assertEquals((Object)BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE, (Object)createdArtifact.getArtifactType());
            Assert.assertEquals((Object)"Foo", (Object)createdArtifact.getName());
            Assert.assertEquals((Object)"I'm a Foo", (Object)createdArtifact.getDescription());
            Assert.assertNotNull((Object)createdArtifact.getUuid());
            Assert.assertTrue((createdArtifact.getUuid().length() > 0 ? 1 : 0) != 0);
            BaseArtifactType queriedArtifact = client.getArtifactMetaData(createdArtifact.getUuid());
            Assert.assertNotNull((Object)queriedArtifact);
            Assert.assertEquals((Object)BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE, (Object)queriedArtifact.getArtifactType());
            Assert.assertEquals((Object)"Foo", (Object)queriedArtifact.getName());
            Assert.assertEquals((Object)"I'm a Foo", (Object)queriedArtifact.getDescription());
            Assert.assertEquals((Object)createdArtifact.getUuid(), (Object)queriedArtifact.getUuid());
            QueryResultSet results = client.buildQuery("/s-ramp/ext/FooArtifactType[@name = ?]").parameter("Foo").query();
            Assert.assertEquals((long)1L, (long)results.size());
            ArtifactSummary summary = results.get(0);
            Assert.assertNotNull((Object)summary);
            Assert.assertEquals((Object)"Foo", (Object)summary.getName());
            Assert.assertEquals((Object)"I'm a Foo", (Object)summary.getDescription());
            Assert.assertEquals((Object)createdArtifact.getUuid(), (Object)summary.getUuid());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

