/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.test;

import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.junit.After;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.StoredQuery;
import org.overlord.sramp.atom.client.ClientRequest;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.client.ontology.OntologySummary;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;

@RunWith(value=Arquillian.class)
public abstract class AbstractIntegrationTest {
    private static final String HOST = System.getProperty("sramp.test.host", "localhost");
    private static final int PORT = Integer.parseInt(System.getProperty("sramp.test.port", "8080"));
    private static final String BASE_URL = "http://" + HOST + ":" + PORT + "/s-ramp-server";
    protected static final String USERNAME = System.getProperty("sramp.test.username", "admin");
    protected static final String PASSWORD = System.getProperty("sramp.test.password", "overlord1!");

    @After
    public void cleanup() {
        String uuid;
        SrampAtomApiClient client;
        try {
            client = this.client();
            QueryResultSet results = client.query("/s-ramp", 0, 10000, "name", true);
            for (ArtifactSummary summary : results) {
                uuid = summary.getUuid().replace("urn:uuid:", "");
                BaseArtifactType artifact = client.getArtifactMetaData(uuid);
                if (artifact.getRelationship().size() <= 0 && artifact.getProperty().size() <= 0 && artifact.getClassifiedBy().size() <= 0) continue;
                artifact.getRelationship().clear();
                artifact.getProperty().clear();
                artifact.getClassifiedBy().clear();
                client.updateArtifactMetaData(artifact);
            }
            for (ArtifactSummary summary : results) {
                uuid = summary.getUuid().replace("urn:uuid:", "");
                if (summary.isDerived()) continue;
                client.deleteArtifact(uuid, summary.getType());
            }
        }
        catch (Exception e) {
            Assert.fail((String)"Unable to cleanup test artifacts.");
        }
        try {
            client = this.client();
            List storedQueries = client.getStoredQueries();
            for (StoredQuery storedQuery : storedQueries) {
                client.deleteStoredQuery(storedQuery.getQueryName());
            }
        }
        catch (Exception e) {
            Assert.fail((String)"Unable to cleanup test artifacts.");
        }
        try {
            client = this.client();
            List ontologies = client.getOntologies();
            for (OntologySummary ontology : ontologies) {
                uuid = ontology.getUuid().replace("urn:uuid:", "");
                client.deleteOntology(uuid);
            }
        }
        catch (Exception e) {
            Assert.fail((String)"Unable to cleanup test artifacts.");
        }
    }

    protected String getHost() {
        return HOST;
    }

    protected int getPort() {
        return PORT;
    }

    protected String getUsername() {
        return USERNAME;
    }

    protected String getPassword() {
        return PASSWORD;
    }

    protected SrampAtomApiClient client() throws SrampClientException, SrampAtomException {
        return new SrampAtomApiClient(BASE_URL, USERNAME, PASSWORD, true);
    }

    protected ClientRequest clientRequest(String endpoint) {
        DefaultHttpClient client = new DefaultHttpClient();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(USERNAME, PASSWORD);
        client.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY), (Credentials)credentials);
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        HttpHost targetHost = new HttpHost(HOST, PORT);
        authCache.put(targetHost, (AuthScheme)basicAuth);
        BasicHttpContext localContext = new BasicHttpContext();
        localContext.setAttribute("http.auth.auth-cache", (Object)authCache);
        ApacheHttpClient4Executor executor = new ApacheHttpClient4Executor((HttpClient)client, (HttpContext)localContext);
        ClientRequest clientRequest = new ClientRequest(BASE_URL + endpoint, (ClientExecutor)executor);
        return clientRequest;
    }

    protected String generateURL(String endpoint) {
        return BASE_URL + endpoint;
    }
}

