/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.test.artifactbuilder;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocumentTarget;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.test.AbstractIntegrationTest;

public class BuiltInArtifactBuilderTest
extends AbstractIntegrationTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXsdRelationships() throws Exception {
        InputStream baseContent = null;
        InputStream coreContent = null;
        InputStream xsdContent = null;
        try {
            baseContent = this.getClass().getResourceAsStream("/sample-files/xsd/xlink.xsd");
            coreContent = this.getClass().getResourceAsStream("/sample-files/xsd/coremodel.xsd");
            xsdContent = this.getClass().getResourceAsStream("/sample-files/xsd/xsdmodel.xsd");
            XsdDocument uploadedBaseArtifact = (XsdDocument)this.client().uploadArtifact(ArtifactType.XsdDocument(), baseContent, "xlink.xsd");
            XsdDocument uploadedCoreArtifact = (XsdDocument)this.client().uploadArtifact(ArtifactType.XsdDocument(), coreContent, "coremodel.xsd");
            XsdDocument uploadedXsdArtifact = (XsdDocument)this.client().uploadArtifact(ArtifactType.XsdDocument(), xsdContent, "xsdmodel.xsd");
            Assert.assertEquals((long)1L, (long)uploadedCoreArtifact.getImportedXsds().size());
            Assert.assertEquals((Object)uploadedBaseArtifact.getUuid(), (Object)((XsdDocumentTarget)uploadedCoreArtifact.getImportedXsds().get(0)).getValue());
            Assert.assertEquals((long)1L, (long)uploadedXsdArtifact.getIncludedXsds().size());
            Assert.assertEquals((Object)uploadedCoreArtifact.getUuid(), (Object)((XsdDocumentTarget)uploadedXsdArtifact.getIncludedXsds().get(0)).getValue());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(baseContent);
            IOUtils.closeQuietly(coreContent);
            IOUtils.closeQuietly(xsdContent);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)baseContent);
        IOUtils.closeQuietly((InputStream)coreContent);
        IOUtils.closeQuietly((InputStream)xsdContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRelationshipTargetOrdering() throws Exception {
        InputStream baseContent1 = null;
        InputStream baseContent2 = null;
        InputStream coreContent1 = null;
        InputStream coreContent2 = null;
        try {
            baseContent1 = this.getClass().getResourceAsStream("/sample-files/xsd/xlink.xsd");
            XsdDocument uploadedBaseArtifact1 = (XsdDocument)this.client().uploadArtifact(ArtifactType.XsdDocument(), baseContent1, "xlink.xsd");
            coreContent1 = this.getClass().getResourceAsStream("/sample-files/xsd/coremodel.xsd");
            XsdDocument uploadedCoreArtifact1 = (XsdDocument)this.client().uploadArtifact(ArtifactType.XsdDocument(), coreContent1, "coremodel.xsd");
            baseContent2 = this.getClass().getResourceAsStream("/sample-files/xsd/xlink.xsd");
            XsdDocument uploadedBaseArtifact2 = (XsdDocument)this.client().uploadArtifact(ArtifactType.XsdDocument(), baseContent2, "xlink.xsd");
            coreContent2 = this.getClass().getResourceAsStream("/sample-files/xsd/coremodel.xsd");
            XsdDocument uploadedCoreArtifact2 = (XsdDocument)this.client().uploadArtifact(ArtifactType.XsdDocument(), coreContent2, "coremodel.xsd");
            Assert.assertEquals((long)1L, (long)uploadedCoreArtifact1.getImportedXsds().size());
            Assert.assertEquals((long)1L, (long)uploadedCoreArtifact2.getImportedXsds().size());
            Assert.assertEquals((Object)uploadedBaseArtifact1.getUuid(), (Object)((XsdDocumentTarget)uploadedCoreArtifact1.getImportedXsds().get(0)).getValue());
            Assert.assertEquals((Object)uploadedBaseArtifact2.getUuid(), (Object)((XsdDocumentTarget)uploadedCoreArtifact2.getImportedXsds().get(0)).getValue());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(coreContent1);
            IOUtils.closeQuietly(coreContent2);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)coreContent1);
        IOUtils.closeQuietly((InputStream)coreContent2);
    }
}

