/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.test.artifacttypedetector;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.test.client.AbstractNoAuditingClientTest;

public class SwitchYardArtifactTypeDetectorTest
extends AbstractNoAuditingClientTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSwitchYardIntegration() throws Exception {
        InputStream stream = this.getClass().getResourceAsStream("switchyard-quickstart-bean-service.jar");
        SrampAtomApiClient client = this.client();
        try {
            BaseArtifactType artifact = client.uploadArtifact(stream, "switchyard-quickstart-bean-service.jar");
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals(ExtendedDocument.class, artifact.getClass());
            ExtendedDocument extendedDocument = (ExtendedDocument)artifact;
            Assert.assertEquals((Object)"SwitchYardApplication", (Object)extendedDocument.getExtendedType());
            QueryResultSet results = client.buildQuery("/s-ramp/ext/SwitchYardXmlDocument[@name='orders']").query();
            Assert.assertEquals((long)1L, (long)results.size());
            ArtifactSummary summary = results.get(0);
            Assert.assertNotNull((Object)summary);
            results = client.buildQuery("/s-ramp/ext/JavaClass[@name='org.switchyard.quickstarts.bean.service.InventoryServiceBean']").query();
            Assert.assertEquals((long)1L, (long)results.size());
            summary = results.get(0);
            Assert.assertNotNull((Object)summary);
            results = client.buildQuery("/s-ramp/wsdl/" + BaseArtifactEnum.WSDL_DOCUMENT.value() + "[@name='OrderService.wsdl']").query();
            Assert.assertEquals((long)1L, (long)results.size());
            summary = results.get(0);
            Assert.assertNotNull((Object)summary);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }
}

