/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.test.artifacttypedetector;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.integration.teiid.model.TeiidArtifactType;
import org.overlord.sramp.integration.teiid.model.Vdb;
import org.overlord.sramp.integration.teiid.model.VdbManifest;
import org.overlord.sramp.test.client.AbstractNoAuditingClientTest;

public final class TeiidArtifactTypeDetectorTest
extends AbstractNoAuditingClientTest {
    private void assertManifest(SrampAtomApiClient client) throws Exception {
        QueryResultSet results = client.buildQuery("/s-ramp/ext/" + VdbManifest.ARTIFACT_TYPE.extendedType()).query();
        Assert.assertEquals((long)1L, (long)results.size());
        ArtifactSummary summary = results.get(0);
        Assert.assertNotNull((Object)summary);
    }

    private void assertModel(SrampAtomApiClient client, String filename) throws Exception {
        QueryResultSet results = client.buildQuery("/s-ramp/ext/" + TeiidArtifactType.MODEL.extendedType() + "[@name='" + filename + "']").query();
        Assert.assertEquals((long)1L, (long)results.size());
        ArtifactSummary summary = results.get(0);
        Assert.assertNotNull((Object)summary);
    }

    private void assertXsd(SrampAtomApiClient client, String filename) throws Exception {
        QueryResultSet results = client.buildQuery("/s-ramp/xsd/XsdDocument[@name='" + filename + "']").query();
        Assert.assertEquals((long)1L, (long)results.size());
        ArtifactSummary summary = results.get(0);
        Assert.assertNotNull((Object)summary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBooksVdb() throws Exception {
        SrampAtomApiClient client = this.client();
        InputStream stream = null;
        try {
            stream = this.getClass().getResourceAsStream("BooksVdb.vdb");
            BaseArtifactType artifact = client.uploadArtifact(stream, "BooksVdb.vdb");
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals(ExtendedDocument.class, artifact.getClass());
            ExtendedDocument extendedDocument = (ExtendedDocument)artifact;
            Assert.assertEquals((Object)Vdb.ARTIFACT_TYPE, (Object)extendedDocument.getExtendedType());
            this.assertManifest(client);
            this.assertModel(client, "Books_Oracle.xmi");
            this.assertModel(client, "BooksView_Output_View.xmi");
            this.assertModel(client, "BooksView_WS.xmi");
            this.assertModel(client, "BooksView.xmi");
            this.assertXsd(client, "BooksView_Input.xsd");
            this.assertXsd(client, "BooksView_Output.xsd");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProductsVdb() throws Exception {
        SrampAtomApiClient client = this.client();
        InputStream stream = null;
        try {
            stream = this.getClass().getResourceAsStream("ProductsSS_VDB.vdb");
            BaseArtifactType artifact = client.uploadArtifact(stream, "ProductsSS_VDB.vdb");
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals(ExtendedDocument.class, artifact.getClass());
            ExtendedDocument extendedDocument = (ExtendedDocument)artifact;
            Assert.assertEquals((Object)Vdb.ARTIFACT_TYPE, (Object)extendedDocument.getExtendedType());
            this.assertManifest(client);
            this.assertModel(client, "ProductsSS.xmi");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
    }
}

