/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.test.client;

import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.test.client.AbstractNoAuditingClientTest;

public class SwitchYardClientTest
extends AbstractNoAuditingClientTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUploadArtifact() throws Exception {
        SrampAtomApiClient client = this.client();
        FileInputStream artifactsIS = new FileInputStream("target/sample-files/switchyard/artifacts.jar");
        try {
            ArtifactType artifactType = ArtifactType.valueOf((String)"SwitchYardApplication", (boolean)true);
            client.uploadArtifact(artifactType, (InputStream)artifactsIS, "artifacts.jar");
        }
        finally {
            IOUtils.closeQuietly((InputStream)artifactsIS);
        }
        this.doArtifactsJarAssertions(client);
        FileInputStream orderConsumerIS = new FileInputStream("target/sample-files/switchyard/order-consumer.jar");
        try {
            client.uploadArtifact((InputStream)orderConsumerIS, "order-consumer.jar");
        }
        finally {
            IOUtils.closeQuietly((InputStream)artifactsIS);
        }
        this.doOrderConsumerAssertions(client);
        FileInputStream orderServiceIS = new FileInputStream("target/sample-files/switchyard/order-service.jar");
        try {
            client.uploadArtifact((InputStream)orderServiceIS, "order-service.jar");
        }
        finally {
            IOUtils.closeQuietly((InputStream)artifactsIS);
        }
        this.doOrderServiceAssertions(client);
    }

    private void doArtifactsJarAssertions(SrampAtomApiClient client) throws SrampClientException, SrampAtomException {
        QueryResultSet result = client.buildQuery("/s-ramp/wsdl/WsdlDocument[@name = ?]").parameter("OrderService.wsdl").query();
        Assert.assertEquals((long)1L, (long)result.size());
        result = client.buildQuery("/s-ramp/wsdl/WsdlDocument[@name = ?]").parameter("OrderService.wsdl").query();
        Assert.assertEquals((long)1L, (long)result.size());
        result = client.buildQuery("/s-ramp/xsd/XsdDocument[@name = ?]").parameter("orderTypes.xsd").query();
        Assert.assertEquals((long)1L, (long)result.size());
        result = client.buildQuery("/s-ramp/ext/JavaClass[@packageName = ? and @className = ?]").parameter("org.switchyard.quickstarts.demo.multiapp").parameter("Order").query();
        Assert.assertEquals((long)1L, (long)result.size());
        result = client.buildQuery("/s-ramp/ext/JavaInterface[@packageName = ? and @className = ?]").parameter("org.switchyard.quickstarts.demo.multiapp").parameter("InventoryService").query();
        Assert.assertEquals((long)1L, (long)result.size());
        result = client.buildQuery("/s-ramp/xsd/ElementDeclaration[@namespace = ? and @ncName = ?]").parameter("urn:switchyard-quickstart-demo:multiapp:1.0").parameter("submitOrder").query();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    private void doOrderConsumerAssertions(SrampAtomApiClient client) throws SrampClientException, SrampAtomException {
        QueryResultSet result = client.buildQuery("/s-ramp/ext/SwitchYardXmlDocument").query();
        Assert.assertEquals((long)1L, (long)result.size());
        result = client.buildQuery("/s-ramp/ext/SwitchYardService").query();
        Assert.assertEquals((long)1L, (long)result.size());
        result = client.buildQuery("/s-ramp/ext/SwitchYardComponent").query();
        Assert.assertEquals((long)1L, (long)result.size());
        result = client.buildQuery("/s-ramp/ext/SwitchYardComponent[references]").query();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    private void doOrderServiceAssertions(SrampAtomApiClient client) throws SrampClientException, SrampAtomException {
        QueryResultSet result = client.buildQuery("/s-ramp/ext/SwitchYardXmlDocument").query();
        Assert.assertEquals((long)2L, (long)result.size());
        result = client.buildQuery("/s-ramp/ext/SwitchYardXmlDocument[@name = ?]").parameter("orders").query();
        Assert.assertEquals((long)1L, (long)result.size());
        result = client.buildQuery("/s-ramp/ext/SwitchYardTransformer").query();
        Assert.assertEquals((long)2L, (long)result.size());
        result = client.buildQuery("/s-ramp/ext/SwitchYardTransformer[transformsFrom[@name = ?]]").parameter("org.switchyard.quickstarts.demo.multiapp.OrderAck").query();
        Assert.assertEquals((long)1L, (long)result.size());
        result = client.buildQuery("/s-ramp/ext/SwitchYardTransformer[transformsTo[@ncName = ?]]").parameter("submitOrderResponse").query();
        Assert.assertEquals((long)1L, (long)result.size());
        result = client.buildQuery("/s-ramp/ext/SwitchYardTransformer[transformsFrom[@ncName = ?]]").parameter("submitOrder").query();
        Assert.assertEquals((long)1L, (long)result.size());
        result = client.buildQuery("/s-ramp/ext/SwitchYardTransformer[transformsTo[@name = ?]]").parameter("org.switchyard.quickstarts.demo.multiapp.Order").query();
        Assert.assertEquals((long)1L, (long)result.size());
        result = client.buildQuery("/s-ramp/ext/SwitchYardTransformer[implementedBy[@name = ?]]").parameter("org.switchyard.quickstarts.demo.multiapp.service.Transformers").query();
        Assert.assertEquals((long)2L, (long)result.size());
        result = client.buildQuery("/s-ramp/ext/SwitchYardComponent").query();
        Assert.assertEquals((long)3L, (long)result.size());
        result = client.buildQuery("/s-ramp/ext/SwitchYardComponent[@name = ?]").parameter("OrderService").query();
        Assert.assertEquals((long)1L, (long)result.size());
        result = client.buildQuery("/s-ramp/ext/SwitchYardComponent[@name = ?]/implementedBy").parameter("OrderService").query();
        Assert.assertEquals((long)1L, (long)result.size());
        result = client.buildQuery("/s-ramp/ext/SwitchYardComponent/implementedBy").query();
        Assert.assertEquals((long)2L, (long)result.size());
        result = client.buildQuery("/s-ramp/ext/SwitchYardComponent[implementedBy[@name = ?]]").parameter("org.switchyard.quickstarts.demo.multiapp.service.InventoryServiceBean").query();
        Assert.assertEquals((long)1L, (long)result.size());
        result = client.buildQuery("/s-ramp/ext/SwitchYardComponent[@name = ?]/references").parameter("OrderService").query();
        Assert.assertEquals((long)1L, (long)result.size());
        result = client.buildQuery("/s-ramp/ext/SwitchYardTransformer/transformsFrom").query();
        Assert.assertEquals((long)2L, (long)result.size());
    }
}

