/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.test.events.jms;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.events.ArtifactUpdateEvent;
import org.overlord.sramp.events.OntologyUpdateEvent;
import org.overlord.sramp.test.AbstractIntegrationTest;
import org.w3._1999._02._22_rdf_syntax_ns_.RDF;
import org.w3._2002._07.owl_.Class;
import org.w3._2002._07.owl_.Ontology;

public class JMSEventProducerTest
extends AbstractIntegrationTest {
    private static final String EAP_INITIAL_CONTEXT_FACTORY = "org.jboss.naming.remote.client.InitialContextFactory";
    private static final String EAP_PROVIDER_URL = "remote://localhost:4447";
    private static final String EAP_CONNECTIONFACTORY_JNDI = "jms/RemoteConnectionFactory";
    private static final String EAP_TOPIC_JNDI = "jms/sramp/events/topic";
    private static final String TOMCAT_INITIAL_CONTEXT_FACTORY = "org.apache.activemq.jndi.ActiveMQInitialContextFactory";
    private static final String TOMCAT_PROVIDER_URL = "tcp://localhost:61616";
    private static final String TOMCAT_CONNECTIONFACTORY_JNDI = "ConnectionFactory";
    private static final String TOMCAT_TOPIC_JNDI = "sramp/events/topic";
    private List<TextMessage> textMessages;

    @Test
    public void testArtifactTopic() throws Exception {
        this.textMessages = new ArrayList<TextMessage>();
        CountDownLatch lock = new CountDownLatch(3);
        Connection connection = this.subscribe(lock);
        SrampAtomApiClient client = this.client();
        ExtendedArtifactType artifact = new ExtendedArtifactType();
        artifact.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
        artifact.setExtendedType("FooArtifactType");
        artifact.setName("Foo");
        artifact.setDescription("created");
        ExtendedArtifactType persistedArtifact = (ExtendedArtifactType)client.createArtifact((BaseArtifactType)artifact);
        persistedArtifact.setDescription("updated");
        client.updateArtifactMetaData((BaseArtifactType)persistedArtifact);
        client.deleteArtifact(persistedArtifact.getUuid(), ArtifactType.valueOf((BaseArtifactType)artifact));
        lock.await(10000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)3L, (long)this.textMessages.size());
        ObjectMapper mapper = new ObjectMapper();
        TextMessage textMessage = this.textMessages.get(0);
        Assert.assertNotNull((Object)textMessage);
        Assert.assertEquals((Object)"sramp:artifactCreated", (Object)textMessage.getJMSType());
        Assert.assertTrue((textMessage.getText() != null && textMessage.getText().length() > 0 ? 1 : 0) != 0);
        ExtendedArtifactType eventArtifact = (ExtendedArtifactType)mapper.readValue(textMessage.getText(), ExtendedArtifactType.class);
        Assert.assertNotNull((Object)eventArtifact);
        Assert.assertEquals((Object)artifact.getExtendedType(), (Object)eventArtifact.getExtendedType());
        Assert.assertEquals((Object)artifact.getName(), (Object)eventArtifact.getName());
        Assert.assertEquals((Object)artifact.getDescription(), (Object)eventArtifact.getDescription());
        textMessage = this.textMessages.get(1);
        Assert.assertNotNull((Object)textMessage);
        Assert.assertEquals((Object)"sramp:artifactUpdated", (Object)textMessage.getJMSType());
        Assert.assertTrue((textMessage.getText() != null && textMessage.getText().length() > 0 ? 1 : 0) != 0);
        ArtifactUpdateEvent updateEvent = (ArtifactUpdateEvent)mapper.readValue(textMessage.getText(), ArtifactUpdateEvent.class);
        Assert.assertNotNull((Object)updateEvent);
        Assert.assertNotNull((Object)updateEvent.getOldArtifact());
        Assert.assertNotNull((Object)updateEvent.getUpdatedArtifact());
        Assert.assertEquals((Object)artifact.getExtendedType(), (Object)((ExtendedArtifactType)updateEvent.getOldArtifact()).getExtendedType());
        Assert.assertEquals((Object)artifact.getName(), (Object)updateEvent.getOldArtifact().getName());
        Assert.assertEquals((Object)artifact.getDescription(), (Object)updateEvent.getOldArtifact().getDescription());
        Assert.assertEquals((Object)artifact.getExtendedType(), (Object)((ExtendedArtifactType)updateEvent.getUpdatedArtifact()).getExtendedType());
        Assert.assertEquals((Object)artifact.getName(), (Object)updateEvent.getUpdatedArtifact().getName());
        Assert.assertEquals((Object)persistedArtifact.getDescription(), (Object)updateEvent.getUpdatedArtifact().getDescription());
        textMessage = this.textMessages.get(2);
        Assert.assertNotNull((Object)textMessage);
        Assert.assertEquals((Object)"sramp:artifactDeleted", (Object)textMessage.getJMSType());
        Assert.assertTrue((textMessage.getText() != null && textMessage.getText().length() > 0 ? 1 : 0) != 0);
        eventArtifact = (ExtendedArtifactType)mapper.readValue(textMessage.getText(), ExtendedArtifactType.class);
        Assert.assertNotNull((Object)eventArtifact);
        Assert.assertEquals((Object)artifact.getExtendedType(), (Object)eventArtifact.getExtendedType());
        Assert.assertEquals((Object)artifact.getName(), (Object)eventArtifact.getName());
        Assert.assertEquals((Object)persistedArtifact.getDescription(), (Object)eventArtifact.getDescription());
        connection.close();
    }

    @Test
    public void testOntologyTopic() throws Exception {
        this.textMessages = new ArrayList<TextMessage>();
        CountDownLatch lock = new CountDownLatch(3);
        Connection connection = this.subscribe(lock);
        SrampAtomApiClient client = this.client();
        RDF rdf = new RDF();
        rdf.getOtherAttributes().put(new QName("http://www.w3.org/XML/1998/namespace", "base"), "foo");
        Ontology ontology = new Ontology();
        ontology.setID("Color");
        ontology.setLabel("Color");
        rdf.setOntology(ontology);
        Class clazz1 = new Class();
        clazz1.setID("Red");
        clazz1.setLabel("Red");
        Class clazz2 = new Class();
        clazz2.setID("Blue");
        clazz2.setLabel("Blue");
        rdf.getClazz().add(clazz1);
        rdf.getClazz().add(clazz2);
        RDF persistedRdf = client.addOntology(rdf);
        String uuid = ((String)persistedRdf.getOtherAttributes().get(new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "uuid"))).replace("urn:uuid:", "");
        persistedRdf.getOntology().setLabel("ColorUpdated");
        client.updateOntology(uuid, persistedRdf);
        client.deleteOntology(uuid);
        lock.await(10000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)3L, (long)this.textMessages.size());
        ObjectMapper mapper = new ObjectMapper();
        TextMessage textMessage = this.textMessages.get(0);
        Assert.assertNotNull((Object)textMessage);
        Assert.assertEquals((Object)"sramp:ontologyCreated", (Object)textMessage.getJMSType());
        Assert.assertTrue((textMessage.getText() != null && textMessage.getText().length() > 0 ? 1 : 0) != 0);
        RDF eventRdf = (RDF)mapper.readValue(textMessage.getText(), RDF.class);
        Assert.assertNotNull((Object)eventRdf);
        Assert.assertEquals((Object)rdf.getOntology().getID(), (Object)eventRdf.getOntology().getID());
        Assert.assertEquals((Object)rdf.getOntology().getLabel(), (Object)eventRdf.getOntology().getLabel());
        Assert.assertEquals((long)2L, (long)eventRdf.getClazz().size());
        Assert.assertEquals((Object)clazz1.getID(), (Object)((Class)eventRdf.getClazz().get(0)).getID());
        Assert.assertEquals((Object)clazz1.getLabel(), (Object)((Class)eventRdf.getClazz().get(0)).getLabel());
        Assert.assertEquals((Object)clazz2.getID(), (Object)((Class)eventRdf.getClazz().get(1)).getID());
        Assert.assertEquals((Object)clazz2.getLabel(), (Object)((Class)eventRdf.getClazz().get(1)).getLabel());
        textMessage = this.textMessages.get(1);
        Assert.assertNotNull((Object)textMessage);
        Assert.assertEquals((Object)"sramp:ontologyUpdated", (Object)textMessage.getJMSType());
        Assert.assertTrue((textMessage.getText() != null && textMessage.getText().length() > 0 ? 1 : 0) != 0);
        OntologyUpdateEvent updateEvent = (OntologyUpdateEvent)mapper.readValue(textMessage.getText(), OntologyUpdateEvent.class);
        Assert.assertNotNull((Object)updateEvent);
        Assert.assertNotNull((Object)updateEvent.getOldOntology());
        Assert.assertNotNull((Object)updateEvent.getUpdatedOntology());
        Assert.assertEquals((Object)rdf.getOntology().getID(), (Object)updateEvent.getOldOntology().getOntology().getID());
        Assert.assertEquals((Object)rdf.getOntology().getLabel(), (Object)updateEvent.getOldOntology().getOntology().getLabel());
        Assert.assertEquals((Object)rdf.getOntology().getID(), (Object)updateEvent.getUpdatedOntology().getOntology().getID());
        Assert.assertEquals((Object)persistedRdf.getOntology().getLabel(), (Object)updateEvent.getUpdatedOntology().getOntology().getLabel());
        textMessage = this.textMessages.get(2);
        Assert.assertNotNull((Object)textMessage);
        Assert.assertEquals((Object)"sramp:ontologyDeleted", (Object)textMessage.getJMSType());
        Assert.assertTrue((textMessage.getText() != null && textMessage.getText().length() > 0 ? 1 : 0) != 0);
        eventRdf = (RDF)mapper.readValue(textMessage.getText(), RDF.class);
        Assert.assertNotNull((Object)eventRdf);
        Assert.assertEquals((Object)rdf.getOntology().getID(), (Object)eventRdf.getOntology().getID());
        connection.close();
    }

    private Connection subscribe(CountDownLatch lock) {
        try {
            return this.subscribe(EAP_INITIAL_CONTEXT_FACTORY, EAP_PROVIDER_URL, EAP_CONNECTIONFACTORY_JNDI, EAP_TOPIC_JNDI, lock);
        }
        catch (Exception e) {
            try {
                return this.subscribe(TOMCAT_INITIAL_CONTEXT_FACTORY, TOMCAT_PROVIDER_URL, TOMCAT_CONNECTIONFACTORY_JNDI, TOMCAT_TOPIC_JNDI, lock);
            }
            catch (Exception exception) {
                Assert.fail((String)"Could not create a JMS client.");
                return null;
            }
        }
    }

    private Connection subscribe(String contextFactoryName, String providerUrl, String connectionFactoryName, String topicName, final CountDownLatch lock) throws Exception {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", contextFactoryName);
        env.put("java.naming.provider.url", providerUrl);
        env.put("java.naming.security.principal", USERNAME);
        env.put("java.naming.security.credentials", PASSWORD);
        InitialContext context = new InitialContext(env);
        ConnectionFactory connectionFactory = (ConnectionFactory)context.lookup(connectionFactoryName);
        Connection connection = connectionFactory.createConnection(USERNAME, PASSWORD);
        Session session = connection.createSession(false, 1);
        Topic topic = (Topic)context.lookup(topicName);
        MessageConsumer topicSubscriber = session.createConsumer((Destination)topic);
        topicSubscriber.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                try {
                    JMSEventProducerTest.this.textMessages.add((TextMessage)message);
                    lock.countDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        connection.start();
        return connection;
    }
}

