/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.client;

import com.google.gwt.activity.shared.ActivityManager;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceChangeEvent;
import com.google.gwt.place.shared.PlaceController;
import com.google.gwt.place.shared.PlaceHistoryHandler;
import com.google.gwt.place.shared.PlaceHistoryMapper;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.web.bindery.event.shared.EventBus;
import org.overlord.sramp.ui.client.ActivityMapperImpl;
import org.overlord.sramp.ui.client.IClientFactory;
import org.overlord.sramp.ui.client.places.AbstractPlace;
import org.overlord.sramp.ui.client.places.DashboardPlace;
import org.overlord.sramp.ui.client.services.IServicesListener;
import org.overlord.sramp.ui.client.services.ServiceLifecycleContext;
import org.overlord.sramp.ui.client.services.ServiceList;
import org.overlord.sramp.ui.client.services.Services;
import org.overlord.sramp.ui.client.services.breadcrumb.IBreadcrumbService;
import org.overlord.sramp.ui.client.services.i18n.ILocalizationService;
import org.overlord.sramp.ui.client.services.place.IPlaceService;

public class Application
implements EntryPoint {
    private Place defaultPlace = new DashboardPlace();
    private SimplePanel appWidget = new SimplePanel();

    public void onModuleLoad() {
        final IClientFactory clientFactory = (IClientFactory)GWT.create(IClientFactory.class);
        final EventBus eventBus = clientFactory.getEventBus();
        final PlaceController placeController = clientFactory.getPlaceController();
        ServiceLifecycleContext context = new ServiceLifecycleContext();
        context.setClientFactory(clientFactory);
        context.setEventBus(eventBus);
        Services.init(ServiceList.getRegisteredServices(), context, new IServicesListener(){

            @Override
            public void onAllServicesStarted() {
                IPlaceService placeService = Services.getServices().getService(IPlaceService.class);
                IBreadcrumbService breadcrumbService = Services.getServices().getService(IBreadcrumbService.class);
                final ILocalizationService i18nService = Services.getServices().getService(ILocalizationService.class);
                ActivityMapperImpl activityMapper = new ActivityMapperImpl(clientFactory);
                ActivityManager activityManager = new ActivityManager(activityMapper, eventBus){

                    public void onPlaceChange(PlaceChangeEvent event) {
                        super.onPlaceChange(event);
                        AbstractPlace place = (AbstractPlace)event.getNewPlace();
                        Window.setTitle((String)i18nService.translate(place.getTitleKey(), place.getTitleParams()));
                    }
                };
                activityManager.setDisplay((AcceptsOneWidget)Application.this.appWidget);
                PlaceHistoryMapper historyMapper = placeService.getPlaceHistoryMapper();
                PlaceHistoryHandler historyHandler = new PlaceHistoryHandler(historyMapper);
                historyHandler.register(placeController, eventBus, Application.this.defaultPlace);
                RootPanel breadcrumbWrapperDiv = RootPanel.get((String)"breadcrumb-wrapper");
                breadcrumbWrapperDiv.add((Widget)breadcrumbService.getBreadcrumbPanel());
                RootPanel contentDiv = Application.this.getContentDiv();
                contentDiv.add((Widget)Application.this.appWidget);
                historyHandler.handleCurrentHistory();
            }

            @Override
            public void onError(Throwable error) {
                RootPanel contentDiv = Application.this.getContentDiv();
                contentDiv.add((Widget)new HTMLPanel("<p>An error was encountered while loading the application, please try reloading.  If the error persists, contact your administrator.</p><br/><br/><p><b><i>" + error.getMessage() + "</i></b></p>"));
            }
        });
    }

    protected RootPanel getContentDiv() {
        RootPanel contentDiv = RootPanel.get((String)"content");
        Element contentDivElement = contentDiv.getElement();
        NodeList childNodes = contentDivElement.getChildNodes();
        for (int i = childNodes.getLength() - 1; i >= 0; --i) {
            contentDivElement.removeChild(childNodes.getItem(i));
        }
        contentDiv.clear();
        return contentDiv;
    }
}

