/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.client.animation;

import com.google.gwt.user.client.ui.Widget;
import org.overlord.sramp.ui.client.animation.AbstractAnimation;

public class MoveAnimation
extends AbstractAnimation {
    private String property;
    private int from;
    private int to;

    public MoveAnimation(Widget targetWidget, String property, int from, int to) {
        super(targetWidget);
        this.setProperty(property);
        this.setFrom(from);
        this.setTo(to);
    }

    protected void onUpdate(double progress) {
        int distance = this.getTo() - this.getFrom();
        int delta = (int)((double)distance * progress);
        int newPos = this.getFrom() + delta;
        this.getTargetWidget().getElement().getStyle().setProperty(this.getProperty(), newPos + "px");
    }

    @Override
    protected void doOnCancel() {
        this.getTargetWidget().getElement().getStyle().setProperty(this.getProperty(), this.getFrom() + "px");
    }

    @Override
    protected void doOnComplete() {
        this.getTargetWidget().getElement().getStyle().setProperty(this.getProperty(), this.getTo() + "px");
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public int getFrom() {
        return this.from;
    }

    public void setFrom(int from) {
        this.from = from;
    }

    public int getTo() {
        return this.to;
    }

    public void setTo(int to) {
        this.to = to;
    }
}

