/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.client.services.growl;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.overlord.sramp.ui.client.animation.FadeOutAnimation;
import org.overlord.sramp.ui.client.animation.MoveAnimation;
import org.overlord.sramp.ui.client.services.AbstractService;
import org.overlord.sramp.ui.client.services.Services;
import org.overlord.sramp.ui.client.services.growl.Growl;
import org.overlord.sramp.ui.client.services.growl.GrowlType;
import org.overlord.sramp.ui.client.services.growl.IGrowlService;
import org.overlord.sramp.ui.client.services.i18n.ILocalizationService;
import org.overlord.sramp.ui.client.widgets.dialogs.ErrorDialog;
import org.overlord.sramp.ui.client.widgets.dialogs.GrowlDialog;
import org.overlord.sramp.ui.shared.rsvcs.RemoteServiceException;

public class GrowlService
extends AbstractService
implements IGrowlService {
    private List<Growl> activeGrowls = new ArrayList<Growl>();
    private List<Growl> completedGrowls = new ArrayList<Growl>();
    private int growlCounter = 0;

    @Override
    public int growl(String title, String message) {
        return this.growl(title, message, GrowlType.notification);
    }

    @Override
    public int growl(String title, String message, GrowlType type) {
        Growl growl = this.createGrowl(title, message);
        this.createGrowlDialog(growl, title, message, type);
        this.createGrowlTimers(growl);
        this.createGrowlAnimations(growl);
        this.positionAndShowGrowlDialog(growl);
        if (type == GrowlType.notification) {
            growl.getAliveTimer().schedule(5000);
        }
        return growl.getId();
    }

    @Override
    public int growl(String title, String message, RemoteServiceException error) {
        Growl growl = this.createGrowl(title, message);
        this.createGrowlDialog(growl, title, message, GrowlType.error);
        this.createGrowlTimers(growl);
        this.createGrowlAnimations(growl);
        Widget wrapper = this.createErrorGrowlWidget(title, message, error);
        growl.getDialog().setMessage(wrapper, GrowlType.error);
        this.positionAndShowGrowlDialog(growl);
        return growl.getId();
    }

    @Override
    public void onProgressComplete(int growlId, String title, String message) {
        Growl growl = this.getGrowl(growlId);
        if (growl != null) {
            growl.getDialog().setTitle(title);
            growl.getDialog().setMessage(message, GrowlType.notification);
            growl.getAliveTimer().schedule(5000);
        }
    }

    @Override
    public void onProgressComplete(int growlId, String title, Widget message) {
        Growl growl = this.getGrowl(growlId);
        if (growl != null) {
            growl.getDialog().setTitle(title);
            growl.getDialog().setMessage(message, GrowlType.notification);
            growl.getAliveTimer().schedule(5000);
        }
    }

    @Override
    public void onProgressError(int growlId, String title, String message) {
        Growl growl = this.getGrowl(growlId);
        if (growl != null) {
            growl.getDialog().setTitle(title);
            growl.getDialog().setMessage(message, GrowlType.error);
        }
    }

    @Override
    public void onProgressError(int growlId, String title, RemoteServiceException error) {
        Growl growl = this.getGrowl(growlId);
        if (growl != null) {
            growl.getDialog().setTitle(title);
            Widget message = this.createErrorGrowlWidget(title, error.getMessage(), error);
            growl.getDialog().setMessage(message, GrowlType.error);
        }
    }

    private Growl getGrowl(int growlId) {
        Growl growl = null;
        for (Growl g : this.activeGrowls) {
            if (g.getId() != growlId) continue;
            growl = g;
        }
        return growl;
    }

    protected void onGrowlClosed(Growl growl) {
        this.activeGrowls.remove(growl);
        this.completedGrowls.add(growl);
        growl.setDialog(null);
        this.repositionGrowls();
    }

    private void repositionGrowls() {
        for (int growlIndex = 0; growlIndex < this.activeGrowls.size(); ++growlIndex) {
            Growl growl = this.activeGrowls.get(growlIndex);
            if (growl.getGrowlIndex() == growlIndex) continue;
            this.moveGrowl(growl, growl.getGrowlIndex(), growlIndex);
        }
    }

    private void moveGrowl(Growl growl, int fromGrowlIndex, int toGrowlIndex) {
        int fromBottom = -1;
        try {
            fromBottom = new Integer(growl.getDialog().getElement().getStyle().getBottom().split("px")[0]);
        }
        catch (Throwable t) {
            fromBottom = 80 * fromGrowlIndex + 5;
        }
        int toBottom = 80 * toGrowlIndex + 5;
        MoveAnimation animation = new MoveAnimation((Widget)growl.getDialog(), "bottom", fromBottom, toBottom);
        animation.run(200);
        growl.setGrowlIndex(toGrowlIndex);
    }

    private void positionAndShowGrowlDialog(Growl growl) {
        GrowlDialog dialog = growl.getDialog();
        int growlIndex = growl.getGrowlIndex();
        dialog.getElement().getStyle().setVisibility(Style.Visibility.HIDDEN);
        dialog.show();
        int bottom = 80 * growlIndex + 5;
        int right = 5;
        dialog.getElement().getStyle().setPosition(Style.Position.FIXED);
        dialog.getElement().getStyle().setBottom((double)bottom, Style.Unit.PX);
        dialog.getElement().getStyle().setRight((double)right, Style.Unit.PX);
        dialog.getElement().getStyle().setProperty("left", null);
        dialog.getElement().getStyle().setProperty("top", null);
        dialog.getElement().getStyle().setVisibility(Style.Visibility.VISIBLE);
    }

    private Growl createGrowl(String title, String message) {
        Growl growl = new Growl(this.growlCounter++, title, message);
        int growlIndex = this.activeGrowls.size();
        growl.setGrowlIndex(growlIndex);
        this.activeGrowls.add(growl);
        return growl;
    }

    private void createGrowlDialog(final Growl growl, String title, String message, GrowlType type) {
        GrowlDialog dialog = new GrowlDialog(title, message, type){

            @Override
            protected void onMouseIn() {
                super.onMouseIn();
                growl.getAliveTimer().cancel();
                growl.getAutoCloseAnimation().cancel();
            }

            @Override
            protected void onMouseOut() {
                super.onMouseOut();
                if (this.getGrowlType() == GrowlType.notification) {
                    growl.getAliveTimer().schedule(5000);
                }
            }
        };
        growl.setDialog(dialog);
        dialog.addCloseHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                growl.getAliveTimer().cancel();
                GrowlService.this.onGrowlClosed(growl);
            }
        });
    }

    private void createGrowlTimers(final Growl growl) {
        Timer aliveTimer = new Timer(){

            public void run() {
                growl.getAutoCloseAnimation().run(1000);
            }
        };
        growl.setAliveTimer(aliveTimer);
    }

    private void createGrowlAnimations(final Growl growl) {
        FadeOutAnimation fadeOut = new FadeOutAnimation((Widget)growl.getDialog()){

            @Override
            protected void doOnComplete() {
                growl.getDialog().hide();
                GrowlService.this.onGrowlClosed(growl);
            }
        };
        growl.setAutoCloseAnimation(fadeOut);
    }

    private Widget createErrorGrowlWidget(final String title, final String message, final RemoteServiceException error) {
        ILocalizationService i18n = Services.getServices().getService(ILocalizationService.class);
        FlowPanel wrapper = new FlowPanel();
        wrapper.add((Widget)new InlineLabel(message));
        wrapper.add((Widget)new InlineLabel(" "));
        Anchor anchor = new Anchor(i18n.translate("services.growl.errorDetails", new Object[0]));
        anchor.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ErrorDialog errorDialog = new ErrorDialog(title, message, error);
                errorDialog.center();
                errorDialog.show();
            }
        });
        wrapper.add((Widget)anchor);
        return wrapper;
    }
}

